/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class ObjectFuzzer
extends AbstractFuzzer {
    ObjectFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int objectLength;
        Node objectLit = new Node(64);
        int remainingBudget = budget - 1;
        if (remainingBudget < 0) {
            remainingBudget = 0;
        }
        if ((objectLength = this.generateLength(remainingBudget / 2)) == 0) {
            return objectLit;
        }
        Object[] fuzzers = new ExpressionFuzzer[objectLength];
        Arrays.fill(fuzzers, new ExpressionFuzzer(this.context));
        Node[] values = this.distribute(remainingBudget -= objectLength, (AbstractFuzzer[])fuzzers);
        for (int i = 0; i < objectLength; ++i) {
            String name = this.context.random.nextInt(2) == 0 ? this.context.snGenerator.getPropertyName() : String.valueOf(this.context.snGenerator.getRandomNumber());
            Node key = Node.newString(154, name);
            key.addChildrenToFront(values[i]);
            objectLit.addChildToBack(key);
        }
        return objectLit;
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 1;
    }

    @Override
    protected String getConfigName() {
        return "object";
    }

    @Override
    protected Set<Type> supportedTypes() {
        return Sets.immutableEnumSet((Enum)Type.OBJECT, (Enum[])new Type[0]);
    }
}

