/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

class CoalesceVariableNames
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Deque<GraphColoring<Scope.Var, Void>> colorings;
    private final boolean usePseudoNames;
    private static final Comparator<Scope.Var> coloringTieBreaker = new Comparator<Scope.Var>(){

        @Override
        public int compare(Scope.Var v1, Scope.Var v2) {
            return v1.index - v2.index;
        }
    };

    CoalesceVariableNames(AbstractCompiler compiler, boolean usePseudoNames) {
        Preconditions.checkState((!compiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = compiler;
        this.colorings = Lists.newLinkedList();
        this.usePseudoNames = usePseudoNames;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private static boolean shouldOptimizeScope(Scope scope) {
        if (scope.isGlobal()) {
            return false;
        }
        return 100 >= scope.getVarCount();
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Scope scope = t.getScope();
        if (!CoalesceVariableNames.shouldOptimizeScope(scope)) {
            return;
        }
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        LiveVariablesAnalysis liveness = new LiveVariablesAnalysis(cfg, scope, this.compiler);
        if (scope.getRootNode().getFirstChild().getNext().getChildCount() == 2) {
            liveness.markAllParametersEscaped();
        }
        liveness.analyze();
        UndiGraph<Scope.Var, Void> interferenceGraph = this.computeVariableNamesInterferenceGraph(t, cfg, liveness.getEscapedLocals());
        GraphColoring.GreedyGraphColoring<Scope.Var, Void> coloring = new GraphColoring.GreedyGraphColoring<Scope.Var, Void>(interferenceGraph, coloringTieBreaker);
        ((GraphColoring)coloring).color();
        this.colorings.push(coloring);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!CoalesceVariableNames.shouldOptimizeScope(t.getScope())) {
            return;
        }
        this.colorings.pop();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.colorings.isEmpty() || !n.isName() || parent.isFunction()) {
            return;
        }
        Scope.Var var = t.getScope().getVar(n.getString());
        GraphNode<Scope.Var, Void> vNode = this.colorings.peek().getGraph().getNode(var);
        if (vNode == null) {
            return;
        }
        Scope.Var coalescedVar = this.colorings.peek().getPartitionSuperNode(var);
        if (!this.usePseudoNames) {
            if (vNode.getValue().equals(coalescedVar)) {
                return;
            }
            n.setString(coalescedVar.name);
            this.compiler.reportCodeChange();
            if (parent.isVar()) {
                this.removeVarDeclaration(n);
            }
        } else {
            String pseudoName = null;
            TreeSet allMergedNames = Sets.newTreeSet();
            Iterator<Scope.Var> i = t.getScope().getVars();
            while (i.hasNext()) {
                Scope.Var iVar = i.next();
                if (this.colorings.peek().getGraph().getNode(iVar) == null || !coalescedVar.equals(this.colorings.peek().getPartitionSuperNode(iVar))) continue;
                allMergedNames.add(iVar.name);
            }
            if (allMergedNames.size() == 1) {
                return;
            }
            pseudoName = Joiner.on((String)"_").join((Iterable)allMergedNames);
            while (t.getScope().isDeclared(pseudoName, true)) {
                pseudoName = pseudoName + "$";
            }
            n.setString(pseudoName);
            this.compiler.reportCodeChange();
            if (!vNode.getValue().equals(coalescedVar) && parent.isVar()) {
                this.removeVarDeclaration(n);
            }
        }
    }

    private UndiGraph<Scope.Var, Void> computeVariableNamesInterferenceGraph(NodeTraversal t, ControlFlowGraph<Node> cfg, Set<Scope.Var> escaped) {
        LinkedUndirectedGraph<Scope.Var, Void> interferenceGraph = LinkedUndirectedGraph.create();
        Scope scope = t.getScope();
        Iterator<Scope.Var> i = scope.getVars();
        while (i.hasNext()) {
            Scope.Var v = i.next();
            if (escaped.contains(v) || v.getParentNode().isFunction()) continue;
            ((Graph)interferenceGraph).createNode(v);
        }
        Iterator<Scope.Var> i1 = scope.getVars();
        while (i1.hasNext()) {
            Scope.Var v1 = i1.next();
            Iterator<Scope.Var> i2 = scope.getVars();
            block2: while (i2.hasNext()) {
                DataFlowAnalysis.FlowState state;
                Scope.Var v2 = i2.next();
                if (v1.index >= v2.index || !interferenceGraph.hasNode(v1) || !interferenceGraph.hasNode(v2)) continue;
                if (v1.getParentNode().isParamList() && v2.getParentNode().isParamList()) {
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode) || (!((LiveVariablesAnalysis.LiveVariableLattice)(state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation()).getIn()).isLive(v1) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getIn()).isLive(v2)) && (!((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v1) || !((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v2))) continue;
                    interferenceGraph.connectIfNotFound(v1, null, v2);
                    continue block2;
                }
                for (DiGraph.DiGraphNode cfgNode : cfg.getDirectedGraphNodes()) {
                    if (cfg.isImplicitReturn(cfgNode)) continue;
                    state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
                    boolean v1OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v1);
                    boolean v2OutLive = ((LiveVariablesAnalysis.LiveVariableLattice)state.getOut()).isLive(v2);
                    CombinedLiveRangeChecker checker = new CombinedLiveRangeChecker(new LiveRangeChecker(v1, v2OutLive ? null : v2), new LiveRangeChecker(v2, v1OutLive ? null : v1));
                    NodeTraversal.traverse(this.compiler, (Node)cfgNode.getValue(), checker);
                    if (!checker.connectIfCrossed(interferenceGraph)) continue;
                    continue block2;
                }
            }
        }
        return interferenceGraph;
    }

    private void removeVarDeclaration(Node name) {
        Node var = name.getParent();
        Node parent = var.getParent();
        if (NodeUtil.isForIn(parent)) {
            var.removeChild(name);
            parent.replaceChild(var, name);
        } else if (var.hasOneChild()) {
            if (name.hasChildren()) {
                Node value = name.removeFirstChild();
                var.removeChild(name);
                Node assign = IR.assign(name, value).srcref(name);
                if (!parent.isFor()) {
                    assign = NodeUtil.newExpr(assign);
                }
                parent.replaceChild(var, assign);
            } else {
                NodeUtil.removeChild(parent, var);
            }
        } else if (!name.hasChildren()) {
            var.removeChild(name);
        }
    }

    private static class LiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        boolean defFound = false;
        boolean crossed = false;
        private final Scope.Var def;
        private final Scope.Var use;

        public LiveRangeChecker(Scope.Var def, Scope.Var use) {
            this.def = def;
            this.use = use;
        }

        Scope.Var getDef() {
            return this.def;
        }

        public static boolean shouldVisit(Node n) {
            return n.isName() || n.hasChildren() && n.getFirstChild().isName();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!this.defFound && LiveRangeChecker.isAssignTo(this.def, n, parent)) {
                this.defFound = true;
            }
            if (this.defFound && (this.use == null || LiveRangeChecker.isReadFrom(this.use, n))) {
                this.crossed = true;
            }
        }

        private static boolean isAssignTo(Scope.Var var, Node n, Node parent) {
            if (n.isName() && var.getName().equals(n.getString()) && parent != null) {
                if (parent.isParamList()) {
                    return true;
                }
                if (parent.isVar()) {
                    return n.hasChildren();
                }
                return false;
            }
            Node name = n.getFirstChild();
            return name != null && name.isName() && var.getName().equals(name.getString()) && NodeUtil.isAssignmentOp(n);
        }

        private static boolean isReadFrom(Scope.Var var, Node name) {
            return name != null && name.isName() && var.getName().equals(name.getString()) && !NodeUtil.isVarOrSimpleAssignLhs(name, name.getParent());
        }
    }

    private static class CombinedLiveRangeChecker
    extends ControlFlowGraph.AbstractCfgNodeTraversalCallback {
        private final LiveRangeChecker callback1;
        private final LiveRangeChecker callback2;

        CombinedLiveRangeChecker(LiveRangeChecker callback1, LiveRangeChecker callback2) {
            this.callback1 = callback1;
            this.callback2 = callback2;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (LiveRangeChecker.shouldVisit(n)) {
                this.callback1.visit(t, n, parent);
                this.callback2.visit(t, n, parent);
            }
        }

        boolean connectIfCrossed(UndiGraph<Scope.Var, Void> interferenceGraph) {
            if (this.callback1.crossed || this.callback2.crossed) {
                Scope.Var v1 = this.callback1.getDef();
                Scope.Var v2 = this.callback2.getDef();
                interferenceGraph.connectIfNotFound(v1, null, v2);
                return true;
            }
            return false;
        }
    }
}

