/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class RescopeGlobalSymbols
implements CompilerPass {
    private static final String DISAMBIGUATION_SUFFIX = "$";
    private static final String WINDOW = "window";
    private static final Set<String> SPECIAL_EXTERNS = ImmutableSet.of((Object)"window", (Object)"eval", (Object)"arguments", (Object)"Object", (Object)"Function", (Object)"Array", (Object[])new String[]{"String", "Boolean", "Number", "Math", "Date", "RegExp", "JSON", "Error", "EvalError", "ReferenceError", "SyntaxError", "TypeError", "URIError"});
    private final AbstractCompiler compiler;
    private final String globalSymbolNamespace;
    private final boolean addExtern;
    private final Set<String> crossModuleNames = Sets.newHashSet();
    @VisibleForTesting
    static boolean assumeCrossModuleNames = false;

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace, boolean addExtern) {
        this.compiler = compiler;
        this.globalSymbolNamespace = globalSymbolNamespace;
        this.addExtern = addExtern;
    }

    RescopeGlobalSymbols(AbstractCompiler compiler, String globalSymbolNamespace) {
        this(compiler, globalSymbolNamespace, true);
    }

    private boolean isCrossModuleName(String name) {
        return assumeCrossModuleNames || this.crossModuleNames.contains(name);
    }

    private void addExternForGlobalSymbolNamespace() {
        Node varNode = IR.var(IR.name(this.globalSymbolNamespace));
        CompilerInput input = this.compiler.newExternInput("{RescopeGlobalSymbolsNamespaceVar}");
        input.getAstRoot(this.compiler).addChildrenToBack(varNode);
        this.compiler.reportCodeChange();
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.addExtern) {
            this.addExternForGlobalSymbolNamespace();
        }
        NodeTraversal.traverse(this.compiler, root, new RewriteGlobalFunctionStatementsToVarAssignmentsCallback());
        NodeTraversal.traverse(this.compiler, root, new FindCrossModuleNamesCallback());
        NodeTraversal.traverse(this.compiler, root, new RewriteScopeCallback());
        NodeTraversal.traverse(this.compiler, root, new RemoveGlobalVarCallback());
        NodeTraversal.traverse(this.compiler, root, new MakeExternsReferenceWindowExplicitly());
    }

    private class MakeExternsReferenceWindowExplicitly
    extends NodeTraversal.AbstractPostOrderCallback {
        private MakeExternsReferenceWindowExplicitly() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isName()) {
                return;
            }
            String name = n.getString();
            if (RescopeGlobalSymbols.this.globalSymbolNamespace.equals(name) || SPECIAL_EXTERNS.contains(name)) {
                return;
            }
            Scope.Var var = t.getScope().getVar(name);
            if (name.length() > 0 && (var == null || var.isExtern())) {
                parent.replaceChild(n, IR.getprop(IR.name(RescopeGlobalSymbols.WINDOW), IR.string(name)).srcrefTree(n));
                RescopeGlobalSymbols.this.compiler.reportCodeChange();
            }
        }
    }

    private class RemoveGlobalVarCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RemoveGlobalVarCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isVar()) {
                return;
            }
            ArrayList<Node> commas = new ArrayList<Node>();
            ArrayList<Node> interestingChildren = new ArrayList<Node>();
            boolean allName = true;
            for (Node c : n.children()) {
                if (!c.isName()) {
                    allName = false;
                }
                if (!c.isAssign() && !parent.isFor()) continue;
                interestingChildren.add(c);
            }
            if (allName) {
                return;
            }
            for (Node c : interestingChildren) {
                if (parent.isFor() && parent.getFirstChild() == n) {
                    commas.add(c.cloneTree());
                    continue;
                }
                Node expr = IR.exprResult(c.cloneTree()).srcref(c);
                parent.addChildBefore(expr, n);
            }
            if (commas.size() > 0) {
                Node comma = this.joinOnComma(commas, n);
                parent.addChildBefore(comma, n);
            }
            parent.removeChild(n);
            RescopeGlobalSymbols.this.compiler.reportCodeChange();
        }

        private Node joinOnComma(List<Node> commas, Node source) {
            Node comma = commas.get(0);
            for (int i = 1; i < commas.size(); ++i) {
                Node nextComma = IR.comma(comma, commas.get(i));
                nextComma.copyInformationFrom(source);
                comma = nextComma;
            }
            return comma;
        }
    }

    private class RewriteScopeCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteScopeCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isName()) {
                return;
            }
            String name = n.getString();
            if (parent.isFunction() && name.length() == 0) {
                return;
            }
            Scope.Var var = t.getScope().getVar(name);
            if (var == null) {
                return;
            }
            if (var.isExtern()) {
                return;
            }
            if (!(var.isExtern() || var.isGlobal() || !name.equals(RescopeGlobalSymbols.this.globalSymbolNamespace) && name.indexOf(RescopeGlobalSymbols.this.globalSymbolNamespace + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX) != 0)) {
                n.setString(name + RescopeGlobalSymbols.DISAMBIGUATION_SUFFIX);
                RescopeGlobalSymbols.this.compiler.reportCodeChange();
            }
            if (!var.isGlobal()) {
                return;
            }
            Node nameNode = var.getNameNode();
            if (nameNode != null && nameNode.getParent() != null && nameNode.getParent().isCatch()) {
                return;
            }
            this.replaceSymbol(n, name, t.getInput());
        }

        private void replaceSymbol(Node node, String name, CompilerInput input) {
            Node parent = node.getParent();
            boolean isCrossModule = RescopeGlobalSymbols.this.isCrossModuleName(name);
            if (!isCrossModule) {
                if (!parent.isVar()) {
                    return;
                }
                boolean hasCrossModuleChildren = false;
                for (Node c : parent.children()) {
                    if (c.isName() && !RescopeGlobalSymbols.this.isCrossModuleName(c.getString())) continue;
                    hasCrossModuleChildren = true;
                    break;
                }
                if (!hasCrossModuleChildren) {
                    return;
                }
            }
            Node replacement = isCrossModule ? IR.getprop(IR.name(RescopeGlobalSymbols.this.globalSymbolNamespace).srcref(node), IR.string(name).srcref(node)) : IR.name(name).srcref(node);
            replacement.srcref(node);
            if (node.hasChildren()) {
                Node assign = IR.assign(replacement, node.removeFirstChild());
                parent.replaceChild(node, assign);
            } else if (isCrossModule) {
                parent.replaceChild(node, replacement);
            }
            if (!isCrossModule && parent.isVar()) {
                input.getAstRoot(RescopeGlobalSymbols.this.compiler).addChildToFront(IR.var(IR.name(name).srcref(node)).srcref(node));
            }
            RescopeGlobalSymbols.this.compiler.reportCodeChange();
        }
    }

    private class FindCrossModuleNamesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindCrossModuleNamesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if ("".equals(name) || RescopeGlobalSymbols.this.crossModuleNames.contains(name)) {
                    return;
                }
                Scope s = t.getScope();
                Scope.Var v = s.getVar(name);
                if (v == null || !v.isGlobal()) {
                    return;
                }
                CompilerInput input = v.getInput();
                if (input == null) {
                    RescopeGlobalSymbols.this.crossModuleNames.add(name);
                    return;
                }
                JSModule module = input.getModule();
                if (module != t.getModule()) {
                    RescopeGlobalSymbols.this.crossModuleNames.add(name);
                }
            }
        }
    }

    private class RewriteGlobalFunctionStatementsToVarAssignmentsCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private RewriteGlobalFunctionStatementsToVarAssignmentsCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                String name = NodeUtil.getFunctionName(n);
                n.getFirstChild().setString("");
                Node prev = parent.getChildBefore(n);
                n.detachFromParent();
                Node var = NodeUtil.newVarNode(name, n);
                if (prev == null) {
                    parent.addChildToFront(var);
                } else {
                    parent.addChildAfter(var, prev);
                }
                RescopeGlobalSymbols.this.compiler.reportCodeChange();
            }
        }
    }
}

