/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.SourceExcerptProvider;
import java.util.Set;

public abstract class AbstractMessageFormatter
implements MessageFormatter {
    private final SourceExcerptProvider source;
    private boolean colorize;
    private static final Set<String> SUPPORTED_COLOR_TERMINALS = ImmutableSet.of((Object)"xterm", (Object)"xterm-color", (Object)"xterm-256color", (Object)"screen-bce");

    public AbstractMessageFormatter(SourceExcerptProvider source) {
        this.source = source;
    }

    public void setColorize(boolean colorize) {
        this.colorize = colorize;
    }

    protected final SourceExcerptProvider getSource() {
        return this.source;
    }

    static boolean termSupportsColor(String term) {
        return SUPPORTED_COLOR_TERMINALS.contains(term);
    }

    String getLevelName(CheckLevel level) {
        switch (level) {
            case ERROR: {
                return this.maybeColorize("ERROR", Color.ERROR);
            }
            case WARNING: {
                return this.maybeColorize("WARNING", Color.WARNING);
            }
        }
        return level.toString();
    }

    private String maybeColorize(String text, Color color) {
        if (!this.colorize) {
            return text;
        }
        return color.getControlCharacter() + text + Color.RESET.getControlCharacter();
    }

    private static enum Color {
        ERROR("\u001b[31m"),
        WARNING("\u001b[35m"),
        RESET("\u001b[39m");

        private final String controlCharacter;

        private Color(String controlCharacter) {
            this.controlCharacter = controlCharacter;
        }

        public String getControlCharacter() {
            return this.controlCharacter;
        }
    }
}

