/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.List;

class NamedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String reference;
    private final String sourceName;
    private final int lineno;
    private final int charno;
    private Predicate<JSType> validator;
    private List<PropertyContinuation> propertyContinuations = null;

    NamedType(JSTypeRegistry registry, String reference, String sourceName, int lineno, int charno) {
        super(registry, registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        Preconditions.checkNotNull((Object)reference);
        this.reference = reference;
        this.sourceName = sourceName;
        this.lineno = lineno;
        this.charno = charno;
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (!this.isResolved()) {
            if (this.propertyContinuations == null) {
                this.propertyContinuations = Lists.newArrayList();
            }
            this.propertyContinuations.add(new PropertyContinuation(propertyName, type, inferred, propertyNode));
            return true;
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    private void finishPropertyContinuations() {
        ObjectType referencedObjType = this.getReferencedObjTypeInternal();
        if (referencedObjType != null && !referencedObjType.isUnknownType() && this.propertyContinuations != null) {
            for (PropertyContinuation c : this.propertyContinuations) {
                c.commit(this);
            }
        }
        this.propertyContinuations = null;
    }

    public JSType getReferencedType() {
        return this.getReferencedTypeInternal();
    }

    @Override
    public String getReferenceName() {
        return this.reference;
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.reference;
    }

    @Override
    public boolean hasReferenceName() {
        return true;
    }

    @Override
    boolean isNamedType() {
        return true;
    }

    @Override
    public boolean isNominalType() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.reference.hashCode();
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> enclosing) {
        boolean resolved = this.resolveViaRegistry(t);
        if (this.detectInheritanceCycle()) {
            this.handleTypeCycle(t);
        }
        if (resolved) {
            super.resolveInternal(t, enclosing);
            this.finishPropertyContinuations();
            return this.registry.isLastGeneration() ? this.getReferencedType() : this;
        }
        this.resolveViaProperties(t, enclosing);
        if (this.detectInheritanceCycle()) {
            this.handleTypeCycle(t);
        }
        super.resolveInternal(t, enclosing);
        if (this.isResolved()) {
            this.finishPropertyContinuations();
        }
        return this.registry.isLastGeneration() ? this.getReferencedType() : this;
    }

    private boolean resolveViaRegistry(ErrorReporter reporter) {
        JSType type = this.registry.getType(this.reference);
        if (type != null) {
            this.setReferencedAndResolvedType(type, reporter);
            return true;
        }
        return false;
    }

    private void resolveViaProperties(ErrorReporter reporter, StaticScope<JSType> enclosing) {
        JSType value = this.lookupViaProperties(reporter, enclosing);
        if (value != null && value.isFunctionType() && (value.isConstructor() || value.isInterface())) {
            FunctionType functionType = value.toMaybeFunctionType();
            this.setReferencedAndResolvedType(functionType.getInstanceType(), reporter);
        } else if (value != null && value.isNoObjectType()) {
            this.setReferencedAndResolvedType(this.registry.getNativeFunctionType(JSTypeNative.NO_OBJECT_TYPE).getInstanceType(), reporter);
        } else if (value instanceof EnumType) {
            this.setReferencedAndResolvedType(((EnumType)value).getElementsType(), reporter);
        } else {
            this.handleUnresolvedType(reporter, value == null || value.isUnknownType());
        }
    }

    private JSType lookupViaProperties(ErrorReporter reporter, StaticScope<JSType> enclosing) {
        String[] componentNames = this.reference.split("\\.", -1);
        if (componentNames[0].length() == 0) {
            return null;
        }
        StaticSlot<JSType> slot = enclosing.getSlot(componentNames[0]);
        if (slot == null) {
            return null;
        }
        JSType slotType = slot.getType();
        if (slotType == null || slotType.isAllType() || slotType.isNoType()) {
            return null;
        }
        JSType value = this.getTypedefType(reporter, slot);
        if (value == null) {
            return null;
        }
        for (int i = 1; i < componentNames.length; ++i) {
            ObjectType parentClass = ObjectType.cast(value);
            if (parentClass == null) {
                return null;
            }
            if (componentNames[i].length() == 0) {
                return null;
            }
            value = parentClass.getPropertyType(componentNames[i]);
        }
        return value;
    }

    private void setReferencedAndResolvedType(JSType type, ErrorReporter reporter) {
        if (this.validator != null) {
            this.validator.apply((Object)type);
        }
        this.setReferencedType(type);
        this.checkEnumElementCycle(reporter);
        this.checkProtoCycle(reporter);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void handleTypeCycle(ErrorReporter t) {
        this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        t.warning("Cycle detected in inheritance chain of type " + this.reference, this.sourceName, this.lineno, this.charno);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void checkEnumElementCycle(ErrorReporter t) {
        JSType referencedType = this.getReferencedType();
        if (referencedType instanceof EnumElementType && ((EnumElementType)referencedType).getPrimitiveType() == this) {
            this.handleTypeCycle(t);
        }
    }

    private void checkProtoCycle(ErrorReporter t) {
        JSType referencedType = this.getReferencedType();
        if (referencedType == this) {
            this.handleTypeCycle(t);
        }
    }

    private void handleUnresolvedType(ErrorReporter t, boolean ignoreForwardReferencedTypes) {
        if (this.registry.isLastGeneration()) {
            boolean isForwardDeclared;
            boolean bl = isForwardDeclared = ignoreForwardReferencedTypes && this.registry.isForwardDeclaredType(this.reference);
            if (!isForwardDeclared && this.registry.isLastGeneration()) {
                t.warning("Bad type annotation. Unknown type " + this.reference, this.sourceName, this.lineno, this.charno);
            } else {
                this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.NO_RESOLVED_TYPE));
                if (this.registry.isLastGeneration() && this.validator != null) {
                    this.validator.apply((Object)this.getReferencedType());
                }
            }
            this.setResolvedTypeInternal(this.getReferencedType());
        } else {
            this.setResolvedTypeInternal(this);
        }
    }

    private JSType getTypedefType(ErrorReporter t, StaticSlot<JSType> slot) {
        JSType type = slot.getType();
        if (type != null) {
            return type;
        }
        this.handleUnresolvedType(t, true);
        return null;
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        if (this.isResolved()) {
            return super.setValidator(validator);
        }
        this.validator = validator;
        return true;
    }

    private static final class PropertyContinuation {
        private final String propertyName;
        private final JSType type;
        private final boolean inferred;
        private final Node propertyNode;

        private PropertyContinuation(String propertyName, JSType type, boolean inferred, Node propertyNode) {
            this.propertyName = propertyName;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        void commit(ObjectType target) {
            target.defineProperty(this.propertyName, this.type, this.inferred, this.propertyNode);
        }
    }
}

