/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.io.Serializable;

public final class Property
implements Serializable,
StaticSlot<JSType>,
StaticReference<JSType> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private JSType type;
    private final boolean inferred;
    private Node propertyNode;
    private JSDocInfo docInfo = null;

    Property(String name, JSType type, boolean inferred, Node propertyNode) {
        this.name = name;
        this.type = type;
        this.inferred = inferred;
        this.propertyNode = propertyNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this.propertyNode;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.propertyNode == null ? null : this.propertyNode.getStaticSourceFile();
    }

    public Property getSymbol() {
        return this;
    }

    public Property getDeclaration() {
        return this.propertyNode == null ? null : this;
    }

    @Override
    public JSType getType() {
        return this.type;
    }

    @Override
    public boolean isTypeInferred() {
        return this.inferred;
    }

    boolean isFromExterns() {
        return this.propertyNode == null ? false : this.propertyNode.isFromExterns();
    }

    void setType(JSType type) {
        this.type = type;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.docInfo;
    }

    void setJSDocInfo(JSDocInfo info) {
        this.docInfo = info;
    }

    public void setNode(Node n) {
        this.propertyNode = n;
    }
}

