/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ParameterizedType;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;

public abstract class ChainableReverseAbstractInterpreter
implements ReverseAbstractInterpreter {
    protected final CodingConvention convention;
    final JSTypeRegistry typeRegistry;
    private ChainableReverseAbstractInterpreter firstLink;
    private ChainableReverseAbstractInterpreter nextLink;
    private final Visitor<JSType> restrictUndefinedVisitor = new Visitor<JSType>(){

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType type = enumElementType.getPrimitiveType().visit(this);
            if (type != null && enumElementType.getPrimitiveType().equals(type)) {
                return enumElementType;
            }
            return type;
        }

        @Override
        public JSType caseAllType() {
            return ChainableReverseAbstractInterpreter.this.typeRegistry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.STRING_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }

        @Override
        public JSType caseNullType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            return type.getRestrictedUnion(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return null;
        }

        @Override
        public JSType caseParameterizedType(ParameterizedType type) {
            return this.caseObjectType(type);
        }

        @Override
        public JSType caseTemplateType(TemplateType templateType) {
            return this.caseObjectType(templateType);
        }
    };
    private final Visitor<JSType> restrictNullVisitor = new Visitor<JSType>(){

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType type = enumElementType.getPrimitiveType().visit(this);
            if (type != null && enumElementType.getPrimitiveType().equals(type)) {
                return enumElementType;
            }
            return type;
        }

        @Override
        public JSType caseAllType() {
            return ChainableReverseAbstractInterpreter.this.typeRegistry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.STRING_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.VOID_TYPE);
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }

        @Override
        public JSType caseNullType() {
            return null;
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            return type.getRestrictedUnion(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE);
        }

        @Override
        public JSType caseParameterizedType(ParameterizedType type) {
            return this.caseObjectType(type);
        }

        @Override
        public JSType caseTemplateType(TemplateType templateType) {
            return this.caseObjectType(templateType);
        }
    };

    public ChainableReverseAbstractInterpreter(CodingConvention convention, JSTypeRegistry typeRegistry) {
        Preconditions.checkNotNull((Object)convention);
        this.convention = convention;
        this.typeRegistry = typeRegistry;
        this.firstLink = this;
        this.nextLink = null;
    }

    public ChainableReverseAbstractInterpreter append(ChainableReverseAbstractInterpreter lastLink) {
        Preconditions.checkArgument((lastLink.nextLink == null ? 1 : 0) != 0);
        this.nextLink = lastLink;
        lastLink.firstLink = this.firstLink;
        return lastLink;
    }

    public ChainableReverseAbstractInterpreter getFirst() {
        return this.firstLink;
    }

    protected FlowScope firstPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        return this.firstLink.getPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    protected FlowScope nextPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        return this.nextLink != null ? this.nextLink.getPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome) : blindScope;
    }

    protected JSType getTypeIfRefinable(Node node, FlowScope scope) {
        switch (node.getType()) {
            case 38: {
                StaticSlot nameVar = scope.getSlot(node.getString());
                if (nameVar != null) {
                    JSType nameVarType = (JSType)nameVar.getType();
                    if (nameVarType == null) {
                        nameVarType = node.getJSType();
                    }
                    return nameVarType;
                }
                return null;
            }
            case 33: {
                String qualifiedName = node.getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                StaticSlot propVar = scope.getSlot(qualifiedName);
                JSType propVarType = null;
                if (propVar != null) {
                    propVarType = (JSType)propVar.getType();
                }
                if (propVarType == null) {
                    propVarType = node.getJSType();
                }
                if (propVarType == null) {
                    propVarType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return propVarType;
            }
        }
        return null;
    }

    protected void declareNameInScope(FlowScope scope, Node node, JSType type) {
        switch (node.getType()) {
            case 38: {
                scope.inferSlotType(node.getString(), type);
                break;
            }
            case 33: {
                String qualifiedName = node.getQualifiedName();
                Preconditions.checkNotNull((Object)qualifiedName);
                JSType origType = node.getJSType();
                origType = origType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : origType;
                scope.inferQualifiedSlot(node, qualifiedName, origType, type);
                break;
            }
            case 42: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Node cannot be refined. \n" + node.toStringTree());
            }
        }
    }

    protected final JSType getRestrictedWithoutUndefined(JSType type) {
        return type == null ? null : type.visit(this.restrictUndefinedVisitor);
    }

    protected final JSType getRestrictedWithoutNull(JSType type) {
        return type == null ? null : type.visit(this.restrictNullVisitor);
    }

    JSType getRestrictedByTypeOfResult(JSType type, String value, boolean resultEqualsValue) {
        if (type == null) {
            if (resultEqualsValue) {
                JSType result = this.getNativeTypeForTypeOf(value);
                return result == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : result;
            }
            return null;
        }
        return type.visit(new RestrictByOneTypeOfResultVisitor(value, resultEqualsValue));
    }

    JSType getNativeType(JSTypeNative typeId) {
        return this.typeRegistry.getNativeType(typeId);
    }

    private JSType getNativeTypeForTypeOf(String value) {
        if (value.equals("number")) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        if (value.equals("boolean")) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (value.equals("string")) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (value.equals("undefined")) {
            return this.getNativeType(JSTypeNative.VOID_TYPE);
        }
        if (value.equals("function")) {
            return this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        }
        return null;
    }

    private class RestrictByOneTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        private final String value;
        private final boolean resultEqualsValue;

        RestrictByOneTypeOfResultVisitor(String value, boolean resultEqualsValue) {
            this.value = value;
            this.resultEqualsValue = resultEqualsValue;
        }

        private boolean matchesExpectation(String result) {
            return result.equals(this.value) == this.resultEqualsValue;
        }

        @Override
        protected JSType caseTopType(JSType topType) {
            JSType typeByName;
            JSType result = topType;
            if (this.resultEqualsValue && (typeByName = ChainableReverseAbstractInterpreter.this.getNativeTypeForTypeOf(this.value)) != null) {
                result = typeByName;
            }
            return result;
        }

        @Override
        public JSType caseNoObjectType() {
            return (this.value.equals("object") || this.value.equals("function")) == this.resultEqualsValue ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE) : null;
        }

        @Override
        public JSType caseBooleanType() {
            return this.matchesExpectation("boolean") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE) : null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return this.matchesExpectation("function") ? type : null;
        }

        @Override
        public JSType caseNullType() {
            return this.matchesExpectation("object") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE) : null;
        }

        @Override
        public JSType caseNumberType() {
            return this.matchesExpectation("number") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE) : null;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            if (this.value.equals("function")) {
                JSType ctorType = ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
                return this.resultEqualsValue && ctorType.isSubtype(type) ? ctorType : null;
            }
            return this.matchesExpectation("object") ? type : null;
        }

        @Override
        public JSType caseStringType() {
            return this.matchesExpectation("string") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE) : null;
        }

        @Override
        public JSType caseVoidType() {
            return this.matchesExpectation("undefined") ? ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE) : null;
        }
    }

    abstract class RestrictByFalseTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByFalseTypeOfResultVisitor() {
        }

        @Override
        protected JSType caseTopType(JSType topType) {
            return topType;
        }

        @Override
        public JSType caseNoObjectType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseBooleanType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }

        @Override
        public JSType caseNullType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_TYPE);
        }

        @Override
        public JSType caseNumberType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseStringType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.STRING_TYPE);
        }

        @Override
        public JSType caseVoidType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.VOID_TYPE);
        }
    }

    abstract class RestrictByTrueTypeOfResultVisitor
    extends RestrictByTypeOfResultVisitor {
        RestrictByTrueTypeOfResultVisitor() {
        }

        @Override
        public JSType caseNoObjectType() {
            return null;
        }

        @Override
        public JSType caseBooleanType() {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }

        @Override
        public JSType caseNullType() {
            return null;
        }

        @Override
        public JSType caseNumberType() {
            return null;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseStringType() {
            return null;
        }

        @Override
        public JSType caseVoidType() {
            return null;
        }
    }

    abstract class RestrictByTypeOfResultVisitor
    implements Visitor<JSType> {
        RestrictByTypeOfResultVisitor() {
        }

        protected abstract JSType caseTopType(JSType var1);

        @Override
        public JSType caseAllType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.ALL_TYPE));
        }

        @Override
        public JSType caseUnknownType() {
            return this.caseTopType(ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            JSType restricted = null;
            for (JSType alternate : type.getAlternates()) {
                JSType restrictedAlternate = alternate.visit(this);
                if (restrictedAlternate == null) continue;
                if (restricted == null) {
                    restricted = restrictedAlternate;
                    continue;
                }
                restricted = restrictedAlternate.getLeastSupertype(restricted);
            }
            return restricted;
        }

        @Override
        public JSType caseNoType() {
            return ChainableReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_TYPE);
        }

        @Override
        public JSType caseEnumElementType(EnumElementType enumElementType) {
            JSType type = enumElementType.getPrimitiveType().visit(this);
            if (type != null && enumElementType.getPrimitiveType().equals(type)) {
                return enumElementType;
            }
            return type;
        }

        @Override
        public JSType caseParameterizedType(ParameterizedType type) {
            return (JSType)this.caseObjectType(type);
        }

        @Override
        public JSType caseTemplateType(TemplateType templateType) {
            return (JSType)this.caseObjectType(templateType);
        }
    }
}

