/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CleanupPasses;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.PrintStreamErrorManager;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.RecordFunctionInformation;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.RemoveTryCatch;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SanityCheck;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SymbolTable;
import com.google.javascript.jscomp.SyntheticAst;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TransformAMDToCJSModule;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.SemanticReverseAbstractInterpreter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.head.ErrorReporter;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class Compiler
extends AbstractCompiler {
    static final String SINGLETON_MODULE_NAME = "[singleton]";
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    private static final String CONFIG_RESOURCE = "com.google.javascript.jscomp.parsing.ParserConfig";
    CompilerOptions options = null;
    private PassConfig passes = null;
    private List<CompilerInput> externs;
    private List<JSModule> modules;
    private JSModuleGraph moduleGraph;
    private List<CompilerInput> inputs;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    private final Map<String, Node> injectedLibraries = Maps.newLinkedHashMap();
    Node externsRoot;
    Node jsRoot;
    Node externAndJsRoot;
    private Map<InputId, CompilerInput> inputsById;
    private SourceMap sourceMap;
    private String externExports = null;
    private int uniqueNameId = 0;
    private boolean hasRegExpGlobalReferences = true;
    private FunctionInformationMap functionInformationMap;
    private final StringBuilder debugLog = new StringBuilder();
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private JSTypeRegistry typeRegistry;
    private Config parserConfig = null;
    private ReverseAbstractInterpreter abstractInterpreter;
    private TypeValidator typeValidator;
    public PerformanceTracker tracker;
    private final com.google.javascript.rhino.ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    private final ErrorReporter defaultErrorReporter = RhinoErrorReporter.forNewRhino(this);
    public static final DiagnosticType OPTIMIZE_LOOP_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of optimization iterations: {0}");
    public static final DiagnosticType MOTION_ITERATIONS_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of code motion iterations: {0}");
    private static final long COMPILER_STACK_SIZE = 0x200000L;
    private static final ExecutorService compilerExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(null, r, "jscompiler", 0x200000L);
        }
    });
    private Thread compilerThread = null;
    private boolean useThreads = true;
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private GlobalVarReferenceMap globalRefMap = null;
    private volatile double progress = 0.0;
    private String lastPassName;
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module '{0}' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory sanityCheck = new PassFactory("sanityCheck", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler compiler) {
            return new SanityCheck(compiler);
        }
    };
    private Tracer currentTracer = null;
    private String currentPassName = null;
    private int syntheticCodeId = 0;
    protected final CodeChangeHandler.RecentChange recentChange = new CodeChangeHandler.RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = Lists.newArrayList();
    static final String SYNTHETIC_EXTERNS = "{SyntheticVarsDeclar}";
    private CompilerInput synthesizedExternsInput = null;

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(PrintStream stream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = stream;
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull((Object)errorManager, (Object)"the error manager cannot be null");
        this.errorManager = errorManager;
    }

    private MessageFormatter createMessageFormatter() {
        boolean colorize = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, colorize);
    }

    public void initOptions(CompilerOptions options) {
        this.options = options;
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                PrintStreamErrorManager printer = new PrintStreamErrorManager(this.createMessageFormatter(), this.outStream);
                printer.setSummaryDetailLevel(options.summaryDetailLevel);
                this.setErrorManager(printer);
            }
        }
        if (options.enables(DiagnosticGroups.CHECK_TYPES)) {
            options.checkTypes = true;
        } else if (options.disables(DiagnosticGroups.CHECK_TYPES)) {
            options.checkTypes = false;
        } else if (!options.checkTypes) {
            options.setWarningLevel(DiagnosticGroup.forType(RhinoErrorReporter.TYPE_PARSE_ERROR), CheckLevel.OFF);
        }
        if (options.checkGlobalThisLevel.isOn() && !options.disables(DiagnosticGroups.GLOBAL_THIS)) {
            options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, options.checkGlobalThisLevel);
        }
        if (options.getLanguageIn() == CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT) {
            options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.ERROR);
        }
        ArrayList guards = Lists.newArrayList();
        guards.add(new SuppressDocWarningsGuard(this.getDiagnosticGroups().getRegisteredGroups()));
        guards.add(options.getWarningsGuard());
        ComposeWarningsGuard composedGuards = new ComposeWarningsGuard(guards);
        if (!options.checkSymbols && !composedGuards.enables(DiagnosticGroups.CHECK_VARIABLES)) {
            composedGuards.addGuard(new DiagnosticGroupWarningsGuard(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF));
        }
        this.warningsGuard = composedGuards;
    }

    @Deprecated
    public void init(JSSourceFile[] externs, JSSourceFile[] inputs, CompilerOptions options) {
        this.init(Lists.newArrayList((Object[])externs), Lists.newArrayList((Object[])inputs), options);
    }

    public <T1 extends SourceFile, T2 extends SourceFile> void init(List<T1> externs, List<T2> inputs, CompilerOptions options) {
        JSModule module = new JSModule(SINGLETON_MODULE_NAME);
        for (SourceFile input : inputs) {
            module.add(input);
        }
        this.initModules(externs, Lists.newArrayList((Object[])new JSModule[]{module}), options);
    }

    @Deprecated
    public void init(JSSourceFile[] externs, JSModule[] modules, CompilerOptions options) {
        this.initModules(Lists.newArrayList((Object[])externs), Lists.newArrayList((Object[])modules), options);
    }

    public <T extends SourceFile> void initModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        this.initOptions(options);
        this.checkFirstModule(modules);
        Compiler.fillEmptyModules(modules);
        this.externs = this.makeCompilerInput(externs, true);
        this.modules = modules;
        if (modules.size() > 1) {
            try {
                this.moduleGraph = new JSModuleGraph(modules);
            }
            catch (JSModuleGraph.ModuleDependenceException e) {
                this.report(JSError.make(MODULE_DEPENDENCY_ERROR, e.getModule().getName(), e.getDependentModule().getName()));
                return;
            }
        } else {
            this.moduleGraph = null;
        }
        this.inputs = Compiler.getAllInputsFromModules(modules);
        this.initBasedOnOptions();
        this.initInputsByIdMap();
    }

    private void initBasedOnOptions() {
        if (this.options.sourceMapOutputPath != null) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
            this.sourceMap.setPrefixMappings(this.options.sourceMapLocationMappings);
        }
    }

    private <T extends SourceFile> List<CompilerInput> makeCompilerInput(List<T> files, boolean isExtern) {
        ArrayList inputs = Lists.newArrayList();
        for (SourceFile file : files) {
            inputs.add(new CompilerInput(file, isExtern));
        }
        return inputs;
    }

    private void checkFirstModule(List<JSModule> modules) {
        if (modules.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (modules.get(0).getInputs().isEmpty() && modules.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, modules.get(0).getName()));
        }
    }

    static String createFillFileName(String moduleName) {
        return "[" + moduleName + "]";
    }

    private static void fillEmptyModules(List<JSModule> modules) {
        for (JSModule module : modules) {
            if (!module.getInputs().isEmpty()) continue;
            module.add(SourceFile.fromCode(Compiler.createFillFileName(module.getName()), ""));
        }
    }

    public void rebuildInputsFromModules() {
        this.inputs = Compiler.getAllInputsFromModules(this.modules);
        this.initInputsByIdMap();
    }

    private static List<CompilerInput> getAllInputsFromModules(List<JSModule> modules) {
        ArrayList inputs = Lists.newArrayList();
        HashMap inputMap = Maps.newHashMap();
        for (JSModule module : modules) {
            for (CompilerInput input : module.getInputs()) {
                String inputName = input.getName();
                inputs.add(input);
                inputMap.put(inputName, module);
            }
        }
        return inputs;
    }

    void initInputsByIdMap() {
        CompilerInput previous;
        InputId id;
        this.inputsById = new HashMap<InputId, CompilerInput>();
        for (CompilerInput input : this.externs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, input.getName()));
        }
        for (CompilerInput input : this.inputs) {
            id = input.getInputId();
            previous = this.putCompilerInput(id, input);
            if (previous == null) continue;
            this.report(JSError.make(DUPLICATE_INPUT, input.getName()));
        }
    }

    public Result compile(SourceFile extern, SourceFile input, CompilerOptions options) {
        return this.compile(Lists.newArrayList((Object[])new SourceFile[]{extern}), Lists.newArrayList((Object[])new SourceFile[]{input}), options);
    }

    @Deprecated
    public Result compile(SourceFile extern, JSSourceFile[] input, CompilerOptions options) {
        return this.compile(Lists.newArrayList((Object[])new SourceFile[]{extern}), Lists.newArrayList((Object[])input), options);
    }

    @Deprecated
    public Result compile(JSSourceFile extern, JSModule[] modules, CompilerOptions options) {
        return this.compileModules(Lists.newArrayList((Object[])new JSSourceFile[]{extern}), Lists.newArrayList((Object[])modules), options);
    }

    @Deprecated
    public Result compile(JSSourceFile[] externs, JSSourceFile[] inputs, CompilerOptions options) {
        return this.compile(Lists.newArrayList((Object[])externs), Lists.newArrayList((Object[])inputs), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T1 extends SourceFile, T2 extends SourceFile> Result compile(List<T1> externs, List<T2> inputs, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.init(externs, inputs, options);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer t = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(t, "generateReport");
        }
    }

    @Deprecated
    public Result compile(JSSourceFile[] externs, JSModule[] modules, CompilerOptions options) {
        return this.compileModules(Lists.newArrayList((Object[])externs), Lists.newArrayList((Object[])modules), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SourceFile> Result compileModules(List<T> externs, List<JSModule> modules, CompilerOptions options) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.initModules(externs, modules, options);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer t = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(t, "generateReport");
        }
    }

    private Result compile() {
        return this.runInCompilerThread(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Compiler.this.compileInternal();
                return Compiler.this.getResult();
            }
        });
    }

    public void disableThreads() {
        this.useThreads = false;
    }

    <T> T runInCompilerThread(final Callable<T> callable) {
        final boolean dumpTraceReport = this.options != null && this.options.tracer.isOn();
        T result = null;
        final Throwable[] exception = new Throwable[1];
        Callable bootCompilerThread = new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public T call() {
                Object v;
                try {
                    Compiler.this.compilerThread = Thread.currentThread();
                    if (dumpTraceReport) {
                        Tracer.initCurrentThreadTrace();
                    }
                    v = callable.call();
                }
                catch (Throwable e) {
                    try {
                        exception[0] = e;
                    }
                    catch (Throwable throwable) {
                        Compiler.this.compilerThread = null;
                        if (!dumpTraceReport) throw throwable;
                        Tracer.logAndClearCurrentThreadTrace();
                        Compiler.this.tracker.outputTracerReport(Compiler.this.outStream == null ? System.out : Compiler.this.outStream);
                        throw throwable;
                    }
                    Compiler.this.compilerThread = null;
                    if (!dumpTraceReport) return null;
                    Tracer.logAndClearCurrentThreadTrace();
                    Compiler.this.tracker.outputTracerReport(Compiler.this.outStream == null ? System.out : Compiler.this.outStream);
                    return null;
                }
                Compiler.this.compilerThread = null;
                if (!dumpTraceReport) return v;
                Tracer.logAndClearCurrentThreadTrace();
                Compiler.this.tracker.outputTracerReport(Compiler.this.outStream == null ? System.out : Compiler.this.outStream);
                return v;
            }
        };
        Preconditions.checkState((this.compilerThread == null || this.compilerThread == Thread.currentThread() ? 1 : 0) != 0, (Object)"Please do not share the Compiler across threads");
        if (this.useThreads && this.compilerThread == null) {
            try {
                result = compilerExecutor.submit(bootCompilerThread).get();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        try {
            result = callable.call();
        }
        catch (Exception e) {
            exception[0] = e;
        }
        if (exception[0] != null) {
            throw new RuntimeException(exception[0]);
        }
        return result;
    }

    private void compileInternal() {
        this.setProgress(0.0, null);
        this.parse();
        this.setProgress(0.15, "parse");
        if (this.hasErrors()) {
            return;
        }
        if (!this.precheck()) {
            return;
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            this.check();
            return;
        }
        if (!this.options.skipAllPasses) {
            this.check();
            if (this.hasErrors()) {
                return;
            }
            if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
                this.externExports();
            }
            if (!this.options.ideMode) {
                this.optimize();
            }
        }
        if (this.options.recordFunctionInformation) {
            this.recordFunctionInformation();
        }
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runSanityCheck();
        }
        this.setProgress(1.0, "recordFunctionInformation");
    }

    public void parse() {
        this.parseInputs();
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passes) {
        Preconditions.checkNotNull((Object)passes);
        if (this.passes != null) {
            throw new IllegalStateException("this.passes has already been assigned");
        }
        this.passes = passes;
    }

    boolean precheck() {
        return true;
    }

    public void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker, new PhaseOptimizer.ProgressRange(this.getProgress(), 1.0));
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        phaseOptimizer.consume(this.getPassConfig().getChecks());
        phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            return;
        }
        if (this.options.removeTryCatchFinally) {
            this.removeTryCatchFinally();
        }
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            this.stripCode(this.options.stripTypes, this.options.stripNameSuffixes, this.options.stripTypePrefixes, this.options.stripNamePrefixes);
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
    }

    private void externExports() {
        logger.fine("Creating extern file for exports");
        this.startPass("externExports");
        ExternExportsPass pass = new ExternExportsPass(this);
        this.process(pass);
        this.externExports = pass.getGeneratedExterns();
        this.endPass();
    }

    @Override
    void process(CompilerPass p) {
        p.process(this.externsRoot, this.jsRoot);
    }

    private void maybeSanityCheck() {
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.runSanityCheck();
        }
    }

    private void runSanityCheck() {
        this.sanityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    void removeTryCatchFinally() {
        logger.fine("Remove try/catch/finally");
        this.startPass("removeTryCatchFinally");
        RemoveTryCatch r = new RemoveTryCatch(this);
        this.process(r);
        this.endPass();
    }

    void stripCode(Set<String> stripTypes, Set<String> stripNameSuffixes, Set<String> stripTypePrefixes, Set<String> stripNamePrefixes) {
        logger.fine("Strip code");
        this.startPass("stripCode");
        StripCode r = new StripCode(this, stripTypes, stripNameSuffixes, stripTypePrefixes, stripNamePrefixes);
        if (this.options.getTweakProcessing().shouldStrip()) {
            r.enableTweakStripping();
        }
        this.process(r);
        this.endPass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime executionTime) {
        if (this.options.customPasses != null) {
            Tracer t = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass p : this.options.customPasses.get((Object)executionTime)) {
                    this.process(p);
                }
            }
            finally {
                this.stopTracer(t, "runCustomPasses");
            }
        }
    }

    void startPass(String passName) {
        Preconditions.checkState((this.currentTracer == null ? 1 : 0) != 0);
        this.currentPassName = passName;
        this.currentTracer = this.newTracer(passName);
    }

    void endPass() {
        Preconditions.checkState((this.currentTracer != null ? 1 : 0) != 0, (Object)"Tracer should not be null at the end of a pass.");
        this.stopTracer(this.currentTracer, this.currentPassName);
        String passToCheck = this.currentPassName;
        this.currentPassName = null;
        this.currentTracer = null;
        this.maybeSanityCheck();
    }

    Tracer newTracer(String passName) {
        String comment = passName + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStart(passName);
        }
        return new Tracer("Compiler", comment);
    }

    void stopTracer(Tracer t, String passName) {
        long result = t.stop();
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStop(passName, result);
        }
    }

    public Result getResult() {
        PassConfig.State state = this.getPassConfig().getIntermediateState();
        return new Result(this.getErrors(), this.getWarnings(), this.debugLog.toString(), state.variableMap, state.propertyMap, state.anonymousFunctionNameMap, state.stringMap, this.functionInformationMap, this.sourceMap, this.externExports, state.cssNames, state.idGeneratorMap);
    }

    public JSError[] getMessages() {
        return this.getErrors();
    }

    public JSError[] getErrors() {
        return this.errorManager.getErrors();
    }

    public JSError[] getWarnings() {
        return this.errorManager.getWarnings();
    }

    @Override
    public Node getRoot() {
        return this.externAndJsRoot;
    }

    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Override
    Supplier<String> getUniqueNameIdSupplier() {
        final Compiler self = this;
        return new Supplier<String>(){

            public String get() {
                return String.valueOf(self.nextUniqueNameId());
            }
        };
    }

    @Override
    boolean areNodesEqualForInlining(Node n1, Node n2) {
        if (this.options.ambiguateProperties || this.options.disambiguateProperties) {
            return n1.isEquivalentToTyped(n2);
        }
        return n1.isEquivalentTo(n2);
    }

    @Override
    public CompilerInput getInput(InputId id) {
        return this.inputsById.get(id);
    }

    protected void removeExternInput(InputId id) {
        CompilerInput input = this.getInput(id);
        if (input == null) {
            return;
        }
        Preconditions.checkState((boolean)input.isExtern(), (String)"Not an extern input: %s", (Object[])new Object[]{input.getName()});
        this.inputsById.remove(id);
        this.externs.remove(input);
        Node root = input.getAstRoot(this);
        if (root != null) {
            root.detachFromParent();
        }
    }

    @Override
    public CompilerInput newExternInput(String name) {
        SyntheticAst ast = new SyntheticAst(name);
        if (this.inputsById.containsKey(ast.getInputId())) {
            throw new IllegalArgumentException("Conflicting externs name: " + name);
        }
        CompilerInput input = new CompilerInput(ast, true);
        this.putCompilerInput(input.getInputId(), input);
        this.externsRoot.addChildToFront(ast.getAstRoot(this));
        this.externs.add(0, input);
        return input;
    }

    private CompilerInput putCompilerInput(InputId id, CompilerInput input) {
        input.setCompiler(this);
        return this.inputsById.put(id, input);
    }

    void addIncrementalSourceAst(JsAst ast) {
        InputId id = ast.getInputId();
        Preconditions.checkState((this.getInput(id) == null ? 1 : 0) != 0, (String)"Duplicate input %s", (Object[])new Object[]{id.getIdName()});
        this.putCompilerInput(id, new CompilerInput(ast));
    }

    boolean replaceIncrementalSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        Preconditions.checkNotNull((Object)oldInput, (String)"No input to replace: %s", (Object[])new Object[]{ast.getInputId().getIdName()});
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        Node oldRoot = oldInput.getAstRoot(this);
        if (oldRoot != null) {
            oldRoot.getParent().replaceChild(oldRoot, newRoot);
        } else {
            this.getRoot().getLastChild().addChildToBack(newRoot);
        }
        CompilerInput newInput = new CompilerInput(ast);
        this.putCompilerInput(ast.getInputId(), newInput);
        JSModule module = oldInput.getModule();
        if (module != null) {
            module.addAfter(newInput, oldInput);
            module.remove(oldInput);
        }
        Preconditions.checkState((boolean)newInput.getInputId().equals(oldInput.getInputId()));
        InputId inputIdOnAst = newInput.getAstRoot(this).getInputId();
        Preconditions.checkState((boolean)newInput.getInputId().equals(inputIdOnAst));
        this.inputs.remove(oldInput);
        return true;
    }

    boolean addNewSourceAst(JsAst ast) {
        CompilerInput oldInput = this.getInput(ast.getInputId());
        if (oldInput != null) {
            throw new IllegalStateException("Input already exists: " + ast.getInputId().getIdName());
        }
        Node newRoot = ast.getAstRoot(this);
        if (newRoot == null) {
            return false;
        }
        this.getRoot().getLastChild().addChildToBack(newRoot);
        CompilerInput newInput = new CompilerInput(ast);
        if (this.moduleGraph == null && !this.modules.isEmpty()) {
            this.modules.get(0).add(newInput);
        }
        this.putCompilerInput(ast.getInputId(), newInput);
        return true;
    }

    @Override
    JSModuleGraph getModuleGraph() {
        return this.moduleGraph;
    }

    JSModuleGraph getDegenerateModuleGraph() {
        return this.moduleGraph == null ? new JSModuleGraph(this.modules) : this.moduleGraph;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter, this.options.looseTypes);
        }
        return this.typeRegistry;
    }

    @Override
    public MemoizedScopeCreator getTypedScopeCreator() {
        return this.getPassConfig().getTypedScopeCreator();
    }

    DefaultPassConfig ensureDefaultPassConfig() {
        PassConfig passes = this.getPassConfig().getBasePassConfig();
        Preconditions.checkState((boolean)(passes instanceof DefaultPassConfig), (Object)"PassConfigs must eventually delegate to the DefaultPassConfig");
        return (DefaultPassConfig)passes;
    }

    public SymbolTable buildKnownSymbolTable() {
        SymbolTable symbolTable = new SymbolTable(this.getTypeRegistry());
        MemoizedScopeCreator typedScopeCreator = this.getTypedScopeCreator();
        if (typedScopeCreator != null) {
            symbolTable.addScopes(typedScopeCreator.getAllMemoizedScopes());
            symbolTable.addSymbolsFrom(typedScopeCreator);
        } else {
            symbolTable.findScopes(this, this.externsRoot, this.jsRoot);
        }
        GlobalNamespace globalNamespace = this.ensureDefaultPassConfig().getGlobalNamespace();
        if (globalNamespace != null) {
            symbolTable.addSymbolsFrom(globalNamespace);
        }
        ReferenceCollectingCallback refCollector = new ReferenceCollectingCallback(this, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverse(this, this.getRoot(), refCollector);
        symbolTable.addSymbolsFrom(refCollector);
        PreprocessorSymbolTable preprocessorSymbolTable = this.ensureDefaultPassConfig().getPreprocessorSymbolTable();
        if (preprocessorSymbolTable != null) {
            symbolTable.addSymbolsFrom(preprocessorSymbolTable);
        }
        symbolTable.fillNamespaceReferences();
        symbolTable.fillPropertyScopes();
        symbolTable.fillThisReferences(this, this.externsRoot, this.jsRoot);
        symbolTable.fillPropertySymbols(this, this.externsRoot, this.jsRoot);
        symbolTable.fillJSDocInfo(this, this.externsRoot, this.jsRoot);
        return symbolTable;
    }

    @Override
    public Scope getTopScope() {
        return this.getPassConfig().getTopScope();
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter interpreter = new SemanticReverseAbstractInterpreter(this.getCodingConvention(), this.getTypeRegistry());
            if (this.options.closurePass) {
                interpreter = new ClosureReverseAbstractInterpreter(this.getCodingConvention(), this.getTypeRegistry()).append(interpreter).getFirst();
            }
            this.abstractInterpreter = interpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    /*
     * Exception decompiling
     */
    Node parseInputs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void hoistExterns(Node externsRoot) {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            JSDocInfo info;
            Node n;
            if (this.options.dependencyOptions.needsManagement() && (!input.getProvides().isEmpty() || !input.getRequires().isEmpty()) || (n = input.getAstRoot(this)) == null || (info = n.getJSDocInfo()) == null || !info.isExterns()) continue;
            externsRoot.addChildToBack(n);
            input.setIsExtern(true);
            input.getModule().remove(input);
            this.externs.add(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void hoistNoCompileFiles() {
        boolean staleInputs = false;
        for (CompilerInput input : this.inputs) {
            JSDocInfo info;
            Node n = input.getAstRoot(this);
            if (n == null || (info = n.getJSDocInfo()) == null || !info.isNoCompile()) continue;
            input.getModule().remove(input);
            staleInputs = true;
        }
        if (staleInputs) {
            this.repartitionInputs();
        }
    }

    private void repartitionInputs() {
        Compiler.fillEmptyModules(this.modules);
        this.rebuildInputsFromModules();
    }

    void processAMDAndCommonJSModules() {
        LinkedHashMap modulesByName = Maps.newLinkedHashMap();
        LinkedHashMap modulesByInput = Maps.newLinkedHashMap();
        for (CompilerInput input : this.inputs) {
            input.setCompiler(this);
            Node root = input.getAstRoot(this);
            if (root == null) continue;
            if (this.options.transformAMDToCJSModules) {
                new TransformAMDToCJSModule(this).process(null, root);
            }
            if (!this.options.processCommonJSModules) continue;
            ProcessCommonJSModules cjs = new ProcessCommonJSModules(this, this.options.commonJSModulePathPrefix);
            cjs.process(null, root);
            JSModule m = cjs.getModule();
            if (m == null) continue;
            modulesByName.put(m.getName(), m);
            modulesByInput.put(input, m);
        }
        if (this.options.processCommonJSModules) {
            List<Object> modules = Lists.newArrayList(modulesByName.values());
            if (!modules.isEmpty()) {
                this.modules = modules;
                this.moduleGraph = new JSModuleGraph(this.modules);
            }
            for (JSModule module : modules) {
                for (CompilerInput input : module.getInputs()) {
                    for (String require : input.getRequires()) {
                        JSModule dependency = (JSModule)modulesByName.get(require);
                        if (dependency == null) {
                            this.report(JSError.make(MISSING_ENTRY_ERROR, require));
                            continue;
                        }
                        module.addDependency(dependency);
                    }
                }
            }
            try {
                modules = Lists.newArrayList();
                for (CompilerInput input : this.moduleGraph.manageDependencies(this.options.dependencyOptions, this.inputs)) {
                    modules.add(modulesByInput.get(input));
                }
                JSModule root = new JSModule("root");
                for (JSModule m : modules) {
                    m.addDependency(root);
                }
                modules.add(0, root);
                SortedDependencies sorter = new SortedDependencies(modules);
                this.modules = modules = sorter.getDependenciesOf(modules, true);
                this.moduleGraph = new JSModuleGraph(modules);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public Node parse(SourceFile file) {
        this.initCompilerOptionsIfTesting();
        this.addToDebugLog("Parsing: " + file.getName());
        return new JsAst(file).getAstRoot(this);
    }

    @Override
    Node parseSyntheticCode(String js) {
        CompilerInput input = new CompilerInput(SourceFile.fromCode(" [synthetic:" + ++this.syntheticCodeId + "] ", js));
        this.putCompilerInput(input.getInputId(), input);
        return input.getAstRoot(this);
    }

    protected CompilerOptions newCompilerOptions() {
        return new CompilerOptions();
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
    }

    @Override
    Node parseSyntheticCode(String fileName, String js) {
        this.initCompilerOptionsIfTesting();
        return this.parse(SourceFile.fromCode(fileName, js));
    }

    @Override
    Node parseTestCode(String js) {
        this.initCompilerOptionsIfTesting();
        CompilerInput input = new CompilerInput(SourceFile.fromCode("[testcode]", js));
        if (this.inputsById == null) {
            this.inputsById = Maps.newHashMap();
        }
        this.putCompilerInput(input.getInputId(), input);
        return input.getAstRoot(this);
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.defaultErrorReporter;
    }

    public String toSource() {
        return this.runInCompilerThread(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSource");
                try {
                    CodeBuilder cb = new CodeBuilder();
                    if (Compiler.this.jsRoot != null) {
                        int i = 0;
                        for (Node scriptNode = Compiler.this.jsRoot.getFirstChild(); scriptNode != null; scriptNode = scriptNode.getNext()) {
                            Compiler.this.toSource(cb, i++, scriptNode);
                        }
                    }
                    String string = cb.toString();
                    return string;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSource");
                }
            }
        });
    }

    public String[] toSourceArray() {
        return this.runInCompilerThread(new Callable<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSourceArray");
                try {
                    int numInputs = Compiler.this.inputs.size();
                    String[] sources = new String[numInputs];
                    CodeBuilder cb = new CodeBuilder();
                    for (int i = 0; i < numInputs; ++i) {
                        Node scriptNode = ((CompilerInput)Compiler.this.inputs.get(i)).getAstRoot(Compiler.this);
                        cb.reset();
                        Compiler.this.toSource(cb, i, scriptNode);
                        sources[i] = cb.toString();
                    }
                    String[] stringArray = sources;
                    return stringArray;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSourceArray");
                }
            }
        });
    }

    public String toSource(final JSModule module) {
        return this.runInCompilerThread(new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return "";
                }
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module: " + module.getName());
                    }
                    Compiler.this.toSource(cb, i, scriptNode);
                }
                return cb.toString();
            }
        });
    }

    public String[] toSourceArray(final JSModule module) {
        return this.runInCompilerThread(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                List<CompilerInput> inputs = module.getInputs();
                int numInputs = inputs.size();
                if (numInputs == 0) {
                    return new String[0];
                }
                String[] sources = new String[numInputs];
                CodeBuilder cb = new CodeBuilder();
                for (int i = 0; i < numInputs; ++i) {
                    Node scriptNode = inputs.get(i).getAstRoot(Compiler.this);
                    if (scriptNode == null) {
                        throw new IllegalArgumentException("Bad module input: " + inputs.get(i).getName());
                    }
                    cb.reset();
                    Compiler.this.toSource(cb, i, scriptNode);
                    sources[i] = cb.toString();
                }
                return sources;
            }
        });
    }

    public void toSource(final CodeBuilder cb, final int inputSeqNum, final Node root) {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String code;
                if (Compiler.this.options.printInputDelimiter) {
                    if (cb.getLength() > 0 && !cb.endsWith("\n")) {
                        cb.append("\n");
                    }
                    Preconditions.checkState((boolean)root.isScript());
                    String delimiter = Compiler.this.options.inputDelimiter;
                    String inputName = root.getInputId().getIdName();
                    String sourceName = root.getSourceFileName();
                    Preconditions.checkState((sourceName != null ? 1 : 0) != 0);
                    Preconditions.checkState((!sourceName.isEmpty() ? 1 : 0) != 0);
                    delimiter = delimiter.replaceAll("%name%", Matcher.quoteReplacement(inputName)).replaceAll("%num%", String.valueOf(inputSeqNum));
                    cb.append(delimiter).append("\n");
                }
                if (root.getJSDocInfo() != null && root.getJSDocInfo().getLicense() != null) {
                    cb.append("/*\n").append(root.getJSDocInfo().getLicense()).append("*/\n");
                }
                if (Compiler.this.options.sourceMapOutputPath != null) {
                    Compiler.this.sourceMap.setStartingPosition(cb.getLineIndex(), cb.getColumnIndex());
                }
                if (!(code = Compiler.this.toSource(root, Compiler.this.sourceMap, inputSeqNum == 0)).isEmpty()) {
                    boolean hasSemiColon;
                    cb.append(code);
                    int length = code.length();
                    char lastChar = code.charAt(length - 1);
                    char secondLastChar = length >= 2 ? code.charAt(length - 2) : (char)'\u0000';
                    boolean bl = hasSemiColon = lastChar == ';' || lastChar == '\n' && secondLastChar == ';';
                    if (!hasSemiColon) {
                        cb.append(";");
                    }
                }
                return null;
            }
        });
    }

    @Override
    String toSource(Node n) {
        this.initCompilerOptionsIfTesting();
        return this.toSource(n, null, true);
    }

    private String toSource(Node n, SourceMap sourceMap, boolean firstOutput) {
        CodePrinter.Builder builder = new CodePrinter.Builder(n);
        builder.setCompilerOptions(this.options);
        builder.setSourceMap(sourceMap);
        builder.setTagAsStrict(firstOutput && this.options.getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
        return builder.build();
    }

    public void optimize() {
        this.normalize();
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker, null);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        phaseOptimizer.consume(this.getPassConfig().getOptimizations());
        phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
    }

    @Override
    void setCssRenamingMap(CssRenamingMap map) {
        this.options.cssRenamingMap = map;
    }

    @Override
    CssRenamingMap getCssRenamingMap() {
        return this.options.cssRenamingMap;
    }

    public void processDefines() {
        new DefaultPassConfig((CompilerOptions)this.options).processDefines.create(this).process(this.externsRoot, this.jsRoot);
    }

    boolean isInliningForbidden() {
        return this.options.propertyRenaming == PropertyRenamingPolicy.HEURISTIC || this.options.propertyRenaming == PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.fine("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
        this.process(cfa);
        this.stopTracer(tracer, "computeCFG");
        return cfa.getCfg();
    }

    public void normalize() {
        logger.fine("Normalizing");
        this.startPass("normalize");
        this.process(new Normalize(this, false));
        this.endPass();
    }

    @Override
    void prepareAst(Node root) {
        PrepareAst pass = new PrepareAst(this);
        pass.process(null, root);
    }

    void recordFunctionInformation() {
        logger.fine("Recording function information");
        this.startPass("recordFunctionInformation");
        RecordFunctionInformation recordFunctionInfoPass = new RecordFunctionInformation(this, this.getPassConfig().getIntermediateState().functionNames);
        this.process(recordFunctionInfoPass);
        this.functionInformationMap = recordFunctionInfoPass.getMap();
        this.endPass();
    }

    @Override
    void addChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.add(handler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler handler) {
        this.codeChangeHandlers.remove(handler);
    }

    @Override
    public void reportCodeChange() {
        for (CodeChangeHandler handler : this.codeChangeHandlers) {
            handler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention convention = this.options.getCodingConvention();
        convention = convention != null ? convention : this.defaultCodingConvention;
        return convention;
    }

    @Override
    public boolean isIdeMode() {
        return this.options.ideMode;
    }

    @Override
    public boolean acceptEcmaScript5() {
        switch (this.options.getLanguageIn()) {
            case ECMASCRIPT5: 
            case ECMASCRIPT5_STRICT: {
                return true;
            }
        }
        return false;
    }

    public CompilerOptions.LanguageMode languageMode() {
        return this.options.getLanguageIn();
    }

    @Override
    public boolean acceptConstKeyword() {
        return this.options.acceptConstKeyword;
    }

    @Override
    Config getParserConfig() {
        if (this.parserConfig == null) {
            Config.LanguageMode mode;
            switch (this.options.getLanguageIn()) {
                case ECMASCRIPT3: {
                    mode = Config.LanguageMode.ECMASCRIPT3;
                    break;
                }
                case ECMASCRIPT5: {
                    mode = Config.LanguageMode.ECMASCRIPT5;
                    break;
                }
                case ECMASCRIPT5_STRICT: {
                    mode = Config.LanguageMode.ECMASCRIPT5_STRICT;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected language mode");
                }
            }
            this.parserConfig = ParserRunner.createConfig(this.isIdeMode(), mode, this.acceptConstKeyword(), this.options.extraAnnotationNames);
        }
        return this.parserConfig;
    }

    @Override
    public boolean isTypeCheckingEnabled() {
        return this.options.checkTypes;
    }

    protected DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError error) {
        CheckLevel newLevel;
        CheckLevel level = error.getDefaultLevel();
        if (this.warningsGuard != null && (newLevel = this.warningsGuard.level(error)) != null) {
            level = newLevel;
        }
        if (level.isOn()) {
            if (this.getOptions().errorHandler != null) {
                this.getOptions().errorHandler.report(level, error);
            }
            this.errorManager.report(level, error);
        }
    }

    @Override
    public CheckLevel getErrorLevel(JSError error) {
        Preconditions.checkNotNull((Object)this.options);
        return this.warningsGuard.level(error);
    }

    @Override
    void throwInternalError(String message, Exception cause) {
        String finalMessage = "INTERNAL COMPILER ERROR.\nPlease report this problem.\n" + message;
        RuntimeException e = new RuntimeException(finalMessage, cause);
        if (cause != null) {
            e.setStackTrace(cause.getStackTrace());
        }
        throw e;
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.isIdeMode() && this.getErrorCount() > 0;
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    void addToDebugLog(String str) {
        this.debugLog.append(str);
        this.debugLog.append('\n');
        logger.fine(str);
    }

    @Override
    SourceFile getSourceFileByName(String sourceName) {
        CompilerInput input;
        if (sourceName != null && (input = this.inputsById.get(new InputId(sourceName))) != null) {
            return input.getSourceFile();
        }
        return null;
    }

    @Override
    public String getSourceLine(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getLine(lineNumber);
        }
        return null;
    }

    @Override
    public Region getSourceRegion(String sourceName, int lineNumber) {
        if (lineNumber < 1) {
            return null;
        }
        SourceFile input = this.getSourceFileByName(sourceName);
        if (input != null) {
            return input.getRegion(lineNumber);
        }
        return null;
    }

    @Override
    Node getNodeForCodeInsertion(JSModule module) {
        if (module == null) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("No inputs");
            }
            return this.inputs.get(0).getAstRoot(this);
        }
        List<CompilerInput> moduleInputs = module.getInputs();
        if (moduleInputs.size() > 0) {
            return moduleInputs.get(0).getAstRoot(this);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    VariableMap getVariableMap() {
        return this.getPassConfig().getIntermediateState().variableMap;
    }

    VariableMap getPropertyMap() {
        return this.getPassConfig().getIntermediateState().propertyMap;
    }

    CompilerOptions getOptions() {
        return this.options;
    }

    FunctionInformationMap getFunctionalInformationMap() {
        return this.functionInformationMap;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this, true, false);
            cfa.process(null, this.jsRoot);
            return DotFormatter.toDot(this.jsRoot, cfa.getCfg());
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(this.newCompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    List<CompilerInput> getInputsInOrder() {
        return Collections.unmodifiableList(this.inputs);
    }

    public Map<InputId, CompilerInput> getInputsById() {
        return Collections.unmodifiableMap(this.inputsById);
    }

    List<CompilerInput> getExternsInOrder() {
        return Collections.unmodifiableList(this.externs);
    }

    public IntermediateState getState() {
        IntermediateState state = new IntermediateState();
        state.externsRoot = this.externsRoot;
        state.jsRoot = this.jsRoot;
        state.externs = this.externs;
        state.inputs = this.inputs;
        state.modules = this.modules;
        state.passConfigState = this.getPassConfig().getIntermediateState();
        state.typeRegistry = this.typeRegistry;
        state.lifeCycleStage = this.getLifeCycleStage();
        state.injectedLibraries = Maps.newLinkedHashMap(this.injectedLibraries);
        return state;
    }

    public void setState(IntermediateState state) {
        this.externsRoot = state.externsRoot;
        this.jsRoot = state.jsRoot;
        this.externs = state.externs;
        this.inputs = state.inputs;
        this.modules = state.modules;
        this.passes = this.createPassConfigInternal();
        this.getPassConfig().setIntermediateState(state.passConfigState);
        this.typeRegistry = state.typeRegistry;
        this.setLifeCycleStage(state.lifeCycleStage);
        this.injectedLibraries.clear();
        this.injectedLibraries.putAll(state.injectedLibraries);
    }

    @VisibleForTesting
    List<CompilerInput> getInputsForTesting() {
        return this.inputs;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean references) {
        this.hasRegExpGlobalReferences = references;
    }

    @Override
    void updateGlobalVarReferences(Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> refMapPatch, Node collectionRoot) {
        Preconditions.checkState((collectionRoot.isScript() || collectionRoot.isBlock() ? 1 : 0) != 0);
        if (this.globalRefMap == null) {
            this.globalRefMap = new GlobalVarReferenceMap(this.getInputsInOrder(), this.getExternsInOrder());
        }
        this.globalRefMap.updateGlobalVarReferences(refMapPatch, collectionRoot);
    }

    @Override
    GlobalVarReferenceMap getGlobalVarReferences() {
        return this.globalRefMap;
    }

    @Override
    CompilerInput getSynthesizedExternsInput() {
        if (this.synthesizedExternsInput == null) {
            this.synthesizedExternsInput = this.newExternInput(SYNTHETIC_EXTERNS);
        }
        return this.synthesizedExternsInput;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    String getLastPassName() {
        return this.lastPassName;
    }

    @Override
    void setProgress(double newProgress, String passName) {
        this.lastPassName = passName;
        this.progress = newProgress > 1.0 ? 1.0 : newProgress;
    }

    public void replaceScript(JsAst ast) {
        CompilerInput input = this.getInput(ast.getInputId());
        if (!this.replaceIncrementalSourceAst(ast)) {
            return;
        }
        Node originalRoot = input.getAstRoot(this);
        this.processNewScript(ast, originalRoot);
    }

    public void addNewScript(JsAst ast) {
        if (!this.addNewSourceAst(ast)) {
            return;
        }
        Node emptyScript = new Node(132);
        InputId inputId = ast.getInputId();
        emptyScript.setInputId(inputId);
        emptyScript.setStaticSourceFile(SourceFile.fromCode(inputId.getIdName(), ""));
        this.processNewScript(ast, emptyScript);
    }

    private void processNewScript(JsAst ast, Node originalRoot) {
        Node js = ast.getAstRoot(this);
        Preconditions.checkNotNull((Object)js);
        this.runHotSwap(originalRoot, js, this.getCleanupPassConfig());
        this.runHotSwapPass(null, null, this.ensureDefaultPassConfig().garbageCollectChecks);
        this.getTypeRegistry().clearNamedTypes();
        this.removeSyntheticVarsInput();
        this.runHotSwap(originalRoot, js, this.ensureDefaultPassConfig());
    }

    private void runHotSwap(Node originalRoot, Node js, PassConfig passConfig) {
        for (PassFactory passFactory : passConfig.getChecks()) {
            this.runHotSwapPass(originalRoot, js, passFactory);
        }
    }

    private void runHotSwapPass(Node originalRoot, Node js, PassFactory passFactory) {
        HotSwapCompilerPass pass = passFactory.getHotSwapPass(this);
        if (pass != null) {
            logger.info("Performing HotSwap for pass " + passFactory.getName());
            pass.hotSwapScript(js, originalRoot);
        }
    }

    private PassConfig getCleanupPassConfig() {
        return new CleanupPasses(this.getOptions());
    }

    private void removeSyntheticVarsInput() {
        String sourceName = SYNTHETIC_EXTERNS;
        this.removeExternInput(new InputId(sourceName));
    }

    @Override
    Node ensureLibraryInjected(String resourceName) {
        if (this.injectedLibraries.containsKey(resourceName)) {
            return null;
        }
        boolean isBase = "base".equals(resourceName);
        if (!isBase) {
            this.ensureLibraryInjected("base");
        }
        Node firstChild = this.loadLibraryCode(resourceName).removeChildren();
        Node lastChild = firstChild.getLastSibling();
        Node parent = this.getNodeForCodeInsertion(null);
        if (isBase) {
            parent.addChildrenToFront(firstChild);
        } else {
            parent.addChildrenAfter(firstChild, this.injectedLibraries.get("base"));
        }
        this.reportCodeChange();
        this.injectedLibraries.put(resourceName, lastChild);
        return lastChild;
    }

    @VisibleForTesting
    Node loadLibraryCode(String resourceName) {
        String originalCode;
        try {
            originalCode = CharStreams.toString((Readable)new InputStreamReader(Compiler.class.getResourceAsStream(String.format("js/%s.js", resourceName)), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Normalize.parseAndNormalizeSyntheticCode(this, originalCode, String.format("jscomp_%s_", resourceName));
    }

    public static String getReleaseVersion() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.version");
    }

    public static String getReleaseDate() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        return config.getString("compiler.date");
    }

    public static class IntermediateState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Node externsRoot;
        private Node jsRoot;
        private List<CompilerInput> externs;
        private List<CompilerInput> inputs;
        private List<JSModule> modules;
        private PassConfig.State passConfigState;
        private JSTypeRegistry typeRegistry;
        private AbstractCompiler.LifeCycleStage lifeCycleStage;
        private Map<String, Node> injectedLibraries;

        private IntermediateState() {
        }
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;

        void reset() {
            this.sb.setLength(0);
        }

        CodeBuilder append(String str) {
            int index;
            this.sb.append(str);
            int lastIndex = index = -1;
            while ((index = str.indexOf(10, index + 1)) >= 0) {
                ++this.lineCount;
                lastIndex = index;
            }
            this.colCount = lastIndex == -1 ? (this.colCount += str.length()) : str.length() - (lastIndex + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String suffix) {
            return this.sb.length() > suffix.length() && suffix.equals(this.sb.substring(this.sb.length() - suffix.length()));
        }
    }
}

