/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class ScopedAliases
implements HotSwapCompilerPass {
    static final String SCOPING_METHOD_NAME = "goog.scope";
    private final AbstractCompiler compiler;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final CompilerOptions.AliasTransformationHandler transformationHandler;
    static final DiagnosticType GOOG_SCOPE_USED_IMPROPERLY = DiagnosticType.error("JSC_GOOG_SCOPE_USED_IMPROPERLY", "The call to goog.scope must be alone in a single statement.");
    static final DiagnosticType GOOG_SCOPE_HAS_BAD_PARAMETERS = DiagnosticType.error("JSC_GOOG_SCOPE_HAS_BAD_PARAMETERS", "The call to goog.scope must take only a single parameter.  It must be an anonymous function that itself takes no parameters.");
    static final DiagnosticType GOOG_SCOPE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_SCOPE_REFERENCES_THIS", "The body of a goog.scope function cannot reference 'this'.");
    static final DiagnosticType GOOG_SCOPE_USES_RETURN = DiagnosticType.error("JSC_GOOG_SCOPE_USES_RETURN", "The body of a goog.scope function cannot use 'return'.");
    static final DiagnosticType GOOG_SCOPE_USES_THROW = DiagnosticType.error("JSC_GOOG_SCOPE_USES_THROW", "The body of a goog.scope function cannot use 'throw'.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_REDEFINED = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_REDEFINED", "The alias {0} is assigned a value more than once.");
    static final DiagnosticType GOOG_SCOPE_NON_ALIAS_LOCAL = DiagnosticType.error("JSC_GOOG_SCOPE_NON_ALIAS_LOCAL", "The local variable {0} is in a goog.scope and is not an alias.");

    ScopedAliases(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CompilerOptions.AliasTransformationHandler transformationHandler) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.transformationHandler = transformationHandler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node root, Node originalRoot) {
        Traversal traversal = new Traversal();
        NodeTraversal.traverse(this.compiler, root, traversal);
        if (!traversal.hasErrors()) {
            for (AliasUsage aliasUsage : traversal.getAliasUsages()) {
                aliasUsage.applyAlias();
            }
            for (Node aliasDefinition : traversal.getAliasDefinitionsInOrder()) {
                if (aliasDefinition.getParent().isVar() && aliasDefinition.getParent().hasOneChild()) {
                    aliasDefinition.getParent().detachFromParent();
                    continue;
                }
                aliasDefinition.detachFromParent();
            }
            for (Node scopeCall : traversal.getScopeCalls()) {
                Node expressionWithScopeCall = scopeCall.getParent();
                Node scopeClosureBlock = scopeCall.getLastChild().getLastChild();
                scopeClosureBlock.detachFromParent();
                expressionWithScopeCall.getParent().replaceChild(expressionWithScopeCall, scopeClosureBlock);
                NodeUtil.tryMergeBlock(scopeClosureBlock);
            }
            if (traversal.getAliasUsages().size() > 0 || traversal.getAliasDefinitionsInOrder().size() > 0 || traversal.getScopeCalls().size() > 0) {
                this.compiler.reportCodeChange();
            }
        }
    }

    private class Traversal
    implements NodeTraversal.ScopedCallback {
        private final List<Node> aliasDefinitionsInOrder = Lists.newArrayList();
        private final List<Node> scopeCalls = Lists.newArrayList();
        private final List<AliasUsage> aliasUsages = Lists.newArrayList();
        private final Map<String, Scope.Var> aliases = Maps.newHashMap();
        private boolean hasErrors = false;
        private CompilerOptions.AliasTransformation transformation = null;

        private Traversal() {
        }

        Collection<Node> getAliasDefinitionsInOrder() {
            return this.aliasDefinitionsInOrder;
        }

        private List<AliasUsage> getAliasUsages() {
            return this.aliasUsages;
        }

        List<Node> getScopeCalls() {
            return this.scopeCalls;
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        private boolean isCallToScopeMethod(Node n) {
            return n.isCall() && ScopedAliases.SCOPING_METHOD_NAME.equals(n.getFirstChild().getQualifiedName());
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getCurrentNode().getParent();
            if (n != null && this.isCallToScopeMethod(n)) {
                this.transformation = ScopedAliases.this.transformationHandler.logAliasTransformation(n.getSourceFileName(), this.getSourceRegion(n));
                this.findAliases(t);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.getScopeDepth() == 2) {
                this.aliases.clear();
                this.transformation = null;
            }
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || !t.inGlobalScope() || parent != null && this.isCallToScopeMethod(parent);
        }

        private SourcePosition<CompilerOptions.AliasTransformation> getSourceRegion(Node n) {
            Node testNode = n;
            Node next = null;
            while (next != null || testNode.isScript()) {
                next = testNode.getNext();
                testNode = testNode.getParent();
            }
            int endLine = next == null ? Integer.MAX_VALUE : next.getLineno();
            int endChar = next == null ? Integer.MAX_VALUE : next.getCharno();
            SourcePosition<CompilerOptions.AliasTransformation> pos = new SourcePosition<CompilerOptions.AliasTransformation>(){};
            pos.setPositionInformation(n.getLineno(), n.getCharno(), endLine, endChar);
            return pos;
        }

        private void report(NodeTraversal t, Node n, DiagnosticType error, String ... arguments) {
            ScopedAliases.this.compiler.report(t.makeError(n, error, arguments));
            this.hasErrors = true;
        }

        private void findAliases(NodeTraversal t) {
            Scope scope = t.getScope();
            for (Scope.Var v : scope.getVarIterable()) {
                Node n = v.getNode();
                int type = n.getType();
                Node parent = n.getParent();
                if (!parent.isVar()) continue;
                if (n.hasChildren() && n.getFirstChild().isQualifiedName()) {
                    String name = n.getString();
                    Scope.Var aliasVar = scope.getVar(name);
                    this.aliases.put(name, aliasVar);
                    String qualifiedName = aliasVar.getInitialValue().getQualifiedName();
                    this.transformation.addAlias(name, qualifiedName);
                    continue;
                }
                this.report(t, n, GOOG_SCOPE_NON_ALIAS_LOCAL, n.getString());
            }
        }

        private void validateScopeCall(NodeTraversal t, Node n, Node parent) {
            if (ScopedAliases.this.preprocessorSymbolTable != null) {
                ScopedAliases.this.preprocessorSymbolTable.addReference(n.getFirstChild());
            }
            if (!parent.isExprResult()) {
                this.report(t, n, GOOG_SCOPE_USED_IMPROPERLY, new String[0]);
            }
            if (n.getChildCount() != 2) {
                this.report(t, n, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
            } else {
                Node anonymousFnNode = n.getChildAtIndex(1);
                if (!anonymousFnNode.isFunction() || NodeUtil.getFunctionName(anonymousFnNode) != null || NodeUtil.getFunctionParameters(anonymousFnNode).hasChildren()) {
                    this.report(t, anonymousFnNode, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
                } else {
                    this.scopeCalls.add(n);
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isCallToScopeMethod(n)) {
                this.validateScopeCall(t, n, n.getParent());
            }
            if (t.getScopeDepth() < 2) {
                return;
            }
            int type = n.getType();
            Scope.Var aliasVar = null;
            if (type == 38) {
                String name = n.getString();
                Scope.Var lexicalVar = t.getScope().getVar(n.getString());
                if (lexicalVar != null && lexicalVar == this.aliases.get(name)) {
                    aliasVar = lexicalVar;
                }
            }
            if (t.getScopeDepth() == 2) {
                if (aliasVar != null && NodeUtil.isLValue(n)) {
                    if (aliasVar.getNode() == n) {
                        this.aliasDefinitionsInOrder.add(n);
                        return;
                    }
                    this.report(t, n, GOOG_SCOPE_ALIAS_REDEFINED, n.getString());
                }
                if (type == 4) {
                    this.report(t, n, GOOG_SCOPE_USES_RETURN, new String[0]);
                } else if (type == 42) {
                    this.report(t, n, GOOG_SCOPE_REFERENCES_THIS, new String[0]);
                } else if (type == 49) {
                    this.report(t, n, GOOG_SCOPE_USES_THROW, new String[0]);
                }
            }
            if (t.getScopeDepth() >= 2) {
                JSDocInfo info;
                if (aliasVar != null) {
                    Node aliasedNode = aliasVar.getInitialValue();
                    this.aliasUsages.add(new AliasedNode(n, aliasedNode));
                }
                if ((info = n.getJSDocInfo()) != null) {
                    for (Node node : info.getTypeNodes()) {
                        this.fixTypeNode(node);
                    }
                }
            }
        }

        private void fixTypeNode(Node typeNode) {
            if (typeNode.isString()) {
                String baseName;
                Scope.Var aliasVar;
                String name = typeNode.getString();
                int endIndex = name.indexOf(46);
                if (endIndex == -1) {
                    endIndex = name.length();
                }
                if ((aliasVar = this.aliases.get(baseName = name.substring(0, endIndex))) != null) {
                    Node aliasedNode = aliasVar.getInitialValue();
                    this.aliasUsages.add(new AliasedTypeNode(typeNode, aliasedNode.getQualifiedName() + name.substring(endIndex)));
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(child);
            }
        }
    }

    private class AliasedTypeNode
    implements AliasUsage {
        private final Node aliasReference;
        private final String correctedType;

        AliasedTypeNode(Node aliasReference, String correctedType) {
            this.aliasReference = aliasReference;
            this.correctedType = correctedType;
        }

        @Override
        public void applyAlias() {
            this.aliasReference.setString(this.correctedType);
        }
    }

    private class AliasedNode
    implements AliasUsage {
        private final Node aliasReference;
        private final Node aliasDefinition;

        AliasedNode(Node aliasReference, Node aliasDefinition) {
            this.aliasReference = aliasReference;
            this.aliasDefinition = aliasDefinition;
        }

        @Override
        public void applyAlias() {
            this.aliasReference.getParent().replaceChild(this.aliasReference, this.aliasDefinition.cloneTree());
        }
    }

    private static interface AliasUsage {
        public void applyAlias();
    }
}

