/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckAccidentalSemicolon
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType SUSPICIOUS_SEMICOLON = DiagnosticType.warning("JSC_SUSPICIOUS_SEMICOLON", "If this if/for/while really shouldn't have a body, use {}");
    private final CheckLevel level;

    CheckAccidentalSemicolon(CheckLevel level) {
        this.level = level;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node child;
        switch (n.getType()) {
            case 108: {
                child = n.getFirstChild().getNext();
                break;
            }
            case 113: 
            case 115: {
                child = NodeUtil.getLoopCodeBlock(n);
                break;
            }
            default: {
                return;
            }
        }
        while (child != null) {
            if (child.isBlock() && !child.hasChildren() && child.wasEmptyNode()) {
                t.getCompiler().report(t.makeError(n, this.level, SUSPICIOUS_SEMICOLON, new String[0]));
            }
            child = child.getNext();
        }
    }
}

