/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;

public class FunctionPrototypeType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final FunctionType ownerFunction;

    FunctionPrototypeType(JSTypeRegistry registry, FunctionType ownerFunction, ObjectType implicitPrototype, boolean isNative) {
        super(registry, null, implicitPrototype, isNative);
        this.ownerFunction = ownerFunction;
    }

    FunctionPrototypeType(JSTypeRegistry registry, FunctionType ownerFunction, ObjectType implicitPrototype) {
        this(registry, ownerFunction, implicitPrototype, false);
    }

    @Override
    public String getReferenceName() {
        if (this.ownerFunction == null) {
            return "{...}.prototype";
        }
        return this.ownerFunction.getReferenceName() + ".prototype";
    }

    @Override
    public boolean hasReferenceName() {
        return this.ownerFunction != null && this.ownerFunction.hasReferenceName();
    }

    @Override
    public boolean isFunctionPrototypeType() {
        return true;
    }

    public FunctionType getOwnerFunction() {
        return this.ownerFunction;
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.getOwnerFunction().getImplementedInterfaces();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        if (this.getOwnerFunction() != null) {
            return this.getOwnerFunction().getExtendedInterfaces();
        }
        return ImmutableSet.of();
    }
}

