/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ant;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.ant.AntErrorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;

public final class CompileTask
extends Task {
    private WarningLevel warningLevel = WarningLevel.DEFAULT;
    private boolean debugOptions = false;
    private String encoding = "UTF-8";
    private String outputEncoding = "UTF-8";
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private boolean customExternsOnly = false;
    private boolean manageDependencies = false;
    private boolean prettyPrint = false;
    private boolean printInputDelimiter = false;
    private boolean generateExports = false;
    private File outputFile;
    private final List<FileList> externFileLists = Lists.newLinkedList();
    private final List<FileList> sourceFileLists = Lists.newLinkedList();

    public void setWarning(String value) {
        if ("default".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.DEFAULT;
        } else if ("quiet".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.QUIET;
        } else if ("verbose".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.VERBOSE;
        } else {
            throw new BuildException("Unrecognized 'warning' option value (" + value + ")");
        }
    }

    public void setDebug(boolean value) {
        this.debugOptions = value;
    }

    public void setCompilationLevel(String value) {
        if ("simple".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        } else if ("advanced".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.ADVANCED_OPTIMIZATIONS;
        } else if ("whitespace".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.WHITESPACE_ONLY;
        } else {
            throw new BuildException("Unrecognized 'compilation' option value (" + value + ")");
        }
    }

    public void setManageDependencies(boolean value) {
        this.manageDependencies = value;
    }

    public void setCustomExternsOnly(boolean value) {
        this.customExternsOnly = value;
    }

    public void setOutput(File value) {
        this.outputFile = value;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setPrettyPrint(boolean pretty) {
        this.prettyPrint = pretty;
    }

    public void setPrintInputDelimiter(boolean print) {
        this.printInputDelimiter = print;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void addExterns(FileList list) {
        this.externFileLists.add(list);
    }

    public void addSources(FileList list) {
        this.sourceFileLists.add(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute must be set");
        }
        Compiler.setLoggingLevel(Level.OFF);
        CompilerOptions options = this.createCompilerOptions();
        Compiler compiler = this.createCompiler(options);
        JSSourceFile[] externs = this.findExternFiles();
        JSSourceFile[] sources = this.findSourceFiles();
        if (this.isStale()) {
            this.log("Compiling " + sources.length + " file(s) with " + externs.length + " extern(s)");
            Result result = compiler.compile(externs, sources, options);
            if (!result.success) throw new BuildException("Compilation failed.");
            this.writeResult(compiler.toSource());
            return;
        } else {
            this.log("None of the files changed. Compilation skipped.");
        }
    }

    private CompilerOptions createCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        if (this.debugOptions) {
            this.compilationLevel.setDebugOptionsForCompilationLevel(options);
        }
        options.prettyPrint = this.prettyPrint;
        options.printInputDelimiter = this.printInputDelimiter;
        options.generateExports = this.generateExports;
        this.warningLevel.setOptionsForWarningLevel(options);
        options.setManageClosureDependencies(this.manageDependencies);
        return options;
    }

    private Compiler createCompiler(CompilerOptions options) {
        Compiler compiler = new Compiler();
        MessageFormatter formatter = options.errorFormat.toFormatter(compiler, false);
        AntErrorManager errorManager = new AntErrorManager(formatter, this);
        compiler.setErrorManager(errorManager);
        return compiler;
    }

    private JSSourceFile[] findExternFiles() {
        LinkedList files = Lists.newLinkedList();
        if (!this.customExternsOnly) {
            files.addAll(this.getDefaultExterns());
        }
        for (FileList list : this.externFileLists) {
            files.addAll(this.findJavaScriptFiles(list));
        }
        return files.toArray(new JSSourceFile[files.size()]);
    }

    private JSSourceFile[] findSourceFiles() {
        LinkedList files = Lists.newLinkedList();
        for (FileList list : this.sourceFileLists) {
            files.addAll(this.findJavaScriptFiles(list));
        }
        return files.toArray(new JSSourceFile[files.size()]);
    }

    private List<JSSourceFile> findJavaScriptFiles(FileList fileList) {
        LinkedList files = Lists.newLinkedList();
        File baseDir = fileList.getDir(this.getProject());
        for (String included : fileList.getFiles(this.getProject())) {
            files.add(JSSourceFile.fromFile(new File(baseDir, included), Charset.forName(this.encoding)));
        }
        return files;
    }

    private List<JSSourceFile> getDefaultExterns() {
        try {
            return CommandLineRunner.getDefaultExterns();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeResult(String source) {
        if (this.outputFile.getParentFile().mkdirs()) {
            this.log("Created missing parent directory " + this.outputFile.getParentFile(), 4);
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.outputEncoding);
            out.append(source);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Compiled javascript written to " + this.outputFile.getAbsolutePath(), 4);
    }

    private boolean isStale() {
        long lastRun = this.outputFile.lastModified();
        long sourcesLastModified = this.getLastModifiedTime(this.sourceFileLists);
        long externsLastModified = this.getLastModifiedTime(this.externFileLists);
        return lastRun <= sourcesLastModified || lastRun <= externsLastModified;
    }

    private long getLastModifiedTime(List<FileList> fileLists) {
        long lastModified = 0L;
        for (FileList list : fileLists) {
            for (String fileName : list.getFiles(this.getProject())) {
                File path = list.getDir(this.getProject());
                File file = new File(path, fileName);
                long fileLastModified = file.lastModified();
                if (fileLastModified == 0L) {
                    fileLastModified = new Date().getTime();
                }
                lastModified = Math.max(fileLastModified, lastModified);
            }
        }
        return lastModified;
    }
}

