/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.HashSet;

class StrictModeCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNKNOWN_VARIABLE = DiagnosticType.warning("JSC_UNKNOWN_VARIABLE", "unknown variable {0}");
    static final DiagnosticType EVAL_USE = DiagnosticType.error("JSC_EVAL_USE", "\"eval\" cannot be used in Caja");
    static final DiagnosticType EVAL_DECLARATION = DiagnosticType.warning("JSC_EVAL_DECLARATION", "\"eval\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType EVAL_ASSIGNMENT = DiagnosticType.warning("JSC_EVAL_ASSIGNMENT", "the \"eval\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_DECLARATION = DiagnosticType.warning("JSC_ARGUMENTS_DECLARATION", "\"arguments\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_ASSIGNMENT = DiagnosticType.warning("JSC_ARGUMENTS_ASSIGNMENT", "the \"arguments\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType DELETE_VARIABLE = DiagnosticType.warning("JSC_DELETE_VARIABLE", "variables, functions, and arguments cannot be deleted in ES5 strict mode");
    static final DiagnosticType ILLEGAL_NAME = DiagnosticType.error("JSC_ILLEGAL_NAME", "identifiers ending in '__' cannot be used in Caja");
    static final DiagnosticType DUPLICATE_OBJECT_KEY = DiagnosticType.warning("JSC_DUPLICATE_OBJECT_KEY", "object literals cannot contain duplicate keys in ES5 strict mode");
    private final AbstractCompiler compiler;
    private final boolean noVarCheck;
    private final boolean noCajaChecks;

    StrictModeCheck(AbstractCompiler compiler) {
        this(compiler, false, false);
    }

    StrictModeCheck(AbstractCompiler compiler, boolean noVarCheck, boolean noCajaChecks) {
        this.compiler = compiler;
        this.noVarCheck = noVarCheck;
        this.noCajaChecks = noCajaChecks;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        NodeTraversal.traverse(this.compiler, root, new NonExternChecks());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.getType() == 38) {
            if (!StrictModeCheck.isDeclaration(n)) {
                this.checkNameUse(t, n);
            }
        } else if (n.getType() == 86) {
            this.checkAssignment(t, n);
        } else if (n.getType() == 31) {
            this.checkDelete(t, n);
        } else if (n.getType() == 64) {
            this.checkObjectLiteral(t, n);
        } else if (n.getType() == 126) {
            this.checkLabel(t, n);
        }
    }

    private static boolean isDeclaration(Node n) {
        switch (n.getParent().getType()) {
            case 105: 
            case 118: 
            case 120: {
                return true;
            }
            case 83: {
                return n.getParent().getParent().getType() == 105;
            }
        }
        return false;
    }

    private void checkNameUse(NodeTraversal t, Node n) {
        Scope.Var v = t.getScope().getVar(n.getString());
        if (v == null && !this.noVarCheck) {
            t.report(n, UNKNOWN_VARIABLE, n.getString());
        }
        if (!this.noCajaChecks) {
            if ("eval".equals(n.getString())) {
                t.report(n, EVAL_USE, new String[0]);
            } else if (n.getString().endsWith("__")) {
                t.report(n, ILLEGAL_NAME, new String[0]);
            }
        }
    }

    private void checkAssignment(NodeTraversal t, Node n) {
        if (n.getFirstChild().getType() == 38) {
            if ("arguments".equals(n.getFirstChild().getString())) {
                t.report(n, ARGUMENTS_ASSIGNMENT, new String[0]);
            } else if ("eval".equals(n.getFirstChild().getString()) && this.noCajaChecks) {
                t.report(n, EVAL_ASSIGNMENT, new String[0]);
            }
        }
    }

    private void checkDelete(NodeTraversal t, Node n) {
        Scope.Var v;
        if (n.getFirstChild().getType() == 38 && (v = t.getScope().getVar(n.getFirstChild().getString())) != null) {
            t.report(n, DELETE_VARIABLE, new String[0]);
        }
    }

    private void checkObjectLiteral(NodeTraversal t, Node n) {
        HashSet getters = Sets.newHashSet();
        HashSet setters = Sets.newHashSet();
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            if (!this.noCajaChecks && key.getString().endsWith("__")) {
                t.report(key, ILLEGAL_NAME, new String[0]);
            }
            if (key.getType() != 148) {
                if (getters.contains(key.getString())) {
                    t.report(key, DUPLICATE_OBJECT_KEY, new String[0]);
                } else {
                    getters.add(key.getString());
                }
            }
            if (key.getType() == 147) continue;
            if (setters.contains(key.getString())) {
                t.report(key, DUPLICATE_OBJECT_KEY, new String[0]);
                continue;
            }
            setters.add(key.getString());
        }
    }

    private void checkLabel(NodeTraversal t, Node n) {
        if (n.getFirstChild().getString().endsWith("__") && !this.noCajaChecks) {
            t.report(n.getFirstChild(), ILLEGAL_NAME, new String[0]);
        }
    }

    private class NonExternChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private NonExternChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getType() == 38 && StrictModeCheck.isDeclaration(n)) {
                this.checkDeclaration(t, n);
            } else if (n.getType() == 33) {
                this.checkProperty(t, n);
            }
        }

        private void checkDeclaration(NodeTraversal t, Node n) {
            if ("eval".equals(n.getString())) {
                t.report(n, EVAL_DECLARATION, new String[0]);
            } else if ("arguments".equals(n.getString())) {
                t.report(n, ARGUMENTS_DECLARATION, new String[0]);
            } else if (n.getString().endsWith("__") && !StrictModeCheck.this.noCajaChecks) {
                t.report(n, ILLEGAL_NAME, new String[0]);
            }
        }

        private void checkProperty(NodeTraversal t, Node n) {
            if (n.getLastChild().getString().endsWith("__") && !StrictModeCheck.this.noCajaChecks) {
                t.report(n.getLastChild(), ILLEGAL_NAME, new String[0]);
            }
        }
    }
}

