/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.HotSwapCompilerPass;

public abstract class PassFactory {
    private final String name;
    private final boolean isOneTimePass;
    private boolean isCreated = false;

    protected PassFactory(String name, boolean isOneTimePass) {
        this.name = name;
        this.isOneTimePass = isOneTimePass;
    }

    String getName() {
        return this.name;
    }

    boolean isOneTimePass() {
        return this.isOneTimePass;
    }

    PassFactory makeOneTimePass() {
        if (this.isOneTimePass()) {
            return this;
        }
        final PassFactory self = this;
        return new PassFactory(this.name, true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler compiler) {
                return self.createInternal(compiler);
            }

            @Override
            HotSwapCompilerPass getHotSwapPass(AbstractCompiler compiler) {
                return self.getHotSwapPass(compiler);
            }
        };
    }

    final CompilerPass create(AbstractCompiler compiler) {
        Preconditions.checkState((!this.isCreated || !this.isOneTimePass ? 1 : 0) != 0, (Object)("One-time passes cannot be run multiple times: " + this.name));
        this.isCreated = true;
        return this.createInternal(compiler);
    }

    protected abstract CompilerPass createInternal(AbstractCompiler var1);

    HotSwapCompilerPass getHotSwapPass(AbstractCompiler compiler) {
        return null;
    }
}

