/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class GlobalVarReferenceMap
implements ReferenceCollectingCallback.ReferenceMap {
    private Map<String, ReferenceCollectingCallback.ReferenceCollection> refMap = null;
    private final Map<InputId, Integer> inputOrder = Maps.newHashMap();

    GlobalVarReferenceMap(List<CompilerInput> inputs, List<CompilerInput> externs) {
        int ind = 0;
        for (CompilerInput extern : externs) {
            this.inputOrder.put(extern.getInputId(), ind);
            ++ind;
        }
        for (CompilerInput input : inputs) {
            this.inputOrder.put(input.getInputId(), ind);
            ++ind;
        }
    }

    @Override
    public ReferenceCollectingCallback.ReferenceCollection getReferences(Scope.Var var) {
        if (!var.isGlobal()) {
            return null;
        }
        return this.refMap.get(var.getName());
    }

    private void resetGlobalVarReferences(Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> globalRefMap) {
        this.refMap = Maps.newHashMap();
        for (Map.Entry<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> entry : globalRefMap.entrySet()) {
            Scope.Var var = entry.getKey();
            if (!var.isGlobal()) continue;
            this.refMap.put(var.getName(), entry.getValue());
        }
    }

    void updateGlobalVarReferences(Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> refMapPatch, Node root) {
        if (this.refMap == null || root.getType() != 132) {
            this.resetGlobalVarReferences(refMapPatch);
            return;
        }
        InputId inputId = root.getInputId();
        Preconditions.checkNotNull((Object)inputId);
        this.removeScriptReferences(inputId);
        for (Map.Entry<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> entry : refMapPatch.entrySet()) {
            Scope.Var var = entry.getKey();
            if (!var.isGlobal()) continue;
            this.replaceReferences(var.getName(), inputId, entry.getValue());
        }
    }

    private void removeScriptReferences(InputId inputId) {
        Preconditions.checkNotNull((Object)inputId);
        for (ReferenceCollectingCallback.ReferenceCollection collection : this.refMap.values()) {
            if (collection == null) continue;
            List<ReferenceCollectingCallback.Reference> oldRefs = collection.references;
            SourceRefRange range = this.findSourceRefRange(oldRefs, inputId);
            ArrayList newRefs = Lists.newArrayList(range.refsBefore());
            newRefs.addAll(range.refsAfter());
            collection.references = newRefs;
        }
    }

    private void replaceReferences(String varName, InputId inputId, ReferenceCollectingCallback.ReferenceCollection newSourceCollection) {
        ReferenceCollectingCallback.ReferenceCollection combined = new ReferenceCollectingCallback.ReferenceCollection();
        List<ReferenceCollectingCallback.Reference> combinedRefs = combined.references;
        ReferenceCollectingCallback.ReferenceCollection oldCollection = this.refMap.get(varName);
        this.refMap.put(varName, combined);
        if (oldCollection == null) {
            combinedRefs.addAll(newSourceCollection.references);
            return;
        }
        SourceRefRange range = this.findSourceRefRange(oldCollection.references, inputId);
        combinedRefs.addAll(range.refsBefore());
        combinedRefs.addAll(newSourceCollection.references);
        combinedRefs.addAll(range.refsAfter());
    }

    private SourceRefRange findSourceRefRange(List<ReferenceCollectingCallback.Reference> refList, InputId inputId) {
        Preconditions.checkNotNull((Object)inputId);
        int lastBefore = -1;
        int firstAfter = refList.size();
        int index = 0;
        Preconditions.checkState((boolean)this.inputOrder.containsKey(inputId), (Object)inputId.getIdName());
        int sourceInputOrder = this.inputOrder.get(inputId);
        for (ReferenceCollectingCallback.Reference ref : refList) {
            Preconditions.checkNotNull((Object)ref.getInputId());
            int order = this.inputOrder.get(ref.getInputId());
            if (order < sourceInputOrder) {
                lastBefore = index;
            } else if (order > sourceInputOrder) {
                firstAfter = index;
                break;
            }
            ++index;
        }
        return new SourceRefRange(refList, lastBefore, firstAfter);
    }

    private static class SourceRefRange {
        private final int lastBefore;
        private final int firstAfter;
        private final List<ReferenceCollectingCallback.Reference> refList;

        SourceRefRange(List<ReferenceCollectingCallback.Reference> refList, int lastBefore, int firstAfter) {
            this.lastBefore = Math.max(lastBefore, -1);
            this.firstAfter = Math.min(firstAfter, refList.size());
            this.refList = refList;
        }

        List<ReferenceCollectingCallback.Reference> refsBefore() {
            return this.refList.subList(0, this.lastBefore + 1);
        }

        List<ReferenceCollectingCallback.Reference> refsAfter() {
            return this.refList.subList(this.firstAfter, this.refList.size());
        }
    }
}

