/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class CheckPropertyOrder
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNASSIGNED_PROPERTY = DiagnosticType.error("UNASSIGNED_PROPERTY", "not all control paths assign property {1} in function {0}");
    static final DiagnosticType UNEQUAL_PROPERTIES = DiagnosticType.error("UNEQUAL_PROPERTIES", "different control paths produce different (ordered) property lists: {0} vs. {1}");
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private final boolean onlyOneError;
    private int errorCount;

    CheckPropertyOrder(AbstractCompiler compiler, CheckLevel level) {
        this(compiler, level, false);
    }

    CheckPropertyOrder(AbstractCompiler compiler, CheckLevel level, boolean onlyOneError) {
        this.compiler = compiler;
        this.level = level;
        this.onlyOneError = onlyOneError;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node func = null;
        String funcName = null;
        if (NodeUtil.isFunction(n) && CheckPropertyOrder.isConstructor(n)) {
            func = n;
            funcName = n.getFirstChild().getString();
        } else if (NodeUtil.isAssign(n) && NodeUtil.isFunction(n.getFirstChild().getNext()) && CheckPropertyOrder.isConstructor(n)) {
            func = n.getFirstChild().getNext();
            funcName = n.getFirstChild().getQualifiedName();
        }
        if (func != null) {
            FunctionType funcType = (FunctionType)func.getJSType();
            this.checkConstructor(func, funcType != null ? funcType.getInstanceType() : null, t.getSourceName(), funcName);
        }
    }

    private static boolean isConstructor(Node n) {
        return n.getJSDocInfo() != null && n.getJSDocInfo().isConstructor();
    }

    private void checkConstructor(Node func, ObjectType objType, String sourceName, String funcName) {
        Preconditions.checkArgument((boolean)NodeUtil.isFunction(func));
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, func.getFirstChild().getNext().getNext());
        ControlFlowGraph<Node> cfg = cfa.getCfg();
        new PropertyOrdersFlowAnalysis(cfa.getCfg()).analyze();
        Object ann = cfa.getCfg().getImplicitReturn().getAnnotation();
        List<String>[] orders = ((PropertyOrders)((DataFlowAnalysis.FlowState)ann).getIn()).getOrders();
        if (orders.length == 0) {
            throw new AssertionError((Object)("no paths through constructor " + funcName + "?"));
        }
        if (orders.length > 1) {
            this.report(sourceName, func, UNEQUAL_PROPERTIES, CheckPropertyOrder.reverse(orders[0]).toString(), CheckPropertyOrder.reverse(orders[1]).toString());
        }
        if (objType != null) {
            for (String propName : objType.getOwnPropertyNames()) {
                if (orders[0].contains(propName)) continue;
                this.report(sourceName, func, UNASSIGNED_PROPERTY, funcName, propName);
            }
        }
    }

    private void report(String srcName, Node node, DiagnosticType type, String ... args) {
        if (!this.onlyOneError || ++this.errorCount <= 1) {
            this.compiler.report(JSError.make(srcName, node, this.level, type, args));
        }
    }

    private static <T> List<T> reverse(List<T> seq) {
        if (seq.isEmpty()) {
            return seq;
        }
        ArrayList rev = Lists.newArrayList(seq);
        Collections.reverse(seq);
        return rev;
    }

    private static class PropertyOrdersFlowAnalysis
    extends DataFlowAnalysis<Node, PropertyOrders> {
        public PropertyOrdersFlowAnalysis(ControlFlowGraph<Node> cfg) {
            super(cfg, new OrdersJoinOp());
        }

        @Override
        public boolean isForward() {
            return true;
        }

        @Override
        public PropertyOrders createInitialEstimateLattice() {
            return PropertyOrders.EMPTY;
        }

        @Override
        public PropertyOrders createEntryLattice() {
            HashSet orders = Sets.newHashSet();
            orders.add(new Stack());
            return new PropertyOrders(orders);
        }

        @Override
        public PropertyOrders flowThrough(Node node, PropertyOrders input) {
            switch (node.getType()) {
                case 105: 
                case 125: 
                case 126: {
                    return input;
                }
                case 108: 
                case 113: 
                case 114: {
                    return this.flowThrough(NodeUtil.getConditionExpression(node), input);
                }
                case 110: 
                case 119: {
                    return this.flowThrough(node.getFirstChild(), input);
                }
                case 115: {
                    if (node.getChildCount() == 4) {
                        Node pre = node.getFirstChild();
                        Node cond = pre.getNext();
                        return this.flowThrough(cond, this.flowThrough(pre, input));
                    }
                    Node lhs = node.getFirstChild();
                    Node rhs = lhs.getNext();
                    return this.flowThrough(rhs, this.flowThrough(lhs, input));
                }
                case 98: {
                    Node cond = node.getFirstChild();
                    input = this.flowThrough(cond, input);
                    Node ifTrue = cond.getNext();
                    Node ifFalse = ifTrue.getNext();
                    return this.join(this.flowThrough(ifTrue, input), this.flowThrough(ifFalse, input));
                }
                case 100: 
                case 101: {
                    Node left = node.getFirstChild();
                    Node right = left.getNext();
                    input = this.flowThrough(left, input);
                    return this.join(input, this.flowThrough(right, input));
                }
                case 86: {
                    Node lhs = node.getFirstChild();
                    Node rhs = lhs.getNext();
                    if (lhs.getType() == 33) {
                        Node llhs = lhs.getFirstChild();
                        Node lrhs = llhs.getNext();
                        if (llhs.getType() == 42 && lrhs.getType() == 40 && lrhs.getNext() == null) {
                            return this.flowThrough(rhs, input.copyAndAdd(lrhs.getString()));
                        }
                    }
                    return this.flowThrough(rhs, this.flowThrough(lhs, input));
                }
            }
            for (node = node.getFirstChild(); node != null; node = node.getNext()) {
                input = this.flowThrough(node, input);
            }
            return input;
        }
    }

    private static class PropertyOrders
    implements LatticeElement {
        public static final PropertyOrders EMPTY = new PropertyOrders(Sets.newHashSet());
        private final Set<List<String>> orders;

        private PropertyOrders(Set<List<String>> orders) {
            this.orders = orders;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PropertyOrders)) {
                return false;
            }
            return ((Object)this.orders).equals(((PropertyOrders)other).orders);
        }

        /*
         * WARNING - void declaration
         */
        public PropertyOrders copyAndAdd(String propName) {
            HashSet orders = Sets.newHashSet();
            for (List<String> list : this.orders) {
                void var4_4;
                if (!list.contains(propName)) {
                    ArrayList nOrder = Lists.newArrayList(list);
                    nOrder.add(propName);
                    ArrayList arrayList = nOrder;
                }
                orders.add(var4_4);
            }
            return new PropertyOrders(orders);
        }

        public List<String>[] getOrders() {
            int minSize = Integer.MAX_VALUE;
            for (List<String> seq : this.orders) {
                minSize = Math.min(minSize, seq.size());
            }
            HashSet orders = Sets.newHashSet();
            for (List<String> seq : this.orders) {
                orders.add(seq.subList(0, minSize));
            }
            return orders.toArray(new List[orders.size()]);
        }

        public String toString() {
            return "{" + Joiner.on((String)", ").join(this.orders) + "}";
        }
    }

    private static class OrdersJoinOp
    extends JoinOp.BinaryJoinOp<PropertyOrders> {
        private OrdersJoinOp() {
        }

        @Override
        public PropertyOrders apply(PropertyOrders a, PropertyOrders b) {
            return new PropertyOrders(Sets.newHashSet((Iterable)Sets.union((Set)a.orders, (Set)b.orders)));
        }
    }
}

