/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.List;

class AstParallelizer {
    public static final String TEMP_NAME = "JSC_TMP_PLACE_HOLDER";
    private final Predicate<Node> shouldSplit;
    private final Supplier<Node> placeHolderProvider;
    private final List<Node> forest;
    private final Node root;
    private final boolean includeRoot;
    private final List<DettachPoint> detachPointList;

    public AstParallelizer(Predicate<Node> shouldSplit, Predicate<Node> shouldTraverse, Supplier<Node> placeHolderProvider, Node root, boolean includeRoot) {
        this.shouldSplit = shouldSplit;
        this.placeHolderProvider = placeHolderProvider;
        this.root = root;
        this.includeRoot = includeRoot;
        this.forest = Lists.newLinkedList();
        this.detachPointList = Lists.newLinkedList();
    }

    public static AstParallelizer createNewFunctionLevelAstParallelizer(Node root, boolean globalPass) {
        Predicate<Node> shouldSplit = new Predicate<Node>(){

            public boolean apply(Node input) {
                return NodeUtil.isFunction(input);
            }
        };
        Predicate<Node> shouldTraverse = new Predicate<Node>(){

            public boolean apply(Node ignored) {
                return true;
            }
        };
        Supplier<Node> placeHolders = new Supplier<Node>(){

            public Node get() {
                return new Node(105, Node.newString(38, AstParallelizer.TEMP_NAME), new Node(83), new Node(125));
            }
        };
        return new AstParallelizer(shouldSplit, shouldTraverse, placeHolders, root, globalPass);
    }

    public static AstParallelizer createNewFileLevelAstParallelizer(Node root) {
        Predicate<Node> shouldSplit = new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.getSourceFileName() != null;
            }
        };
        Supplier<Node> placeHolders = new Supplier<Node>(){

            public Node get() {
                return NodeUtil.newExpr(Node.newString(AstParallelizer.TEMP_NAME));
            }
        };
        Predicate<Node> shouldTraverse = new Predicate<Node>(){

            public boolean apply(Node n) {
                return n.getType() == 125;
            }
        };
        return new AstParallelizer(shouldSplit, shouldTraverse, placeHolders, root, false);
    }

    private void recordSplitPoint(Node placeHolder, Node before, Node orginal) {
        this.detachPointList.add(new DettachPoint(placeHolder, before, orginal));
    }

    public List<Node> split() {
        if (this.includeRoot) {
            this.forest.add(this.root);
        }
        this.split(this.root);
        return this.forest;
    }

    private void split(Node n) {
        Node c = n.getFirstChild();
        Node before = null;
        while (c != null) {
            Node next = c.getNext();
            if (this.shouldSplit.apply((Object)c)) {
                Node placeHolder = (Node)this.placeHolderProvider.get();
                if (before == null) {
                    this.forest.add(n.removeFirstChild());
                    n.addChildToFront(placeHolder);
                } else {
                    n.addChildAfter(placeHolder, c);
                    n.removeChildAfter(before);
                    this.forest.add(c);
                }
                this.recordSplitPoint(placeHolder, before, c);
                before = placeHolder;
            } else {
                this.split(c);
                before = c;
            }
            c = next;
        }
    }

    public void join() {
        while (!this.detachPointList.isEmpty()) {
            DettachPoint entry = this.detachPointList.remove(this.detachPointList.size() - 1);
            entry.reattach();
        }
    }

    private static class DettachPoint {
        private Node placeHolder;
        private Node before;
        private Node original;

        private DettachPoint(Node placeHolder, Node before, Node orginal) {
            this.placeHolder = placeHolder;
            this.before = before;
            this.original = orginal;
        }

        public void reattach() {
            if (this.placeHolder.getParent() != null) {
                if (this.before == null) {
                    this.placeHolder.getParent().addChildrenToFront(this.original);
                    this.placeHolder.getParent().removeChildAfter(this.original);
                } else {
                    this.placeHolder.getParent().addChildAfter(this.original, this.before);
                    this.placeHolder.getParent().removeChildAfter(this.original);
                }
            }
        }
    }
}

