/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.NonThrowingCloseable;
import com.google.instrumentation.stats.StatsContext;
import io.grpc.Context;

public final class ContextUtils {
    public static final Context.Key<StatsContext> STATS_CONTEXT_KEY = Context.key((String)"instrumentation-stats-key");

    private ContextUtils() {
    }

    static StatsContext getCurrentStatsContext() {
        return (StatsContext)STATS_CONTEXT_KEY.get(Context.current());
    }

    static NonThrowingCloseable withStatsContext(StatsContext statsContext) {
        return new WithStatsContext(statsContext, STATS_CONTEXT_KEY);
    }

    private static final class WithStatsContext
    implements NonThrowingCloseable {
        private final Context origContext;

        private WithStatsContext(StatsContext statsContext, Context.Key<StatsContext> contextKey) {
            this.origContext = Context.current().withValue(contextKey, (Object)statsContext).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
        }
    }
}

