/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpRequest;
import com.google.api.client.http.apache.HttpPatch;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class ApacheHttpTransport
extends HttpTransport {
    private final HttpClient httpClient;

    public ApacheHttpTransport() {
        this((HttpClient)ApacheHttpTransport.newDefaultHttpClient());
    }

    public ApacheHttpTransport(HttpClient httpClient) {
        this.httpClient = httpClient;
        HttpParams params = httpClient.getParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        params.setBooleanParameter("http.protocol.handle-redirects", false);
    }

    public static DefaultHttpClient newDefaultHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)200);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(20));
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)params, registry);
        return new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
    }

    public boolean supportsHead() {
        return true;
    }

    public boolean supportsPatch() {
        return true;
    }

    public ApacheHttpRequest buildDeleteRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpDelete(url));
    }

    public ApacheHttpRequest buildGetRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpGet(url));
    }

    public ApacheHttpRequest buildHeadRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpHead(url));
    }

    public ApacheHttpRequest buildPatchRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPatch(url));
    }

    public ApacheHttpRequest buildPostRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPost(url));
    }

    public ApacheHttpRequest buildPutRequest(String url) {
        return new ApacheHttpRequest(this.httpClient, (HttpRequestBase)new HttpPut(url));
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

