/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpTransport
extends HttpTransport {
    public static final Set<HttpMethod> DEFAULT_SUPPORTED_OPTIONAL_METHODS = Collections.unmodifiableSet(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.HEAD, HttpMethod.PATCH)));
    @Deprecated
    public EnumSet<HttpMethod> supportedOptionalMethods = EnumSet.of(HttpMethod.HEAD, HttpMethod.PATCH);

    public MockHttpTransport() {
    }

    protected MockHttpTransport(Set<HttpMethod> supportedOptionalMethods) {
        this.supportedOptionalMethods = supportedOptionalMethods.isEmpty() ? EnumSet.noneOf(HttpMethod.class) : EnumSet.copyOf(supportedOptionalMethods);
    }

    public final Set<HttpMethod> getSupportedOptionalMethods() {
        return this.supportedOptionalMethods;
    }

    public void setSupportedOptionalMethods(EnumSet<HttpMethod> supportedOptionalMethods) {
        this.supportedOptionalMethods = supportedOptionalMethods;
    }

    @Override
    public LowLevelHttpRequest buildDeleteRequest(String url) throws IOException {
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public LowLevelHttpRequest buildGetRequest(String url) throws IOException {
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        if (!this.supportsHead()) {
            return super.buildHeadRequest(url);
        }
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public LowLevelHttpRequest buildPatchRequest(String url) throws IOException {
        if (!this.supportsPatch()) {
            return super.buildPatchRequest(url);
        }
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public LowLevelHttpRequest buildPostRequest(String url) throws IOException {
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public LowLevelHttpRequest buildPutRequest(String url) throws IOException {
        return new MockLowLevelHttpRequest(url);
    }

    @Override
    public boolean supportsHead() {
        return this.supportedOptionalMethods.contains((Object)HttpMethod.HEAD);
    }

    @Override
    public boolean supportsPatch() {
        return this.supportedOptionalMethods.contains((Object)HttpMethod.PATCH);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Set<HttpMethod> supportedOptionalMethods = DEFAULT_SUPPORTED_OPTIONAL_METHODS;

        protected Builder() {
        }

        public MockHttpTransport build() {
            return new MockHttpTransport(this.supportedOptionalMethods);
        }

        public final Set<HttpMethod> getSupportedOptionalMethods() {
            return this.supportedOptionalMethods;
        }

        public Builder setSupportedOptionalMethods(Set<HttpMethod> supportedOptionalMethods) {
            this.supportedOptionalMethods = supportedOptionalMethods;
            return this;
        }
    }
}

