/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.json;

import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonString;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Types;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonParser {
    public abstract JsonFactory getFactory();

    public abstract void close() throws IOException;

    public abstract JsonToken nextToken() throws IOException;

    public abstract JsonToken getCurrentToken();

    public abstract String getCurrentName() throws IOException;

    public abstract JsonParser skipChildren() throws IOException;

    public abstract String getText() throws IOException;

    public abstract byte getByteValue() throws IOException;

    public abstract short getShortValue() throws IOException;

    public abstract int getIntValue() throws IOException;

    public abstract float getFloatValue() throws IOException;

    public abstract long getLongValue() throws IOException;

    public abstract double getDoubleValue() throws IOException;

    public abstract BigInteger getBigIntegerValue() throws IOException;

    public abstract BigDecimal getDecimalValue() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parseAndClose(Class<T> destinationClass, CustomizeJsonParser customizeParser) throws IOException {
        try {
            T t = this.parse(destinationClass, customizeParser);
            return t;
        }
        finally {
            this.close();
        }
    }

    public final void skipToKey(String keyToFind) throws IOException {
        JsonToken curToken = this.startParsingObjectOrArray();
        while (curToken == JsonToken.FIELD_NAME) {
            String key = this.getText();
            this.nextToken();
            if (keyToFind.equals(key)) break;
            this.skipChildren();
            curToken = this.nextToken();
        }
    }

    private JsonToken startParsing() throws IOException {
        JsonToken currentToken = this.getCurrentToken();
        if (currentToken == null) {
            currentToken = this.nextToken();
        }
        Preconditions.checkArgument((currentToken != null ? 1 : 0) != 0, (Object)"no JSON input found");
        return currentToken;
    }

    private JsonToken startParsingObjectOrArray() throws IOException {
        JsonToken currentToken = this.startParsing();
        switch (currentToken) {
            case START_OBJECT: {
                currentToken = this.nextToken();
                Preconditions.checkArgument((currentToken == JsonToken.FIELD_NAME || currentToken == JsonToken.END_OBJECT ? 1 : 0) != 0, (Object)((Object)currentToken));
                break;
            }
            case START_ARRAY: {
                currentToken = this.nextToken();
            }
        }
        return currentToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseAndClose(Object destination, CustomizeJsonParser customizeParser) throws IOException {
        try {
            this.parse(destination, customizeParser);
        }
        finally {
            this.close();
        }
    }

    public final <T> T parse(Class<T> destinationClass, CustomizeJsonParser customizeParser) throws IOException {
        this.startParsing();
        Object result = this.parseValue(null, destinationClass, new ArrayList<Type>(), null, customizeParser);
        return (T)result;
    }

    public final void parse(Object destination, CustomizeJsonParser customizeParser) throws IOException {
        ArrayList<Type> context = new ArrayList<Type>();
        context.add(destination.getClass());
        this.parse(context, destination, customizeParser);
    }

    private void parse(ArrayList<Type> context, Object destination, CustomizeJsonParser customizeParser) throws IOException {
        if (destination instanceof GenericJson) {
            ((GenericJson)destination).jsonFactory = this.getFactory();
        }
        JsonToken curToken = this.startParsingObjectOrArray();
        Class<?> destinationClass = destination.getClass();
        ClassInfo classInfo = ClassInfo.of(destinationClass);
        boolean isGenericData = GenericData.class.isAssignableFrom(destinationClass);
        if (!isGenericData && Map.class.isAssignableFrom(destinationClass)) {
            Map destinationMap = (Map)destination;
            this.parseMap(destinationMap, Types.getMapValueParameter(destinationClass), context, customizeParser);
            return;
        }
        while (curToken == JsonToken.FIELD_NAME) {
            String key = this.getText();
            this.nextToken();
            if (customizeParser != null && customizeParser.stopAt(destination, key)) {
                return;
            }
            FieldInfo fieldInfo = classInfo.getFieldInfo(key);
            if (fieldInfo != null) {
                if (fieldInfo.isFinal() && !fieldInfo.isPrimitive()) {
                    throw new IllegalArgumentException("final array/object fields are not supported");
                }
                Field field = fieldInfo.getField();
                int contextSize = context.size();
                context.add(field.getGenericType());
                Object fieldValue = this.parseValue(field, fieldInfo.getGenericType(), context, destination, customizeParser);
                context.remove(contextSize);
                fieldInfo.setValue(destination, fieldValue);
            } else if (isGenericData) {
                GenericData object = (GenericData)destination;
                object.set(key, this.parseValue(null, null, context, destination, customizeParser));
            } else {
                if (customizeParser != null) {
                    customizeParser.handleUnrecognizedKey(destination, key);
                }
                this.skipChildren();
            }
            curToken = this.nextToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> Collection<T> parseArrayAndClose(Class<?> destinationCollectionClass, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        try {
            Collection<T> collection = this.parseArray(destinationCollectionClass, destinationItemClass, customizeParser);
            return collection;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void parseArrayAndClose(Collection<? super T> destinationCollection, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        try {
            this.parseArray(destinationCollection, destinationItemClass, customizeParser);
        }
        finally {
            this.close();
        }
    }

    public final <T> Collection<T> parseArray(Class<?> destinationCollectionClass, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        Collection<Object> destinationCollection = Data.newCollectionInstance(destinationCollectionClass);
        this.parseArray(destinationCollection, destinationItemClass, customizeParser);
        return destinationCollection;
    }

    public final <T> void parseArray(Collection<? super T> destinationCollection, Class<T> destinationItemClass, CustomizeJsonParser customizeParser) throws IOException {
        this.parseArray(destinationCollection, destinationItemClass, new ArrayList<Type>(), customizeParser);
    }

    private <T> void parseArray(Collection<T> destinationCollection, Type destinationItemType, ArrayList<Type> context, CustomizeJsonParser customizeParser) throws IOException {
        JsonToken curToken = this.startParsingObjectOrArray();
        while (curToken != JsonToken.END_ARRAY) {
            Object parsedValue = this.parseValue(null, destinationItemType, context, destinationCollection, customizeParser);
            destinationCollection.add(parsedValue);
            curToken = this.nextToken();
        }
    }

    private void parseMap(Map<String, Object> destinationMap, Type valueType, ArrayList<Type> context, CustomizeJsonParser customizeParser) throws IOException {
        JsonToken curToken = this.startParsingObjectOrArray();
        while (curToken == JsonToken.FIELD_NAME) {
            String key = this.getText();
            this.nextToken();
            if (customizeParser != null && customizeParser.stopAt(destinationMap, key)) {
                return;
            }
            Object value = this.parseValue(null, valueType, context, destinationMap, customizeParser);
            destinationMap.put(key, value);
            curToken = this.nextToken();
        }
    }

    private final Object parseValue(Field field, Type valueType, ArrayList<Type> context, Object destination, CustomizeJsonParser customizeParser) throws IOException {
        Class<Comparable<Boolean>> valueClass;
        Class<Comparable<Boolean>> clazz = valueClass = (valueType = Data.resolveWildcardTypeOrTypeVariable(context, valueType)) instanceof Class ? (Class<Comparable<Boolean>>)valueType : null;
        if (valueType instanceof ParameterizedType) {
            valueClass = Types.getRawClass((ParameterizedType)valueType);
        }
        JsonToken token = this.getCurrentToken();
        switch (token) {
            case START_ARRAY: 
            case END_ARRAY: {
                boolean isArray = Types.isArray(valueType);
                Preconditions.checkArgument((valueType == null || isArray || valueClass != null && Types.isAssignableToOrFrom(valueClass, Collection.class) ? 1 : 0) != 0, (String)"%s: expected collection or array type but got %s for field %s", (Object[])new Object[]{this.getCurrentName(), valueType, field});
                Collection<Object> collectionValue = null;
                if (customizeParser != null && field != null) {
                    collectionValue = customizeParser.newInstanceForArray(destination, field);
                }
                if (collectionValue == null) {
                    collectionValue = Data.newCollectionInstance(valueType);
                }
                Type subType = null;
                if (isArray) {
                    subType = Types.getArrayComponentType(valueType);
                } else if (valueClass != null && Iterable.class.isAssignableFrom(valueClass)) {
                    subType = Types.getIterableParameter(valueType);
                }
                subType = Data.resolveWildcardTypeOrTypeVariable(context, subType);
                this.parseArray(collectionValue, subType, context, customizeParser);
                if (isArray) {
                    return Types.toArray(collectionValue, Types.getRawArrayComponentType(context, subType));
                }
                return collectionValue;
            }
            case START_OBJECT: 
            case FIELD_NAME: 
            case END_OBJECT: {
                boolean isMap;
                Preconditions.checkArgument((!Types.isArray(valueType) ? 1 : 0) != 0, (String)"%s: expected object or map type but got %s for field %s", (Object[])new Object[]{this.getCurrentName(), valueType, field});
                Map<String, Object> newInstance = null;
                if (valueClass != null && customizeParser != null) {
                    newInstance = customizeParser.newInstanceForObject(destination, valueClass);
                }
                boolean bl = isMap = valueClass != null && Types.isAssignableToOrFrom(valueClass, Map.class);
                if (newInstance == null) {
                    newInstance = isMap || valueClass == null ? Data.newMapInstance(valueClass) : Types.newInstance(valueClass);
                }
                int contextSize = context.size();
                if (valueType != null) {
                    context.add(valueType);
                }
                if (isMap && !GenericData.class.isAssignableFrom(valueClass)) {
                    Type subValueType;
                    Type type = subValueType = Map.class.isAssignableFrom(valueClass) ? Types.getMapValueParameter(valueType) : null;
                    if (subValueType != null) {
                        Map<String, Object> destinationMap = newInstance;
                        this.parseMap(destinationMap, subValueType, context, customizeParser);
                        return newInstance;
                    }
                }
                this.parse(context, newInstance, customizeParser);
                if (valueType != null) {
                    context.remove(contextSize);
                }
                return newInstance;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                Preconditions.checkArgument((valueType == null || valueClass == Boolean.TYPE || valueClass != null && valueClass.isAssignableFrom(Boolean.class) ? 1 : 0) != 0, (String)("%s: expected type Boolean or boolean but got %s for field %s" + field), (Object[])new Object[]{this.getCurrentName(), valueType, field});
                return token == JsonToken.VALUE_TRUE ? Boolean.TRUE : Boolean.FALSE;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                Preconditions.checkArgument((field == null || field.getAnnotation(JsonString.class) == null ? 1 : 0) != 0, (String)"%s: number type formatted as a JSON number cannot use @JsonString annotation on the field %s", (Object[])new Object[]{this.getCurrentName(), field});
                if (valueClass == null || valueClass.isAssignableFrom(BigDecimal.class)) {
                    return this.getDecimalValue();
                }
                if (valueClass == BigInteger.class) {
                    return this.getBigIntegerValue();
                }
                if (valueClass == Double.class || valueClass == Double.TYPE) {
                    return this.getDoubleValue();
                }
                if (valueClass == Long.class || valueClass == Long.TYPE) {
                    return this.getLongValue();
                }
                if (valueClass == Float.class || valueClass == Float.TYPE) {
                    return Float.valueOf(this.getFloatValue());
                }
                if (valueClass == Integer.class || valueClass == Integer.TYPE) {
                    return this.getIntValue();
                }
                if (valueClass == Short.class || valueClass == Short.TYPE) {
                    return this.getShortValue();
                }
                if (valueClass == Byte.class || valueClass == Byte.TYPE) {
                    return this.getByteValue();
                }
                throw new IllegalArgumentException(this.getCurrentName() + ": expected numeric type but got " + valueType + " for field " + field);
            }
            case VALUE_STRING: {
                Preconditions.checkArgument((valueClass == null || !Number.class.isAssignableFrom(valueClass) || field != null && field.getAnnotation(JsonString.class) != null ? 1 : 0) != 0, (String)"%s: number field formatted as a JSON string must use the @JsonString annotation: %s", (Object[])new Object[]{this.getCurrentName(), field});
                try {
                    return Data.parsePrimitiveValue(valueType, this.getText());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(this.getCurrentName() + " for field " + field, e);
                }
            }
            case VALUE_NULL: {
                Preconditions.checkArgument((valueClass == null || !valueClass.isPrimitive() ? 1 : 0) != 0, (String)"%s: primitive number field but found a JSON null: %s", (Object[])new Object[]{this.getCurrentName(), field});
                if (valueClass != null && 0 != (valueClass.getModifiers() & 0x600)) {
                    if (Types.isAssignableToOrFrom(valueClass, Collection.class)) {
                        return Data.nullOf(Data.newCollectionInstance(valueType).getClass());
                    }
                    if (Types.isAssignableToOrFrom(valueClass, Map.class)) {
                        return Data.nullOf(Data.newMapInstance(valueClass).getClass());
                    }
                }
                return Data.nullOf(Types.getRawArrayComponentType(context, valueType));
            }
        }
        throw new IllegalArgumentException(this.getCurrentName() + ": unexpected JSON node type: " + (Object)((Object)token));
    }
}

