/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http.javanet;

import com.google.api.client.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class MockHttpURLConnection
extends HttpURLConnection {
    private boolean doOutputCalled;
    private OutputStream outputStream = new ByteArrayOutputStream(0);

    public MockHttpURLConnection(URL u) {
        super(u);
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    public void connect() throws IOException {
    }

    public int getResponseCode() throws IOException {
        return this.responseCode;
    }

    public void setDoOutput(boolean dooutput) {
        this.doOutputCalled = true;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        return super.getOutputStream();
    }

    public final boolean doOutputCalled() {
        return this.doOutputCalled;
    }

    public MockHttpURLConnection setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public MockHttpURLConnection setResponseCode(int responseCode) {
        Preconditions.checkArgument(responseCode >= -1);
        this.responseCode = responseCode;
        return this;
    }
}

