/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.LowLevelHttpRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class HttpTransport {
    static final Logger LOGGER = Logger.getLogger(HttpTransport.class.getName());
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "POST", "PUT"};

    public final HttpRequestFactory createRequestFactory() {
        return this.createRequestFactory(null);
    }

    public final HttpRequestFactory createRequestFactory(HttpRequestInitializer initializer) {
        return new HttpRequestFactory(this, initializer);
    }

    HttpRequest buildRequest() {
        return new HttpRequest(this, null);
    }

    @Deprecated
    public boolean supportsHead() throws IOException {
        return this.supportsMethod("HEAD");
    }

    @Deprecated
    public boolean supportsPatch() throws IOException {
        return this.supportsMethod("PATCH");
    }

    public boolean supportsMethod(String method) throws IOException {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        throw new IllegalArgumentException("HTTP method " + method + " not supported");
    }

    @Deprecated
    protected LowLevelHttpRequest buildDeleteRequest(String url) throws IOException {
        return this.buildRequest("DELETE", url);
    }

    @Deprecated
    protected LowLevelHttpRequest buildGetRequest(String url) throws IOException {
        return this.buildRequest("GET", url);
    }

    @Deprecated
    protected LowLevelHttpRequest buildHeadRequest(String url) throws IOException {
        return this.buildRequest("HEAD", url);
    }

    @Deprecated
    protected LowLevelHttpRequest buildPatchRequest(String url) throws IOException {
        return this.buildRequest("PATCH", url);
    }

    @Deprecated
    protected LowLevelHttpRequest buildPostRequest(String url) throws IOException {
        return this.buildRequest("POST", url);
    }

    @Deprecated
    protected LowLevelHttpRequest buildPutRequest(String url) throws IOException {
        return this.buildRequest("PUT", url);
    }

    public void shutdown() throws IOException {
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }
}

