/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.json;

import com.google.api.client.json.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractJsonGeneratorTest {
    protected abstract JsonGenerator newGenerator(Writer var1) throws IOException;

    @Test
    public void testSerialize_simpleMap() throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.newGenerator(writer);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        generator.serialize(map);
        generator.close();
        Assert.assertEquals((Object)"{\"a\":\"b\"}", (Object)writer.toString());
    }

    @Test
    public void testSerialize_iterableMap() throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = this.newGenerator(writer);
        IterableMap map = new IterableMap();
        map.put("a", "b");
        generator.serialize((Object)map);
        generator.close();
        Assert.assertEquals((Object)"{\"a\":\"b\"}", (Object)writer.toString());
    }

    class IterableMap
    extends HashMap<String, String>
    implements Iterable<Map.Entry<String, String>> {
        IterableMap() {
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.entrySet().iterator();
        }
    }
}

