/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
@Beta
public abstract class AbstractDataStoreFactoryTest {
    private static final String STRING_ID = "String";
    private static final String BOOLEAN_ID = "Boolean";
    DataStoreFactory dataStore;
    DataStore<String> stringTyped;
    DataStore<Boolean> boolTyped;

    protected abstract DataStoreFactory newDataStoreFactory() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.dataStore = this.newDataStoreFactory();
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        this.boolTyped = this.dataStore.getDataStore(BOOLEAN_ID);
    }

    @After
    public void tearDown() throws Exception {
        this.stringTyped.clear();
        Assert.assertTrue((boolean)this.stringTyped.values().isEmpty());
        this.boolTyped.clear();
        Assert.assertTrue((boolean)this.boolTyped.values().isEmpty());
    }

    private static void assertContentsAnyOrder(Collection<?> c, Object ... elts) {
        Assert.assertEquals((Object)Sets.newHashSet(c), (Object)Sets.newHashSet(Arrays.asList(elts)));
    }

    @Test
    public void testId() throws Exception {
        this.subtestIdNoException("1");
        this.subtestIdNoException("123456789012345678901234567890");
        this.subtestIdNoException("abcdefghijklmnopqrstuvwxyz");
        this.subtestIdNoException("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.subtestIdException("");
        this.subtestIdException(".");
        this.subtestIdException(" ");
        this.subtestIdException("1234567890123456789012345678901");
    }

    private void subtestIdException(String id) throws Exception {
        try {
            this.subtestIdNoException(id);
            Assert.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void subtestIdNoException(String id) throws Exception {
        this.newDataStoreFactory().getDataStore(id);
    }

    @Test
    public void testSet() throws Exception {
        Assert.assertNull((Object)this.stringTyped.get(null));
        Assert.assertNull((Object)this.stringTyped.get("k"));
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        Assert.assertEquals((Object)"v", (Object)this.stringTyped.get("k"));
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        Assert.assertEquals((Object)"v", (Object)this.stringTyped.get("k"));
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        Assert.assertEquals((Object)"v", (Object)this.stringTyped.get("k"));
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        Assert.assertEquals((Object)"new", (Object)this.stringTyped.get("k"));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        Assert.assertEquals((Object)"new", (Object)this.stringTyped.get("k"));
        Assert.assertEquals((Object)"other", (Object)this.stringTyped.get("k2"));
        try {
            this.stringTyped.set("k", null);
            Assert.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.stringTyped.set(null, (Serializable)((Object)"v"));
            Assert.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        Assert.assertNull((Object)this.boolTyped.get("k"));
        this.boolTyped.set("k", (Serializable)Boolean.valueOf(true));
        Assert.assertEquals((Object)"v", (Object)this.stringTyped.get("k"));
        Assert.assertTrue((boolean)((Boolean)this.boolTyped.get("k")));
    }

    @Test
    public void testValues() throws Exception {
        Assert.assertTrue((boolean)this.stringTyped.values().isEmpty());
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "new", "other");
        this.stringTyped.delete("k");
        Assert.assertNull((Object)this.stringTyped.get("k"));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "other");
        this.stringTyped.delete("k2");
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        Assert.assertTrue((boolean)this.boolTyped.values().isEmpty());
        this.boolTyped.set("k", (Serializable)Boolean.valueOf(true));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "v");
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.boolTyped.values(), true);
    }

    @Test
    public void testKeySet() throws Exception {
        Assert.assertTrue((boolean)this.stringTyped.keySet().isEmpty());
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        TreeSet expected = Sets.newTreeSet();
        expected.add("k");
        Assert.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        expected.add("k2");
        Assert.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.delete("k2");
        expected.remove("k2");
        Assert.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.delete("k");
        Assert.assertTrue((boolean)this.stringTyped.keySet().isEmpty());
    }

    @Test
    public void testDelete() throws Exception {
        this.stringTyped.set("k", (Serializable)((Object)"v")).set("k2", (Serializable)((Object)"v2"));
        Assert.assertFalse((boolean)this.stringTyped.isEmpty());
        Assert.assertEquals((long)2L, (long)this.stringTyped.size());
        this.stringTyped.delete("k2");
        Assert.assertNull((Object)this.stringTyped.get("k2"));
        this.stringTyped.delete("k2");
        Assert.assertNull((Object)this.stringTyped.get("k2"));
        Assert.assertEquals((Object)"v", (Object)this.stringTyped.get("k"));
        Assert.assertFalse((boolean)this.stringTyped.isEmpty());
        Assert.assertEquals((long)1L, (long)this.stringTyped.size());
        this.stringTyped.delete("k");
        Assert.assertNull((Object)this.stringTyped.get("k"));
        this.stringTyped.delete(null);
        Assert.assertTrue((boolean)this.stringTyped.isEmpty());
        Assert.assertEquals((long)0L, (long)this.stringTyped.size());
    }

    @Test
    public void testClear() throws Exception {
        this.stringTyped.set("k", (Serializable)((Object)"v")).set("k2", (Serializable)((Object)"v2"));
        this.stringTyped.clear();
        Assert.assertTrue((boolean)this.stringTyped.isEmpty());
        Assert.assertEquals((long)0L, (long)this.stringTyped.size());
        this.stringTyped.clear();
        Assert.assertTrue((boolean)this.stringTyped.isEmpty());
        Assert.assertEquals((long)0L, (long)this.stringTyped.size());
    }

    @Test
    public void testLarge() throws Exception {
        int size = 100;
        for (int i = 0; i < size; ++i) {
            this.stringTyped.set(String.valueOf(i), (Serializable)((Object)("hello" + i)));
        }
        Assert.assertEquals((long)size, (long)this.stringTyped.size());
        int mid = size / 2;
        Assert.assertEquals((Object)("hello" + mid), (Object)this.stringTyped.get(String.valueOf(mid)));
    }

    @Test
    public void testContainsKeyAndValue() throws Exception {
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k"));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        Assert.assertTrue((boolean)this.stringTyped.containsKey("k"));
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        Assert.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        Assert.assertTrue((boolean)this.stringTyped.containsKey("k"));
        Assert.assertTrue((boolean)this.stringTyped.containsKey("k2"));
        Assert.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        Assert.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.delete("k");
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k"));
        Assert.assertTrue((boolean)this.stringTyped.containsKey("k2"));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        Assert.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.clear();
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k"));
        Assert.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        Assert.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
    }
}

