/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.json;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractJsonParserTest {
    private static final String TEST_JSON = "{\"strValue\": \"bar\", \"intValue\": 123, \"boolValue\": false}";
    private static final String TEST_JSON_BIG_DECIMAL = "{\"bigDecimalValue\": 1559341956102}";

    protected abstract JsonFactory newJsonFactory();

    @Test
    public void testParse_basic() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        Assert.assertTrue((boolean)(json.get((Object)"strValue") instanceof String));
        Assert.assertEquals((Object)"bar", (Object)json.get((Object)"strValue"));
        Assert.assertTrue((boolean)(json.get((Object)"intValue") instanceof BigDecimal));
        Assert.assertEquals((Object)new BigDecimal(123), (Object)json.get((Object)"intValue"));
        Assert.assertTrue((boolean)(json.get((Object)"boolValue") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)json.get((Object)"boolValue"));
    }

    @Test
    public void testGetWrongType() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        Assert.assertTrue((boolean)(json.get((Object)"strValue") instanceof String));
        Assert.assertEquals((Object)"bar", (Object)json.get((Object)"strValue"));
        Assert.assertTrue((boolean)(json.get((Object)"intValue") instanceof BigDecimal));
        Assert.assertEquals((Object)new BigDecimal(123), (Object)json.get((Object)"intValue"));
        Assert.assertTrue((boolean)(json.get((Object)"boolValue") instanceof Boolean));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)json.get((Object)"boolValue"));
    }

    @Test
    public void testParse_badJson() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream("not json".getBytes(StandardCharsets.UTF_8));
        try {
            parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
            Assert.fail((String)"Malformed JSON not detected");
        }
        catch (IOException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testParse_bigDecimal() throws IOException {
        JsonObjectParser parser = new JsonObjectParser(this.newJsonFactory());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TEST_JSON_BIG_DECIMAL.getBytes(StandardCharsets.UTF_8));
        GenericJson json = (GenericJson)parser.parseAndClose((InputStream)inputStream, StandardCharsets.UTF_8, GenericJson.class);
        Assert.assertTrue((boolean)(json.get((Object)"bigDecimalValue") instanceof BigDecimal));
        Assert.assertEquals((Object)new BigDecimal("1559341956102"), (Object)json.get((Object)"bigDecimalValue"));
    }
}

