/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ksh" locale.
 */
public class LocalizedNamesImpl_ksh extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AR",
        "EG",
        "EC",
        "AL",
        "CI",
        "DZ",
        "SV",
        "AS",
        "AD",
        "AI",
        "AO",
        "AG",
        "GQ",
        "ER",
        "AM",
        "AW",
        "AC",
        "AZ",
        "EE",
        "ET",
        "AU",
        "BH",
        "BD",
        "BZ",
        "BE",
        "MM",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "BN",
        "BF",
        "BG",
        "BI",
        "BT",
        "CW",
        "BJ",
        "CG",
        "CD",
        "DK",
        "VI",
        "BS",
        "BM",
        "VG",
        "BV",
        "DG",
        "DO",
        "BB",
        "SJ",
        "TC",
        "IM",
        "SH",
        "LC",
        "EU",
        "FK",
        "FO",
        "FJ",
        "HM",
        "KY",
        "IC",
        "CV",
        "BQ",
        "CP",
        "CC",
        "KM",
        "CK",
        "MH",
        "NL",
        "MP",
        "NF",
        "AX",
        "PN",
        "ZA",
        "SN",
        "AQ",
        "TD",
        "VA",
        "CH",
        "SC",
        "SB",
        "TR",
        "CZ",
        "UA",
        "UM",
        "US",
        "CX",
        "CF",
        "BL",
        "MF",
        "DM",
        "DE",
        "DJ",
        "ME",
        "EZ",
        "PH",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "HT",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "GH",
        "GA",
        "GM",
        "JM",
        "YE",
        "JP",
        "GE",
        "GI",
        "GN",
        "GW",
        "GG",
        "JE",
        "JO",
        "GD",
        "GR",
        "GL",
        "GB",
        "GP",
        "GU",
        "GY",
        "GT",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "KE",
        "KI",
        "KG",
        "CO",
        "XK",
        "CR",
        "HR",
        "CU",
        "KW",
        "LV",
        "LA",
        "LB",
        "LS",
        "LY",
        "LR",
        "LI",
        "LT",
        "LU",
        "ML",
        "MQ",
        "MG",
        "YT",
        "MO",
        "MY",
        "MW",
        "MV",
        "MT",
        "MA",
        "MU",
        "MR",
        "MX",
        "MK",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NI",
        "NU",
        "KP",
        "SD",
        "NO",
        "OM",
        "AT",
        "TL",
        "QO",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "IR",
        "PT",
        "PR",
        "PL",
        "RE",
        "RO",
        "RW",
        "RU",
        "ZM",
        "WS",
        "SM",
        "RS",
        "SA",
        "CL",
        "CN",
        "ES",
        "SE",
        "ZW",
        "SG",
        "SL",
        "GS",
        "KR",
        "SS",
        "SO",
        "LK",
        "SY",
        "SR",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TK",
        "TO",
        "TG",
        "TT",
        "TA",
        "TN",
        "TM",
        "TV",
        "UG",
        "UN",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "AE",
        "VN",
        "WF",
        "EH",
        "BY",
        "XA",
        "XB",
        "EA",
        "KN",
        "SX",
        "PM",
        "ST",
        "VC",
        "CY",
        "SK",
        "SI",
        "SZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "de Ääd");
    namesMap.put("002", "Affrika");
    namesMap.put("003", "Nood-Amärrika");
    namesMap.put("005", "Söhd-Amärrika");
    namesMap.put("009", "Ozejahneje");
    namesMap.put("011", "Wäß-Affrika");
    namesMap.put("013", "Meddelammärrika");
    namesMap.put("014", "Oß-Affrika");
    namesMap.put("015", "Nood-Affrika");
    namesMap.put("017", "Meddel-Affrika");
    namesMap.put("018", "Söhd-Affrika");
    namesMap.put("019", "Ammärrika");
    namesMap.put("021", "der Norde vun Amärrika");
    namesMap.put("029", "de Karribik");
    namesMap.put("030", "Oß-Aasije");
    namesMap.put("034", "Söhd-Aasije");
    namesMap.put("035", "Söhd-Oß-Aasije");
    namesMap.put("039", "Söhd-Europpa");
    namesMap.put("053", "de Rejjohn öm Austrahlije");
    namesMap.put("054", "Mellanehsije");
    namesMap.put("057", "de Rejohn vun Mikronehseje");
    namesMap.put("061", "Polinehsije");
    namesMap.put("142", "Aasije");
    namesMap.put("143", "Meddelaasije");
    namesMap.put("145", "Wäß-Aasije");
    namesMap.put("150", "Europpa");
    namesMap.put("151", "Oß-Europpa");
    namesMap.put("154", "Nood-Europpa");
    namesMap.put("155", "Wäß-Europpa");
    namesMap.put("419", "Lateinamärrika");
    namesMap.put("AC", "Aßension");
    namesMap.put("AE", "Vereinschte Arrabesche Emmirate");
    namesMap.put("AF", "Afjaanistahn");
    namesMap.put("AG", "Antigwa un Barbuda");
    namesMap.put("AI", "Anggwilla");
    namesMap.put("AL", "Albaanije");
    namesMap.put("AM", "Arrmeenije");
    namesMap.put("AO", "Angjoola");
    namesMap.put("AQ", "der Södpol");
    namesMap.put("AR", "Ajjentiinije");
    namesMap.put("AS", "Ammerikaanesch Sammoha");
    namesMap.put("AT", "Öösterisch");
    namesMap.put("AU", "Austraalije");
    namesMap.put("AX", "de Ohland-Enselle");
    namesMap.put("AZ", "Asserbaidschahn");
    namesMap.put("BA", "Boßnije un Herzegovina");
    namesMap.put("BB", "de Ensel Barbados");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Bellje");
    namesMap.put("BF", "Bukkinna-Faase");
    namesMap.put("BG", "Bulljaarije");
    namesMap.put("BH", "Bachrain");
    namesMap.put("BJ", "dä Benin");
    namesMap.put("BL", "de Zint Battälmi-Enselle");
    namesMap.put("BM", "de Bermudas");
    namesMap.put("BO", "Bolliivije");
    namesMap.put("BQ", "de karribbesche Nederläng");
    namesMap.put("BR", "Brasilije");
    namesMap.put("BS", "de Bahamas");
    namesMap.put("BT", "Buttaan");
    namesMap.put("BV", "de Buvee-Ensel");
    namesMap.put("BW", "Bozwaana");
    namesMap.put("BY", "Wießrußland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "de Kokkos-Enselle");
    namesMap.put("CD", "dä Konggo (Kinschasa)");
    namesMap.put("CF", "de Zäntraalaffrikaanesche Republik");
    namesMap.put("CG", "dä Konggo (Brassavill)");
    namesMap.put("CH", "de Schweiz");
    namesMap.put("CI", "Älfebeijn-Köß");
    namesMap.put("CK", "de Kuuk-Enselle");
    namesMap.put("CL", "Schiile");
    namesMap.put("CM", "Kammeruhn");
    namesMap.put("CN", "Schiina");
    namesMap.put("CO", "Kolumbije");
    namesMap.put("CP", "de Klipperton-Ensel");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuhba");
    namesMap.put("CV", "de kapvärdesche Enselle");
    namesMap.put("CX", "de Weihnaachs-Ensel");
    namesMap.put("CY", "Züppere");
    namesMap.put("CZ", "de Tschäschei");
    namesMap.put("DE", "Doütschland");
    namesMap.put("DG", "de Diego-Garcia-Ensel");
    namesMap.put("DJ", "Dschibutti");
    namesMap.put("DK", "Dänemark");
    namesMap.put("DM", "Dominnika");
    namesMap.put("DO", "de Dommenekaanesche Reppublik");
    namesMap.put("DZ", "Alljeerije");
    namesMap.put("EA", "Ze’uta un Meliija");
    namesMap.put("EC", "Äkwador");
    namesMap.put("EE", "Äßland");
    namesMap.put("EG", "Äjüpte");
    namesMap.put("EH", "Wäß-Sahara");
    namesMap.put("ER", "Äritreja");
    namesMap.put("ES", "Schpaanije");
    namesMap.put("ET", "Ättijoopije");
    namesMap.put("EU", "de Europähjesche Unijon");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "de Fidschi-Endelle");
    namesMap.put("FK", "de Falkland-Enselle");
    namesMap.put("FM", "Mikroneesije");
    namesMap.put("FO", "de Färrör-Enselle");
    namesMap.put("FR", "Frankrisch");
    namesMap.put("GA", "Jabuhn");
    namesMap.put("GB", "Jruußbrettannije");
    namesMap.put("GD", "Jrenahda");
    namesMap.put("GE", "Jeorrjije");
    namesMap.put("GF", "Franzüüsesch Jujaana");
    namesMap.put("GG", "Jöönsei");
    namesMap.put("GH", "Jaana");
    namesMap.put("GI", "Jibralltaa");
    namesMap.put("GL", "Jröhnland");
    namesMap.put("GM", "Jambija");
    namesMap.put("GN", "Jinneha");
    namesMap.put("GP", "Juadelupp");
    namesMap.put("GQ", "Äquatorial Jineeja");
    namesMap.put("GR", "Jriescheland");
    namesMap.put("GS", "Söd-Jeorjie un de södlijje Botteramms-Enselle");
    namesMap.put("GT", "Juwatemahla");
    namesMap.put("GU", "Juham");
    namesMap.put("GW", "Jinneha_Bißau");
    namesMap.put("GY", "Jujaana");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "de Heart Ensel un de McDonald-Enselle");
    namesMap.put("HR", "Krowazije");
    namesMap.put("HT", "Ha’itti");
    namesMap.put("HU", "Unjann");
    namesMap.put("IC", "de Kannaresche Enselle");
    namesMap.put("ID", "Indoneesije");
    namesMap.put("IE", "Irrland");
    namesMap.put("IL", "Ißraäl");
    namesMap.put("IM", "de Ensel Män");
    namesMap.put("IN", "Indije");
    namesMap.put("IO", "Brettesche Besezunge em indesche Oozejahn");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Persije");
    namesMap.put("IS", "Ißland");
    namesMap.put("IT", "Itaalije");
    namesMap.put("JE", "Jööseh");
    namesMap.put("JM", "Jammaika");
    namesMap.put("JO", "Jordaanije");
    namesMap.put("KE", "Keenija");
    namesMap.put("KG", "Kirrjiisije");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KM", "de Kommoore");
    namesMap.put("KN", "Zint Kitts un Nevis");
    namesMap.put("KP", "Nood-Koreja");
    namesMap.put("KR", "Söd-Koreja");
    namesMap.put("KW", "Kuweit");
    namesMap.put("KY", "de Kaiman-Enselle");
    namesMap.put("KZ", "Kassakstahn");
    namesMap.put("LA", "La’os");
    namesMap.put("LB", "Lebbannon");
    namesMap.put("LC", "de Ensel Zint-Lutscha");
    namesMap.put("LI", "Lischteschtein");
    namesMap.put("LR", "Libeerija");
    namesMap.put("LS", "Lesooto");
    namesMap.put("LT", "Littaue");
    namesMap.put("LU", "Luxembursch");
    namesMap.put("LV", "Lätland");
    namesMap.put("LY", "Libbije");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monakko");
    namesMap.put("MD", "Moldaavije");
    namesMap.put("ME", "et Monteneejro");
    namesMap.put("MF", "de Zint-Määtes-Ensel");
    namesMap.put("MG", "Maddajaska");
    namesMap.put("MH", "de Machschall-Enselle");
    namesMap.put("MK", "Mazedoonije");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Birma");
    namesMap.put("MN", "Mongjolei");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "de nöödlijje Marijanne-Enselle");
    namesMap.put("MQ", "Machtinik");
    namesMap.put("MR", "Mautitaanije");
    namesMap.put("MS", "Mongßerrat");
    namesMap.put("MU", "Maurizijus");
    namesMap.put("MV", "Mallediive");
    namesMap.put("MX", "Mäxiko");
    namesMap.put("MY", "Malaisije");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namiibije");
    namesMap.put("NC", "Neuschottland");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "de Noofok-Ensel");
    namesMap.put("NG", "Nikaraagua");
    namesMap.put("NI", "Nikarahguwa");
    namesMap.put("NL", "de Nederläng");
    namesMap.put("NO", "Norrweeje");
    namesMap.put("NP", "Nepall");
    namesMap.put("NZ", "Neuseeland");
    namesMap.put("PA", "Pannama");
    namesMap.put("PE", "Perruh");
    namesMap.put("PF", "Franzüüsesch Pollineesije");
    namesMap.put("PG", "Papuwa Neujineeja");
    namesMap.put("PH", "Fillipiine");
    namesMap.put("PK", "Pakistahn");
    namesMap.put("PL", "Pole");
    namesMap.put("PM", "Zint Pjäär un Mikelong");
    namesMap.put("PN", "de Pitkärn-Ensel");
    namesMap.put("PR", "Pochtoriko");
    namesMap.put("PS", "Palästina");
    namesMap.put("PT", "Pochtojall");
    namesMap.put("PW", "Pallau");
    namesMap.put("PY", "Parraguwai");
    namesMap.put("QA", "Kataa");
    namesMap.put("QO", "Ozejahnije ußerhallef");
    namesMap.put("RE", "Rehunjohn");
    namesMap.put("RO", "Romäänije");
    namesMap.put("RS", "Särbije");
    namesMap.put("RU", "Rußland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi Arraabije");
    namesMap.put("SB", "de Solomone-Enselle");
    namesMap.put("SC", "de Seischälle");
    namesMap.put("SD", "Noodsudahn");
    namesMap.put("SE", "Schweede");
    namesMap.put("SG", "Singjapuur");
    namesMap.put("SH", "de Ensel Zint Hellena");
    namesMap.put("SI", "ẞloveenije");
    namesMap.put("SJ", "de Enselle Svalbard un Jan Mayen");
    namesMap.put("SK", "ẞlovakei");
    namesMap.put("SL", "Sjärra Lejone");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SN", "der Sennejall");
    namesMap.put("SO", "Somaalije");
    namesMap.put("SR", "Sürinamm");
    namesMap.put("SS", "Södsudahn");
    namesMap.put("ST", "Zint Tommeh un Printschipe");
    namesMap.put("SV", "Äl Slavadohr");
    namesMap.put("SX", "Zint Maarten");
    namesMap.put("SY", "Sürije");
    namesMap.put("SZ", "ẞwaasiland");
    namesMap.put("TA", "Tristan da Cunja");
    namesMap.put("TC", "de Enselle Turks un Kaikos");
    namesMap.put("TD", "der Tschadd");
    namesMap.put("TF", "Franzüüsesche Södsee-Enselle");
    namesMap.put("TG", "Toojo");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tadschikistahn");
    namesMap.put("TL", "Oß-Timor");
    namesMap.put("TM", "Turkmenistahn");
    namesMap.put("TN", "Tuneesije");
    namesMap.put("TO", "Tongga");
    namesMap.put("TR", "de Törkei");
    namesMap.put("TT", "Trinidad un Tobähjo");
    namesMap.put("TZ", "Tansanija");
    namesMap.put("UA", "de Ukra’iine");
    namesMap.put("UG", "Ujanda");
    namesMap.put("UM", "de Vereineschte Schtaate vun Amärrika ier ußerhallef jelääje Enselsche");
    namesMap.put("US", "de vereineschte Schtaate vun Ammärrika");
    namesMap.put("UY", "Urrujwai");
    namesMap.put("UZ", "Ußbeekistahn");
    namesMap.put("VA", "der Vattikahn");
    namesMap.put("VC", "Zint Vinzänz un de Jrenadines-Enselle");
    namesMap.put("VG", "de brettesche Juffer-Enselle");
    namesMap.put("VI", "de ammärrikahnesche Juffer-Enselle");
    namesMap.put("VN", "Vijätnamm");
    namesMap.put("WF", "Wallis un Futuna");
    namesMap.put("WS", "Sammoha");
    namesMap.put("YE", "Jämme");
    namesMap.put("YT", "Majott");
    namesMap.put("ZA", "de Republik Södaffrika");
    namesMap.put("ZM", "Sambija");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "- Jähjend onbikannt -");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "de Ääd",
        "002": "Affrika",
        "003": "Nood-Amärrika",
        "005": "Söhd-Amärrika",
        "009": "Ozejahneje",
        "011": "Wäß-Affrika",
        "013": "Meddelammärrika",
        "014": "Oß-Affrika",
        "015": "Nood-Affrika",
        "017": "Meddel-Affrika",
        "018": "Söhd-Affrika",
        "019": "Ammärrika",
        "021": "der Norde vun Amärrika",
        "029": "de Karribik",
        "030": "Oß-Aasije",
        "034": "Söhd-Aasije",
        "035": "Söhd-Oß-Aasije",
        "039": "Söhd-Europpa",
        "053": "de Rejjohn öm Austrahlije",
        "054": "Mellanehsije",
        "057": "de Rejohn vun Mikronehseje",
        "061": "Polinehsije",
        "142": "Aasije",
        "143": "Meddelaasije",
        "145": "Wäß-Aasije",
        "150": "Europpa",
        "151": "Oß-Europpa",
        "154": "Nood-Europpa",
        "155": "Wäß-Europpa",
        "419": "Lateinamärrika",
        "AC": "Aßension",
        "AE": "Vereinschte Arrabesche Emmirate",
        "AF": "Afjaanistahn",
        "AG": "Antigwa un Barbuda",
        "AI": "Anggwilla",
        "AL": "Albaanije",
        "AM": "Arrmeenije",
        "AO": "Angjoola",
        "AQ": "der Södpol",
        "AR": "Ajjentiinije",
        "AS": "Ammerikaanesch Sammoha",
        "AT": "Öösterisch",
        "AU": "Austraalije",
        "AX": "de Ohland-Enselle",
        "AZ": "Asserbaidschahn",
        "BA": "Boßnije un Herzegovina",
        "BB": "de Ensel Barbados",
        "BD": "Bangladesch",
        "BE": "Bellje",
        "BF": "Bukkinna-Faase",
        "BG": "Bulljaarije",
        "BH": "Bachrain",
        "BJ": "dä Benin",
        "BL": "de Zint Battälmi-Enselle",
        "BM": "de Bermudas",
        "BO": "Bolliivije",
        "BQ": "de karribbesche Nederläng",
        "BR": "Brasilije",
        "BS": "de Bahamas",
        "BT": "Buttaan",
        "BV": "de Buvee-Ensel",
        "BW": "Bozwaana",
        "BY": "Wießrußland",
        "CA": "Kanada",
        "CC": "de Kokkos-Enselle",
        "CD": "dä Konggo (Kinschasa)",
        "CF": "de Zäntraalaffrikaanesche Republik",
        "CG": "dä Konggo (Brassavill)",
        "CH": "de Schweiz",
        "CI": "Älfebeijn-Köß",
        "CK": "de Kuuk-Enselle",
        "CL": "Schiile",
        "CM": "Kammeruhn",
        "CN": "Schiina",
        "CO": "Kolumbije",
        "CP": "de Klipperton-Ensel",
        "CR": "Kostarika",
        "CU": "Kuhba",
        "CV": "de kapvärdesche Enselle",
        "CX": "de Weihnaachs-Ensel",
        "CY": "Züppere",
        "CZ": "de Tschäschei",
        "DE": "Doütschland",
        "DG": "de Diego-Garcia-Ensel",
        "DJ": "Dschibutti",
        "DK": "Dänemark",
        "DM": "Dominnika",
        "DO": "de Dommenekaanesche Reppublik",
        "DZ": "Alljeerije",
        "EA": "Ze’uta un Meliija",
        "EC": "Äkwador",
        "EE": "Äßland",
        "EG": "Äjüpte",
        "EH": "Wäß-Sahara",
        "ER": "Äritreja",
        "ES": "Schpaanije",
        "ET": "Ättijoopije",
        "EU": "de Europähjesche Unijon",
        "FI": "Finnland",
        "FJ": "de Fidschi-Endelle",
        "FK": "de Falkland-Enselle",
        "FM": "Mikroneesije",
        "FO": "de Färrör-Enselle",
        "FR": "Frankrisch",
        "GA": "Jabuhn",
        "GB": "Jruußbrettannije",
        "GD": "Jrenahda",
        "GE": "Jeorrjije",
        "GF": "Franzüüsesch Jujaana",
        "GG": "Jöönsei",
        "GH": "Jaana",
        "GI": "Jibralltaa",
        "GL": "Jröhnland",
        "GM": "Jambija",
        "GN": "Jinneha",
        "GP": "Juadelupp",
        "GQ": "Äquatorial Jineeja",
        "GR": "Jriescheland",
        "GS": "Söd-Jeorjie un de södlijje Botteramms-Enselle",
        "GT": "Juwatemahla",
        "GU": "Juham",
        "GW": "Jinneha_Bißau",
        "GY": "Jujaana",
        "HK": "Hongkong",
        "HM": "de Heart Ensel un de McDonald-Enselle",
        "HR": "Krowazije",
        "HT": "Ha’itti",
        "HU": "Unjann",
        "IC": "de Kannaresche Enselle",
        "ID": "Indoneesije",
        "IE": "Irrland",
        "IL": "Ißraäl",
        "IM": "de Ensel Män",
        "IN": "Indije",
        "IO": "Brettesche Besezunge em indesche Oozejahn",
        "IQ": "Irak",
        "IR": "Persije",
        "IS": "Ißland",
        "IT": "Itaalije",
        "JE": "Jööseh",
        "JM": "Jammaika",
        "JO": "Jordaanije",
        "KE": "Keenija",
        "KG": "Kirrjiisije",
        "KH": "Kambodscha",
        "KM": "de Kommoore",
        "KN": "Zint Kitts un Nevis",
        "KP": "Nood-Koreja",
        "KR": "Söd-Koreja",
        "KW": "Kuweit",
        "KY": "de Kaiman-Enselle",
        "KZ": "Kassakstahn",
        "LA": "La’os",
        "LB": "Lebbannon",
        "LC": "de Ensel Zint-Lutscha",
        "LI": "Lischteschtein",
        "LR": "Libeerija",
        "LS": "Lesooto",
        "LT": "Littaue",
        "LU": "Luxembursch",
        "LV": "Lätland",
        "LY": "Libbije",
        "MA": "Marokko",
        "MC": "Monakko",
        "MD": "Moldaavije",
        "ME": "et Monteneejro",
        "MF": "de Zint-Määtes-Ensel",
        "MG": "Maddajaska",
        "MH": "de Machschall-Enselle",
        "MK": "Mazedoonije",
        "ML": "Maali",
        "MM": "Birma",
        "MN": "Mongjolei",
        "MO": "Makau",
        "MP": "de nöödlijje Marijanne-Enselle",
        "MQ": "Machtinik",
        "MR": "Mautitaanije",
        "MS": "Mongßerrat",
        "MU": "Maurizijus",
        "MV": "Mallediive",
        "MX": "Mäxiko",
        "MY": "Malaisije",
        "MZ": "Mosambik",
        "NA": "Namiibije",
        "NC": "Neuschottland",
        "NE": "Nijer",
        "NF": "de Noofok-Ensel",
        "NG": "Nikaraagua",
        "NI": "Nikarahguwa",
        "NL": "de Nederläng",
        "NO": "Norrweeje",
        "NP": "Nepall",
        "NZ": "Neuseeland",
        "PA": "Pannama",
        "PE": "Perruh",
        "PF": "Franzüüsesch Pollineesije",
        "PG": "Papuwa Neujineeja",
        "PH": "Fillipiine",
        "PK": "Pakistahn",
        "PL": "Pole",
        "PM": "Zint Pjäär un Mikelong",
        "PN": "de Pitkärn-Ensel",
        "PR": "Pochtoriko",
        "PS": "Palästina",
        "PT": "Pochtojall",
        "PW": "Pallau",
        "PY": "Parraguwai",
        "QA": "Kataa",
        "QO": "Ozejahnije ußerhallef",
        "RE": "Rehunjohn",
        "RO": "Romäänije",
        "RS": "Särbije",
        "RU": "Rußland",
        "RW": "Ruanda",
        "SA": "Saudi Arraabije",
        "SB": "de Solomone-Enselle",
        "SC": "de Seischälle",
        "SD": "Noodsudahn",
        "SE": "Schweede",
        "SG": "Singjapuur",
        "SH": "de Ensel Zint Hellena",
        "SI": "ẞloveenije",
        "SJ": "de Enselle Svalbard un Jan Mayen",
        "SK": "ẞlovakei",
        "SL": "Sjärra Lejone",
        "SM": "San-Marino",
        "SN": "der Sennejall",
        "SO": "Somaalije",
        "SR": "Sürinamm",
        "SS": "Södsudahn",
        "ST": "Zint Tommeh un Printschipe",
        "SV": "Äl Slavadohr",
        "SX": "Zint Maarten",
        "SY": "Sürije",
        "SZ": "ẞwaasiland",
        "TA": "Tristan da Cunja",
        "TC": "de Enselle Turks un Kaikos",
        "TD": "der Tschadd",
        "TF": "Franzüüsesche Södsee-Enselle",
        "TG": "Toojo",
        "TH": "Tailand",
        "TJ": "Tadschikistahn",
        "TL": "Oß-Timor",
        "TM": "Turkmenistahn",
        "TN": "Tuneesije",
        "TO": "Tongga",
        "TR": "de Törkei",
        "TT": "Trinidad un Tobähjo",
        "TZ": "Tansanija",
        "UA": "de Ukra’iine",
        "UG": "Ujanda",
        "UM": "de Vereineschte Schtaate vun Amärrika ier ußerhallef jelääje Enselsche",
        "US": "de vereineschte Schtaate vun Ammärrika",
        "UY": "Urrujwai",
        "UZ": "Ußbeekistahn",
        "VA": "der Vattikahn",
        "VC": "Zint Vinzänz un de Jrenadines-Enselle",
        "VG": "de brettesche Juffer-Enselle",
        "VI": "de ammärrikahnesche Juffer-Enselle",
        "VN": "Vijätnamm",
        "WF": "Wallis un Futuna",
        "WS": "Sammoha",
        "YE": "Jämme",
        "YT": "Majott",
        "ZA": "de Republik Södaffrika",
        "ZM": "Sambija",
        "ZW": "Simbabwe",
        "ZZ": "- Jähjend onbikannt -"
    };
  }-*/;
}
