/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "ru" locale.
 */
public class LocalizedNamesImpl_ru extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "RU",
        "UA",
        "KZ",
        "UZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "BS",
        "BD",
        "BB",
        "BH",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "GB",
        "HU",
        "VE",
        "VI",
        "UM",
        "QO",
        "TL",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "DK",
        "CD",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EU",
        "EG",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "IN",
        "ID",
        "JO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "CY",
        "KG",
        "KI",
        "CN",
        "CC",
        "CO",
        "KM",
        "CG",
        "CR",
        "CI",
        "CU",
        "KW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "AN",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NO",
        "AE",
        "OM",
        "CV",
        "CK",
        "TC",
        "HM",
        "BV",
        "AC",
        "CP",
        "IM",
        "NF",
        "CX",
        "BL",
        "MF",
        "SH",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "KR",
        "RE",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "KP",
        "MP",
        "SC",
        "SN",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "CS",
        "EA",
        "SG",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "US",
        "SL",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "WF",
        "UY",
        "FO",
        "FM",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "FX",
        "PF",
        "TF",
        "HR",
        "CF",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "ZA",
        "GS",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Мир");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северная Америка");
    namesMap.put("005", "Южная Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Западная Африка");
    namesMap.put("013", "Центральная Америка");
    namesMap.put("014", "Восточная Африка");
    namesMap.put("015", "Северная Африка");
    namesMap.put("017", "Центральная Африка");
    namesMap.put("018", "Южная Африка");
    namesMap.put("019", "Центральная и Южная Америка");
    namesMap.put("021", "Северная Америка - США и Канада");
    namesMap.put("029", "Карибы");
    namesMap.put("030", "Восточная Азия");
    namesMap.put("034", "Южная Азия");
    namesMap.put("035", "Юго-Восточная Азия");
    namesMap.put("039", "Южная Европа");
    namesMap.put("053", "Австралия и Новая Зеландия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Средняя Азия");
    namesMap.put("145", "Ближний и Средний Восток");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Восточная Европа");
    namesMap.put("154", "Северная Европа");
    namesMap.put("155", "Западная Европа");
    namesMap.put("419", "Латинская Америка");
    namesMap.put("AC", "Остров Вознесения");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "ОАЭ");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа и Барбуда");
    namesMap.put("AI", "Ангилья");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AN", "Нидерландские Антильские о-ва");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктида");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американское Самоа");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландские о-ва");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Босния и Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгия");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Остров Святого Бартоломея");
    namesMap.put("BM", "Бермудские о-ва");
    namesMap.put("BN", "Бруней Даруссалам");
    namesMap.put("BO", "Боливия");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багамские о-ва");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Остров Буве");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосовые о-ва");
    namesMap.put("CD", "Демократическая Республика Конго");
    namesMap.put("CF", "ЦАР");
    namesMap.put("CG", "Конго");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот д’Ивуар");
    namesMap.put("CK", "Острова Кука");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "Остров Клиппертон");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CS", "Сербия и Черногория");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Острова Зеленого Мыса");
    namesMap.put("CX", "Остров Рождества");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехия");
    namesMap.put("DE", "Германия");
    namesMap.put("DG", "Диего-Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканская Республика");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелилья");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Западная Сахара");
    namesMap.put("ER", "Эритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("EU", "Европейский союз");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолклендские о-ва");
    namesMap.put("FM", "Федеративные Штаты Микронезии");
    namesMap.put("FO", "Фарерские о-ва");
    namesMap.put("FR", "Франция");
    namesMap.put("FX", "Французская метрополия");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Великобритания");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Французская Гвиана");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Экваториальная Гвинея");
    namesMap.put("GR", "Греция");
    namesMap.put("GS", "Южная Джорджия и Южные Сандвичевы Острова");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "Гонконг");
    namesMap.put("HM", "Острова Херд и Макдональд");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("IC", "Канарские о-ва");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израиль");
    namesMap.put("IM", "Остров Мэн");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британская территория в Индийском океане");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джерси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Иордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Киргизия");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморские о-ва");
    namesMap.put("KN", "Сент-Киттс и Невис");
    namesMap.put("KP", "Северная Корея");
    namesMap.put("KR", "Республика Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Каймановы острова");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент-Люсия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Ливия");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черногория");
    namesMap.put("MF", "Остров Святого Мартина");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалловы о-ва");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мьянма");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Северные Марианские о-ва");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Мальдивские о-ва");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Новая Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Остров Норфолк");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерланды");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуе");
    namesMap.put("NZ", "Новая Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Французская Полинезия");
    namesMap.put("PG", "Папуа – Новая Гвинея");
    namesMap.put("PH", "Филиппины");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Сен-Пьер и Микелон");
    namesMap.put("PN", "Питкэрн");
    namesMap.put("PR", "Пуэрто-Рико");
    namesMap.put("PS", "Палестинские территории");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Внешняя Океания");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Румыния");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Россия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудовская Аравия");
    namesMap.put("SB", "Соломоновы о-ва");
    namesMap.put("SC", "Сейшельские о-ва");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Остров Святой Елены");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Свальбард и Ян-Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("ST", "Сан-Томе и Принсипи");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SY", "Сирия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан-да-Кунья");
    namesMap.put("TC", "Острова Тёркс и Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французские Южные Территории");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Таиланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Восточный Тимор");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турция");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Внешние малые острова (США)");
    namesMap.put("US", "США");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Винсент и Гренадины");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Британские Виргинские о-ва");
    namesMap.put("VI", "Виргинские о-ва (США)");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис и Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "ЮАР");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Неизвестный или недействительный регион");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Мир",
        "002": "Африка",
        "003": "Северная Америка",
        "005": "Южная Америка",
        "009": "Океания",
        "011": "Западная Африка",
        "013": "Центральная Америка",
        "014": "Восточная Африка",
        "015": "Северная Африка",
        "017": "Центральная Африка",
        "018": "Южная Африка",
        "019": "Центральная и Южная Америка",
        "021": "Северная Америка - США и Канада",
        "029": "Карибы",
        "030": "Восточная Азия",
        "034": "Южная Азия",
        "035": "Юго-Восточная Азия",
        "039": "Южная Европа",
        "053": "Австралия и Новая Зеландия",
        "054": "Меланезия",
        "057": "Микронезия",
        "061": "Полинезия",
        "142": "Азия",
        "143": "Средняя Азия",
        "145": "Ближний и Средний Восток",
        "150": "Европа",
        "151": "Восточная Европа",
        "154": "Северная Европа",
        "155": "Западная Европа",
        "419": "Латинская Америка",
        "AC": "Остров Вознесения",
        "AD": "Андорра",
        "AE": "ОАЭ",
        "AF": "Афганистан",
        "AG": "Антигуа и Барбуда",
        "AI": "Ангилья",
        "AL": "Албания",
        "AM": "Армения",
        "AN": "Нидерландские Антильские о-ва",
        "AO": "Ангола",
        "AQ": "Антарктида",
        "AR": "Аргентина",
        "AS": "Американское Самоа",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Аландские о-ва",
        "AZ": "Азербайджан",
        "BA": "Босния и Герцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Бельгия",
        "BF": "Буркина Фасо",
        "BG": "Болгария",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Остров Святого Бартоломея",
        "BM": "Бермудские о-ва",
        "BN": "Бруней Даруссалам",
        "BO": "Боливия",
        "BR": "Бразилия",
        "BS": "Багамские о-ва",
        "BT": "Бутан",
        "BV": "Остров Буве",
        "BW": "Ботсвана",
        "BY": "Беларусь",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокосовые о-ва",
        "CD": "Демократическая Республика Конго",
        "CF": "ЦАР",
        "CG": "Конго",
        "CH": "Швейцария",
        "CI": "Кот д’Ивуар",
        "CK": "Острова Кука",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Китай",
        "CO": "Колумбия",
        "CP": "Остров Клиппертон",
        "CR": "Коста-Рика",
        "CS": "Сербия и Черногория",
        "CU": "Куба",
        "CV": "Острова Зеленого Мыса",
        "CX": "Остров Рождества",
        "CY": "Кипр",
        "CZ": "Чехия",
        "DE": "Германия",
        "DG": "Диего-Гарсия",
        "DJ": "Джибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминиканская Республика",
        "DZ": "Алжир",
        "EA": "Сеута и Мелилья",
        "EC": "Эквадор",
        "EE": "Эстония",
        "EG": "Египет",
        "EH": "Западная Сахара",
        "ER": "Эритрея",
        "ES": "Испания",
        "ET": "Эфиопия",
        "EU": "Европейский союз",
        "FI": "Финляндия",
        "FJ": "Фиджи",
        "FK": "Фолклендские о-ва",
        "FM": "Федеративные Штаты Микронезии",
        "FO": "Фарерские о-ва",
        "FR": "Франция",
        "FX": "Французская метрополия",
        "GA": "Габон",
        "GB": "Великобритания",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Французская Гвиана",
        "GG": "Гернси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гвинея",
        "GP": "Гваделупа",
        "GQ": "Экваториальная Гвинея",
        "GR": "Греция",
        "GS": "Южная Джорджия и Южные Сандвичевы Острова",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гвинея-Бисау",
        "GY": "Гайана",
        "HK": "Гонконг",
        "HM": "Острова Херд и Макдональд",
        "HN": "Гондурас",
        "HR": "Хорватия",
        "HT": "Гаити",
        "HU": "Венгрия",
        "IC": "Канарские о-ва",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Израиль",
        "IM": "Остров Мэн",
        "IN": "Индия",
        "IO": "Британская территория в Индийском океане",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "Джерси",
        "JM": "Ямайка",
        "JO": "Иордания",
        "JP": "Япония",
        "KE": "Кения",
        "KG": "Киргизия",
        "KH": "Камбоджа",
        "KI": "Кирибати",
        "KM": "Коморские о-ва",
        "KN": "Сент-Киттс и Невис",
        "KP": "Северная Корея",
        "KR": "Республика Корея",
        "KW": "Кувейт",
        "KY": "Каймановы острова",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Сент-Люсия",
        "LI": "Лихтенштейн",
        "LK": "Шри-Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Ливия",
        "MA": "Марокко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Черногория",
        "MF": "Остров Святого Мартина",
        "MG": "Мадагаскар",
        "MH": "Маршалловы о-ва",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мьянма",
        "MN": "Монголия",
        "MO": "Макао",
        "MP": "Северные Марианские о-ва",
        "MQ": "Мартиника",
        "MR": "Мавритания",
        "MS": "Монтсеррат",
        "MT": "Мальта",
        "MU": "Маврикий",
        "MV": "Мальдивские о-ва",
        "MW": "Малави",
        "MX": "Мексика",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Новая Каледония",
        "NE": "Нигер",
        "NF": "Остров Норфолк",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Нидерланды",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуе",
        "NZ": "Новая Зеландия",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Французская Полинезия",
        "PG": "Папуа – Новая Гвинея",
        "PH": "Филиппины",
        "PK": "Пакистан",
        "PL": "Польша",
        "PM": "Сен-Пьер и Микелон",
        "PN": "Питкэрн",
        "PR": "Пуэрто-Рико",
        "PS": "Палестинские территории",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Внешняя Океания",
        "RE": "Реюньон",
        "RO": "Румыния",
        "RS": "Сербия",
        "RU": "Россия",
        "RW": "Руанда",
        "SA": "Саудовская Аравия",
        "SB": "Соломоновы о-ва",
        "SC": "Сейшельские о-ва",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Остров Святой Елены",
        "SI": "Словения",
        "SJ": "Свальбард и Ян-Майен",
        "SK": "Словакия",
        "SL": "Сьерра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринам",
        "ST": "Сан-Томе и Принсипи",
        "SV": "Сальвадор",
        "SY": "Сирия",
        "SZ": "Свазиленд",
        "TA": "Тристан-да-Кунья",
        "TC": "Острова Тёркс и Кайкос",
        "TD": "Чад",
        "TF": "Французские Южные Территории",
        "TG": "Того",
        "TH": "Таиланд",
        "TJ": "Таджикистан",
        "TK": "Токелау",
        "TL": "Восточный Тимор",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турция",
        "TT": "Тринидад и Тобаго",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзания",
        "UA": "Украина",
        "UG": "Уганда",
        "UM": "Внешние малые острова (США)",
        "US": "США",
        "UY": "Уругвай",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сент-Винсент и Гренадины",
        "VE": "Венесуэла",
        "VG": "Британские Виргинские о-ва",
        "VI": "Виргинские о-ва (США)",
        "VN": "Вьетнам",
        "VU": "Вануату",
        "WF": "Уоллис и Футуна",
        "WS": "Самоа",
        "YE": "Йемен",
        "YT": "Майотта",
        "ZA": "ЮАР",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "Неизвестный или недействительный регион"
    };
  }-*/;
}
