/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AttachDetachException;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CellList<T>
extends AbstractHasData<T> {
    private static final int DEFAULT_PAGE_SIZE = 25;
    private static Resources DEFAULT_RESOURCES;
    private static final Template TEMPLATE;
    private final Cell<T> cell;
    private boolean cellIsEditing;
    private final Element childContainer;
    private SafeHtml emptyListMessage = SafeHtmlUtils.fromSafeConstant("");
    private final SimplePanel emptyListWidgetContainer = new SimplePanel();
    private final SimplePanel loadingIndicatorContainer = new SimplePanel();
    private final DeckPanel messagesPanel = new DeckPanel();
    private final Style style;
    private ValueUpdater<T> valueUpdater;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public CellList(Cell<T> cell) {
        this(cell, CellList.getDefaultResources(), null);
    }

    public CellList(Cell<T> cell, Resources resources) {
        this(cell, resources, null);
    }

    public CellList(Cell<T> cell, ProvidesKey<T> keyProvider) {
        this(cell, CellList.getDefaultResources(), keyProvider);
    }

    public CellList(Cell<T> cell, Resources resources, ProvidesKey<T> keyProvider) {
        super(Document.get().createDivElement(), 25, keyProvider);
        this.cell = cell;
        this.style = resources.cellListStyle();
        this.style.ensureInjected();
        String widgetStyle = this.style.cellListWidget();
        if (widgetStyle != null) {
            this.addStyleName(widgetStyle);
        }
        this.childContainer = Document.get().createDivElement();
        DivElement outerDiv = (DivElement)this.getElement().cast();
        outerDiv.appendChild(this.childContainer);
        outerDiv.appendChild(this.messagesPanel.getElement());
        this.adopt(this.messagesPanel);
        this.messagesPanel.add(this.emptyListWidgetContainer);
        this.messagesPanel.add(this.loadingIndicatorContainer);
        CellBasedWidgetImpl.get().sinkEvents(this, cell.getConsumedEvents());
    }

    @Deprecated
    public SafeHtml getEmptyListMessage() {
        return this.emptyListMessage;
    }

    public Widget getEmptyListWidget() {
        return this.emptyListWidgetContainer.getWidget();
    }

    public Widget getLoadingIndicator() {
        return this.loadingIndicatorContainer.getWidget();
    }

    public Element getRowElement(int indexOnPage) {
        this.getPresenter().flush();
        this.checkRowBounds(indexOnPage);
        if (this.childContainer.getChildCount() > indexOnPage) {
            return (Element)this.childContainer.getChild(indexOnPage).cast();
        }
        return null;
    }

    @Deprecated
    public void setEmptyListMessage(SafeHtml html) {
        this.emptyListMessage = html;
        this.setEmptyListWidget(html == null ? null : new HTML(html));
    }

    public void setEmptyListWidget(Widget widget) {
        this.emptyListWidgetContainer.setWidget(widget);
    }

    public void setLoadingIndicator(Widget widget) {
        this.loadingIndicatorContainer.setWidget(widget);
    }

    public void setValueUpdater(ValueUpdater<T> valueUpdater) {
        this.valueUpdater = valueUpdater;
    }

    @Override
    protected boolean dependsOnSelection() {
        return this.cell.dependsOnSelection();
    }

    @Override
    protected void doAttachChildren() {
        try {
            this.doAttach(this.messagesPanel);
        }
        catch (Throwable e) {
            throw new AttachDetachException(Collections.singleton(e));
        }
    }

    @Override
    protected void doDetachChildren() {
        try {
            this.doDetach(this.messagesPanel);
        }
        catch (Throwable e) {
            throw new AttachDetachException(Collections.singleton(e));
        }
    }

    protected void fireEventToCell(Cell.Context context, Event event, Element parent, T value) {
        Set<String> consumedEvents = this.cell.getConsumedEvents();
        if (consumedEvents != null && consumedEvents.contains(event.getType())) {
            boolean cellWasEditing = this.cell.isEditing(context, parent, value);
            this.cell.onBrowserEvent(context, parent, value, event, this.valueUpdater);
            this.cellIsEditing = this.cell.isEditing(context, parent, value);
            if (cellWasEditing && !this.cellIsEditing) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    @Override
                    public void execute() {
                        CellList.this.setFocus(true);
                    }
                });
            }
        }
    }

    protected Cell<T> getCell() {
        return this.cell;
    }

    protected Element getCellParent(Element item) {
        return item;
    }

    @Override
    protected Element getChildContainer() {
        return this.childContainer;
    }

    @Override
    protected Element getKeyboardSelectedElement() {
        int rowIndex = this.getKeyboardSelectedRow();
        if (rowIndex >= 0 && this.childContainer.getChildCount() > rowIndex) {
            return (Element)this.childContainer.getChild(rowIndex).cast();
        }
        return null;
    }

    @Override
    protected boolean isKeyboardNavigationSuppressed() {
        return this.cellIsEditing;
    }

    @Override
    protected void onBrowserEvent2(Event event) {
        Element cellTarget;
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return;
        }
        Element target = (Element)event.getEventTarget().cast();
        String idxString = "";
        for (cellTarget = target; cellTarget != null && (idxString = cellTarget.getAttribute("__idx")).length() == 0; cellTarget = cellTarget.getParentElement()) {
        }
        if (idxString.length() > 0) {
            String eventType = event.getType();
            boolean isClick = "click".equals(eventType);
            int idx = Integer.parseInt(idxString);
            int indexOnPage = idx - this.getPageStart();
            if (!this.isRowWithinBounds(indexOnPage)) {
                return;
            }
            boolean isSelectionHandled = this.cell.handlesSelection() || HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.getKeyboardSelectionPolicy();
            Element cellParent = this.getCellParent(cellTarget);
            Object value = this.getVisibleItem(indexOnPage);
            Cell.Context context = new Cell.Context(idx, 0, this.getValueKey(value));
            CellPreviewEvent previewEvent = CellPreviewEvent.fire(this, event, this, context, value, this.cellIsEditing, isSelectionHandled);
            if (!previewEvent.isCanceled()) {
                this.fireEventToCell(context, event, cellParent, value);
            }
        }
    }

    @Override
    protected void onLoadingStateChanged(LoadingStateChangeEvent.LoadingState state) {
        SimplePanel message = null;
        if (state == LoadingStateChangeEvent.LoadingState.LOADING) {
            message = this.loadingIndicatorContainer;
        } else if (state == LoadingStateChangeEvent.LoadingState.LOADED && this.getPresenter().isEmpty()) {
            message = this.emptyListWidgetContainer;
        }
        if (message != null) {
            this.messagesPanel.showWidget(this.messagesPanel.getWidgetIndex(message));
        }
        this.showOrHide(this.getChildContainer(), message == null);
        this.messagesPanel.setVisible(message != null);
        super.onLoadingStateChanged(state);
    }

    @Override
    protected void renderRowValues(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
        String keyboardSelectedItem = " " + this.style.cellListKeyboardSelectedItem();
        String selectedItem = " " + this.style.cellListSelectedItem();
        String evenItem = this.style.cellListEvenItem();
        String oddItem = this.style.cellListOddItem();
        int keyboardSelectedRow = this.getKeyboardSelectedRow() + this.getPageStart();
        int length = values.size();
        int end = start + length;
        for (int i = start; i < end; ++i) {
            T value = values.get(i - start);
            boolean isSelected = selectionModel == null ? false : selectionModel.isSelected(value);
            StringBuilder classesBuilder = new StringBuilder();
            classesBuilder.append(i % 2 == 0 ? evenItem : oddItem);
            if (isSelected) {
                classesBuilder.append(selectedItem);
            }
            if (i == keyboardSelectedRow) {
                classesBuilder.append(keyboardSelectedItem);
            }
            SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
            Cell.Context context = new Cell.Context(i, 0, this.getValueKey(value));
            this.cell.render(context, value, cellBuilder);
            sb.append(TEMPLATE.div(i, classesBuilder.toString(), cellBuilder.toSafeHtml()));
        }
    }

    @Override
    protected boolean resetFocusOnCell() {
        int row = this.getKeyboardSelectedRow();
        if (this.isRowWithinBounds(row)) {
            Element rowElem = this.getKeyboardSelectedElement();
            Element cellParent = this.getCellParent(rowElem);
            Object value = this.getVisibleItem(row);
            Cell.Context context = new Cell.Context(row + this.getPageStart(), 0, this.getValueKey(value));
            return this.cell.resetFocus(context, cellParent, value);
        }
        return false;
    }

    @Override
    protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
        if (!this.isRowWithinBounds(index)) {
            return;
        }
        Element elem = this.getRowElement(index);
        if (!selected || this.isFocused || stealFocus) {
            CellList.setStyleName(elem, this.style.cellListKeyboardSelectedItem(), selected);
        }
        this.setFocusable(elem, selected);
        if (selected && stealFocus && !this.cellIsEditing) {
            elem.focus();
            this.onFocus();
        }
    }

    @Override
    @Deprecated
    protected void setSelected(Element elem, boolean selected) {
        CellList.setStyleName(elem, this.style.cellListSelectedItem(), selected);
    }

    static {
        TEMPLATE = (Template)GWT.create(Template.class);
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div __idx=\"{0}\" class=\"{1}\" style=\"outline:none;\" >{2}</div>")
        public SafeHtml div(int var1, String var2, SafeHtml var3);
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellList")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellList.css";

        public String cellListEvenItem();

        public String cellListKeyboardSelectedItem();

        public String cellListOddItem();

        public String cellListSelectedItem();

        public String cellListWidget();
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellListSelectedBackground();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellList.css"})
        public Style cellListStyle();
    }
}

