/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.shared.impl;

import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanCodex;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import com.google.gwt.autobean.shared.AutoBeanVisitor;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.ValueCodex;
import com.google.gwt.autobean.shared.impl.EnumMap;
import com.google.gwt.autobean.shared.impl.LazySplittable;
import com.google.gwt.autobean.shared.impl.StringQuoter;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.requestfactory.shared.BaseProxy;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyChange;
import com.google.gwt.requestfactory.shared.EntityProxyId;
import com.google.gwt.requestfactory.shared.Receiver;
import com.google.gwt.requestfactory.shared.RequestContext;
import com.google.gwt.requestfactory.shared.RequestTransport;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.requestfactory.shared.ValueProxy;
import com.google.gwt.requestfactory.shared.Violation;
import com.google.gwt.requestfactory.shared.WriteOperation;
import com.google.gwt.requestfactory.shared.impl.AbstractRequest;
import com.google.gwt.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.gwt.requestfactory.shared.impl.BaseProxyCategory;
import com.google.gwt.requestfactory.shared.impl.EntityCodex;
import com.google.gwt.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.gwt.requestfactory.shared.impl.RequestData;
import com.google.gwt.requestfactory.shared.impl.SimpleProxyId;
import com.google.gwt.requestfactory.shared.impl.posers.DatePoser;
import com.google.gwt.requestfactory.shared.messages.IdMessage;
import com.google.gwt.requestfactory.shared.messages.InvocationMessage;
import com.google.gwt.requestfactory.shared.messages.JsonRpcRequest;
import com.google.gwt.requestfactory.shared.messages.MessageFactory;
import com.google.gwt.requestfactory.shared.messages.OperationMessage;
import com.google.gwt.requestfactory.shared.messages.RequestMessage;
import com.google.gwt.requestfactory.shared.messages.ResponseMessage;
import com.google.gwt.requestfactory.shared.messages.ServerFailureMessage;
import com.google.gwt.requestfactory.shared.messages.ViolationMessage;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractRequestContext
implements RequestContext,
EntityCodex.EntitySource {
    private static final WriteOperation[] DELETE_ONLY = new WriteOperation[]{WriteOperation.DELETE};
    private static final WriteOperation[] PERSIST_AND_UPDATE = new WriteOperation[]{WriteOperation.PERSIST, WriteOperation.UPDATE};
    private static final WriteOperation[] UPDATE_ONLY = new WriteOperation[]{WriteOperation.UPDATE};
    private static int payloadId = 100;
    protected final List<AbstractRequest<?>> invocations = new ArrayList();
    private boolean locked;
    private final AbstractRequestFactory requestFactory;
    private final Map<SimpleProxyId<?>, AutoBean<? extends BaseProxy>> editedProxies = new LinkedHashMap();
    private final Map<SimpleProxyId<?>, AutoBean<?>> returnedProxies = new HashMap();
    private final Map<Integer, SimpleProxyId<?>> syntheticIds = new HashMap();
    private final DialectImpl dialect;

    protected AbstractRequestContext(AbstractRequestFactory factory, Dialect dialect) {
        this.requestFactory = factory;
        this.dialect = dialect.create(this);
    }

    @Override
    public <T extends BaseProxy> T create(Class<T> clazz) {
        this.checkLocked();
        SimpleProxyId<T> id = this.requestFactory.allocateId(clazz);
        AutoBean<T> created = this.createProxy(clazz, id);
        return this.takeOwnership(created);
    }

    public <T extends BaseProxy> AutoBean<T> createProxy(Class<T> clazz, SimpleProxyId<T> id) {
        AutoBean<T> created = this.getAutoBeanFactory().create(clazz);
        if (created == null) {
            throw new IllegalArgumentException("Unknown proxy type " + clazz.getName());
        }
        created.setTag("stableId", id);
        return created;
    }

    @Override
    public <T extends BaseProxy> T edit(T object) {
        return this.editProxy(object);
    }

    public <T extends BaseProxy> T editProxy(T object) {
        AutoBean<T> bean = this.checkStreamsNotCrossed(object);
        this.checkLocked();
        AutoBean<? extends BaseProxy> previouslySeen = this.editedProxies.get(BaseProxyCategory.stableId(bean));
        if (previouslySeen != null && !previouslySeen.isFrozen()) {
            return (T)previouslySeen.as();
        }
        AutoBean<T> parent = bean;
        bean = this.cloneBeanAndCollections(bean);
        bean.setTag("parentObject", parent);
        return bean.as();
    }

    @Override
    public void fire() {
        boolean needsReceiver = true;
        for (AbstractRequest<?> request : this.invocations) {
            if (!request.hasReceiver()) continue;
            needsReceiver = false;
            break;
        }
        if (needsReceiver) {
            this.doFire(new Receiver<Void>(){

                @Override
                public void onSuccess(Void response) {
                }
            });
        } else {
            this.doFire(null);
        }
    }

    @Override
    public void fire(Receiver<Void> receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException();
        }
        this.doFire(receiver);
    }

    @Override
    public <Q extends BaseProxy> AutoBean<Q> getBeanForPayload(Splittable serializedProxyId) {
        IdMessage ref = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, IdMessage.class, serializedProxyId).as();
        SimpleProxyId<BaseProxy> id = this.getId(ref);
        return this.getProxyForReturnPayloadGraph(id);
    }

    public AbstractRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public Splittable getSerializedProxyId(SimpleProxyId<?> stableId) {
        AutoBean<IdMessage> bean = MessageFactoryHolder.FACTORY.id();
        IdMessage ref = bean.as();
        ref.setServerId(stableId.getServerId());
        ref.setTypeToken(this.getRequestFactory().getTypeToken(stableId.getProxyClass()));
        if (stableId.isSynthetic()) {
            ref.setStrength(IdMessage.Strength.SYNTHETIC);
            ref.setSyntheticId(stableId.getSyntheticId());
        } else if (stableId.isEphemeral()) {
            ref.setStrength(IdMessage.Strength.EPHEMERAL);
            ref.setClientId(stableId.getClientId());
        }
        return AutoBeanCodex.encode(bean);
    }

    @Override
    public boolean isChanged() {
        for (AutoBean<? extends BaseProxy> bean : this.editedProxies.values()) {
            AutoBean<? extends BaseProxy> previous = (AutoBean<? extends BaseProxy>)bean.getTag("parentObject");
            if (previous == null) {
                Class<? extends BaseProxy> proxyClass = BaseProxyCategory.stableId(bean).getProxyClass();
                previous = this.getAutoBeanFactory().create(proxyClass);
            }
            if (AutoBeanUtils.diff(previous, bean).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEntityType(Class<?> clazz) {
        return this.requestFactory.isEntityType(clazz);
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean isValueType(Class<?> clazz) {
        return this.requestFactory.isValueType(clazz);
    }

    protected void addInvocation(AbstractRequest<?> request) {
        this.dialect.addInvocation(request);
    }

    protected void fail(Receiver<Void> receiver, ServerFailure failure) {
        this.reuse();
        HashSet<Throwable> causes = null;
        for (AbstractRequest<?> request : new ArrayList(this.invocations)) {
            try {
                request.onFail(failure);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet();
                }
                causes.add(t);
            }
        }
        if (receiver != null) {
            try {
                receiver.onFailure(failure);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet<Throwable>();
                }
                causes.add(t);
            }
        }
        if (causes != null) {
            throw new UmbrellaException(causes);
        }
    }

    protected abstract AutoBeanFactory getAutoBeanFactory();

    protected void violation(Receiver<Void> receiver, Set<Violation> errors) {
        this.reuse();
        HashSet<Throwable> causes = null;
        for (AbstractRequest<?> request : new ArrayList(this.invocations)) {
            try {
                request.onViolation(errors);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet();
                }
                causes.add(t);
            }
        }
        if (receiver != null) {
            try {
                receiver.onViolation(errors);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet<Throwable>();
                }
                causes.add(t);
            }
        }
        if (causes != null) {
            throw new UmbrellaException(causes);
        }
    }

    SimpleProxyId<BaseProxy> getId(IdMessage op) {
        if (IdMessage.Strength.SYNTHETIC.equals((Object)op.getStrength())) {
            return this.allocateSyntheticId(op.getTypeToken(), op.getSyntheticId());
        }
        return this.requestFactory.getId(op.getTypeToken(), op.getServerId(), op.getClientId());
    }

    <Q extends BaseProxy> AutoBean<Q> getProxyForReturnPayloadGraph(SimpleProxyId<Q> id) {
        AutoBean<Object> bean = this.returnedProxies.get(id);
        if (bean == null) {
            Class<Q> proxyClass = id.getProxyClass();
            bean = this.createProxy(proxyClass, id);
            this.returnedProxies.put(id, bean);
        }
        return bean;
    }

    AutoBean<OperationMessage> makeOperationMessage(SimpleProxyId<BaseProxy> stableId, AutoBean<?> proxyBean, boolean useDelta) {
        AutoBean<BaseProxy> parent;
        AutoBean<OperationMessage> toReturn = MessageFactoryHolder.FACTORY.operation();
        OperationMessage operation = toReturn.as();
        operation.setTypeToken(this.requestFactory.getTypeToken(stableId.getProxyClass()));
        if (stableId.isEphemeral()) {
            parent = this.createProxy(stableId.getProxyClass(), stableId);
            operation.setOperation(WriteOperation.PERSIST);
            operation.setClientId(stableId.getClientId());
            operation.setStrength(IdMessage.Strength.EPHEMERAL);
        } else if (stableId.isSynthetic()) {
            parent = this.createProxy(stableId.getProxyClass(), stableId);
            operation.setOperation(WriteOperation.PERSIST);
            operation.setSyntheticId(stableId.getSyntheticId());
            operation.setStrength(IdMessage.Strength.SYNTHETIC);
        } else {
            parent = (AutoBean<BaseProxy>)proxyBean.getTag("parentObject");
            operation.setServerId(stableId.getServerId());
            operation.setOperation(WriteOperation.UPDATE);
        }
        assert (!useDelta || parent != null);
        String version = (String)proxyBean.getTag("version");
        if (version != null) {
            operation.setVersion(version);
        }
        Map<Object, Object> diff = Collections.emptyMap();
        if (this.isEntityType(stableId.getProxyClass())) {
            diff = useDelta ? AutoBeanUtils.diff(parent, proxyBean) : AutoBeanUtils.getAllProperties(proxyBean);
        } else if (this.isValueType(stableId.getProxyClass())) {
            diff = AutoBeanUtils.getAllProperties(proxyBean);
        }
        if (!diff.isEmpty()) {
            HashMap<String, Splittable> propertyMap = new HashMap<String, Splittable>();
            for (Map.Entry<Object, Object> entry : diff.entrySet()) {
                propertyMap.put((String)entry.getKey(), EntityCodex.encode(this, entry.getValue()));
            }
            operation.setPropertyMap(propertyMap);
        }
        return toReturn;
    }

    <Q extends BaseProxy> Q processReturnOperation(SimpleProxyId<Q> id, OperationMessage op, WriteOperation ... operations) {
        AutoBean<Q> toMutate = this.getProxyForReturnPayloadGraph(id);
        toMutate.setTag("version", op.getVersion());
        final Map<String, Splittable> properties = op.getPropertyMap();
        if (properties != null) {
            toMutate.accept(new AutoBeanVisitor(){

                @Override
                public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                    if (ctx.canSet() && properties.containsKey(propertyName)) {
                        Splittable raw = (Splittable)properties.get(propertyName);
                        Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
                        Object decoded = EntityCodex.decode((EntityCodex.EntitySource)AbstractRequestContext.this, ctx.getType(), elementType, raw);
                        ctx.set(decoded);
                    }
                    return false;
                }

                @Override
                public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                    if (ctx.canSet() && properties.containsKey(propertyName)) {
                        Splittable raw = (Splittable)properties.get(propertyName);
                        Object decoded = ValueCodex.decode(ctx.getType(), raw);
                        if (decoded != null && Date.class.equals(ctx.getType())) {
                            decoded = new DatePoser((Date)decoded);
                        }
                        ctx.set(decoded);
                    }
                    return false;
                }
            });
        }
        this.makeImmutable(toMutate);
        BaseProxy proxy = (BaseProxy)toMutate.as();
        if (operations != null && this.requestFactory.isEntityType(id.getProxyClass())) {
            for (WriteOperation writeOperation : operations) {
                if (writeOperation.equals((Object)WriteOperation.UPDATE) && !this.requestFactory.hasVersionChanged(id, op.getVersion())) continue;
                this.requestFactory.getEventBus().fireEventFromSource((GwtEvent<?>)new EntityProxyChange<EntityProxy>((EntityProxy)proxy, writeOperation), (Object)id.getProxyClass());
            }
        }
        return (Q)proxy;
    }

    private <Q extends BaseProxy> SimpleProxyId<Q> allocateSyntheticId(String typeToken, int syntheticId) {
        SimpleProxyId<Object> toReturn = this.syntheticIds.get(syntheticId);
        if (toReturn == null) {
            toReturn = this.requestFactory.allocateId(this.requestFactory.getTypeFromToken(typeToken));
            this.syntheticIds.put(syntheticId, toReturn);
        }
        return toReturn;
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("A request is already in progress");
        }
    }

    private <T> AutoBean<T> checkStreamsNotCrossed(T object) {
        AutoBean bean = AutoBeanUtils.getAutoBean(object);
        if (bean == null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
        RequestContext context = (RequestContext)bean.getTag("requestContext");
        if (!bean.isFrozen() && context != this) {
            assert (context != null) : "Unfrozen bean with null RequestContext";
            throw new IllegalArgumentException("Attempting to edit an EntityProxy previously edited by another RequestContext");
        }
        return bean;
    }

    private <T extends BaseProxy> AutoBean<T> cloneBeanAndCollections(AutoBean<T> toClone) {
        AutoBean<T> clone = toClone.clone(false);
        this.takeOwnership(clone);
        clone.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitCollectionProperty(String propertyName, AutoBean<Collection<?>> value, AutoBeanVisitor.CollectionPropertyContext ctx) {
                if (value != null) {
                    AbstractCollection collection;
                    if (List.class == ctx.getType()) {
                        collection = new ArrayList();
                    } else if (Set.class == ctx.getType()) {
                        collection = new HashSet();
                    } else {
                        throw new IllegalArgumentException(ctx.getType().getName());
                    }
                    if (AbstractRequestContext.this.isValueType(ctx.getElementType())) {
                        for (Object o : value.as()) {
                            if (o == null) {
                                collection.add(null);
                                continue;
                            }
                            collection.add(AbstractRequestContext.this.editProxy((ValueProxy)o));
                        }
                    } else {
                        collection.addAll(value.as());
                    }
                    ctx.set(collection);
                }
                return false;
            }

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                if (value != null && AbstractRequestContext.this.isValueType(ctx.getType())) {
                    AutoBean<?> valueBean = value;
                    ctx.set(AbstractRequestContext.this.editProxy((BaseProxy)valueBean.as()));
                }
                return false;
            }
        });
        return clone;
    }

    private void doFire(final Receiver<Void> receiver) {
        this.checkLocked();
        this.locked = true;
        this.freezeEntities(true);
        String payload = this.dialect.makePayload();
        this.requestFactory.getRequestTransport().send(payload, new RequestTransport.TransportReceiver(){

            public void onTransportFailure(ServerFailure failure) {
                AbstractRequestContext.this.fail(receiver, failure);
            }

            public void onTransportSuccess(String payload) {
                AbstractRequestContext.this.dialect.processPayload(receiver, payload);
            }
        });
    }

    private void freezeEntities(boolean frozen) {
        for (AutoBean<? extends BaseProxy> bean : this.editedProxies.values()) {
            bean.setFrozen(frozen);
        }
    }

    private void makeImmutable(AutoBean<? extends BaseProxy> toMutate) {
        toMutate.setTag("parentObject", toMutate);
        toMutate.setTag("requestContext", null);
        toMutate.setFrozen(true);
    }

    private List<InvocationMessage> makePayloadInvocations() {
        MessageFactory f = MessageFactoryHolder.FACTORY;
        ArrayList<InvocationMessage> invocationMessages = new ArrayList<InvocationMessage>();
        for (AbstractRequest<?> invocation : this.invocations) {
            RequestData data = invocation.getRequestData();
            InvocationMessage message = f.invocation().as();
            message.setOperation(data.getOperation());
            Set<String> refsToSend = data.getPropertyRefs();
            if (!refsToSend.isEmpty()) {
                message.setPropertyRefs(refsToSend);
            }
            ArrayList<Splittable> parameters = new ArrayList<Splittable>(data.getOrderedParameters().length);
            for (Object param : data.getOrderedParameters()) {
                parameters.add(EntityCodex.encode(this, param));
            }
            if (!parameters.isEmpty()) {
                message.setParameters(parameters);
            }
            invocationMessages.add(message);
        }
        return invocationMessages;
    }

    private List<OperationMessage> makePayloadOperations() {
        ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
        for (AutoBean<? extends BaseProxy> currentView : this.editedProxies.values()) {
            OperationMessage operation = this.makeOperationMessage(BaseProxyCategory.stableId(currentView), currentView, true).as();
            operations.add(operation);
        }
        return operations;
    }

    private void processReturnOperations(ResponseMessage response) {
        List<OperationMessage> ops = response.getOperations();
        if (ops == null) {
            return;
        }
        for (OperationMessage op : ops) {
            SimpleProxyId<BaseProxy> id = this.getId(op);
            WriteOperation[] toPropagate = null;
            WriteOperation effect = op.getOperation();
            if (effect != null) {
                switch (effect) {
                    case DELETE: {
                        toPropagate = DELETE_ONLY;
                        break;
                    }
                    case PERSIST: {
                        toPropagate = PERSIST_AND_UPDATE;
                        break;
                    }
                    case UPDATE: {
                        toPropagate = UPDATE_ONLY;
                        break;
                    }
                    default: {
                        throw new RuntimeException(effect.toString());
                    }
                }
            }
            this.processReturnOperation(id, op, toPropagate);
        }
    }

    private void retainArg(Object arg) {
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                this.retainArg(o);
            }
        } else if (arg instanceof BaseProxy) {
            this.edit((BaseProxy)arg);
        }
    }

    private void reuse() {
        this.freezeEntities(false);
        this.locked = false;
    }

    private <T extends BaseProxy> T takeOwnership(AutoBean<T> bean) {
        this.editedProxies.put(BaseProxyCategory.stableId(bean), bean);
        bean.setTag("requestContext", this);
        return (T)((BaseProxy)bean.as());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyViolation
    implements Violation {
        private final BaseProxy currentProxy;
        private final EntityProxyId<?> id;
        private final String message;
        private final String path;
        private final BaseProxy parentProxy;

        public MyViolation(ViolationMessage message) {
            SimpleProxyId<BaseProxy> baseId = AbstractRequestContext.this.getId(message);
            this.id = baseId instanceof EntityProxyId ? (EntityProxyId)((Object)baseId) : null;
            AutoBean<BaseProxy> stub = AbstractRequestContext.this.getProxyForReturnPayloadGraph(baseId);
            AutoBean edited = (AutoBean)AbstractRequestContext.this.editedProxies.get(BaseProxyCategory.stableId(stub));
            this.currentProxy = (BaseProxy)edited.as();
            AutoBean parentBean = (AutoBean)edited.getTag("parentObject");
            this.parentProxy = parentBean == null ? null : (BaseProxy)parentBean.as();
            this.path = message.getPath();
            this.message = message.getMessage();
        }

        @Override
        public BaseProxy getInvalidProxy() {
            return this.currentProxy;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public BaseProxy getOriginalProxy() {
            return this.parentProxy;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public EntityProxyId<?> getProxyId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StandardPayloadDialect
    implements DialectImpl {
        StandardPayloadDialect() {
        }

        @Override
        public void addInvocation(AbstractRequest<?> request) {
            AbstractRequestContext.this.invocations.add(request);
            for (Object arg : request.getRequestData().getOrderedParameters()) {
                AbstractRequestContext.this.retainArg(arg);
            }
        }

        @Override
        public String makePayload() {
            MessageFactory f = MessageFactoryHolder.FACTORY;
            List operations = AbstractRequestContext.this.makePayloadOperations();
            List invocationMessages = AbstractRequestContext.this.makePayloadInvocations();
            AutoBean<RequestMessage> bean = f.request();
            RequestMessage requestMessage = bean.as();
            if (!invocationMessages.isEmpty()) {
                requestMessage.setInvocations(invocationMessages);
            }
            if (!operations.isEmpty()) {
                requestMessage.setOperations(operations);
            }
            return AutoBeanCodex.encode(bean).getPayload();
        }

        @Override
        public void processPayload(Receiver<Void> receiver, String payload) {
            ResponseMessage response = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, ResponseMessage.class, payload).as();
            if (response.getGeneralFailure() != null) {
                ServerFailureMessage failure = response.getGeneralFailure();
                ServerFailure fail = new ServerFailure(failure.getMessage(), failure.getExceptionType(), failure.getStackTrace(), failure.isFatal());
                AbstractRequestContext.this.fail(receiver, fail);
                return;
            }
            if (response.getViolations() != null) {
                HashSet<Violation> errors = new HashSet<Violation>();
                for (ViolationMessage message : response.getViolations()) {
                    errors.add(new MyViolation(message));
                }
                AbstractRequestContext.this.violation(receiver, errors);
                return;
            }
            AbstractRequestContext.this.processReturnOperations(response);
            HashSet<Throwable> causes = null;
            int j = AbstractRequestContext.this.invocations.size();
            for (int i = 0; i < j; ++i) {
                try {
                    if (response.getStatusCodes().get(i).booleanValue()) {
                        AbstractRequestContext.this.invocations.get(i).onSuccess(response.getInvocationResults().get(i));
                        continue;
                    }
                    ServerFailureMessage failure = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, ServerFailureMessage.class, response.getInvocationResults().get(i)).as();
                    AbstractRequestContext.this.invocations.get(i).onFail(new ServerFailure(failure.getMessage(), failure.getExceptionType(), failure.getStackTrace(), failure.isFatal()));
                    continue;
                }
                catch (Throwable t) {
                    if (causes == null) {
                        causes = new HashSet<Throwable>();
                    }
                    causes.add(t);
                }
            }
            if (receiver != null) {
                try {
                    receiver.onSuccess(null);
                }
                catch (Throwable t) {
                    if (causes == null) {
                        causes = new HashSet();
                    }
                    causes.add(t);
                }
            }
            AbstractRequestContext.this.editedProxies.clear();
            AbstractRequestContext.this.invocations.clear();
            AbstractRequestContext.this.returnedProxies.clear();
            if (causes != null) {
                throw new UmbrellaException(causes);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JsonRpcPayloadDialect
    implements DialectImpl {
        JsonRpcPayloadDialect() {
        }

        @Override
        public void addInvocation(AbstractRequest<?> request) {
            if (!AbstractRequestContext.this.invocations.isEmpty()) {
                throw new RuntimeException("Only one invocation per request, pending backend support");
            }
            AbstractRequestContext.this.invocations.add(request);
            for (Object arg : request.getRequestData().getOrderedParameters()) {
                AbstractRequestContext.this.retainArg(arg);
            }
        }

        @Override
        public String makePayload() {
            RequestData data = AbstractRequestContext.this.invocations.get(0).getRequestData();
            AutoBean<JsonRpcRequest> bean = MessageFactoryHolder.FACTORY.jsonRpcRequest();
            JsonRpcRequest request = bean.as();
            request.setVersion("2.0");
            request.setApiVersion(data.getApiVersion());
            request.setId(payloadId++);
            HashMap<String, Splittable> params = new HashMap<String, Splittable>();
            for (Map.Entry<String, Object> entry : data.getNamedParameters().entrySet()) {
                Object obj = entry.getValue();
                Splittable value = this.encode(obj);
                params.put(entry.getKey(), value);
            }
            if (data.getRequestResource() != null) {
                params.put("resource", this.encode(data.getRequestResource()));
            }
            request.setParams(params);
            request.setMethod(data.getOperation());
            return AutoBeanCodex.encode(bean).getPayload();
        }

        @Override
        public void processPayload(Receiver<Void> receiver, String payload) {
            Splittable raw = StringQuoter.split(payload);
            Receiver<?> callback = AbstractRequestContext.this.invocations.get(0).getReceiver();
            if (!raw.isNull("error")) {
                Splittable error = raw.get("error");
                ServerFailure failure = new ServerFailure(error.get("message").asString(), error.get("code").asString(), payload, true);
                AbstractRequestContext.this.fail(receiver, failure);
                return;
            }
            Splittable result = raw.get("result");
            Class<?> target = AbstractRequestContext.this.invocations.get(0).getRequestData().getReturnType();
            SimpleProxyId<?> id = AbstractRequestContext.this.getRequestFactory().allocateId(target);
            AutoBean<?> bean = AbstractRequestContext.this.createProxy(target, id);
            AutoBeanCodex.decodeInto(result, bean);
            if (callback != null) {
                callback.onSuccess(bean.as());
            }
            if (receiver != null) {
                receiver.onSuccess(null);
            }
        }

        Splittable encode(Object obj) {
            if (obj == null) {
                return LazySplittable.NULL;
            }
            Splittable value = obj.getClass().isEnum() && AbstractRequestContext.this.getAutoBeanFactory() instanceof EnumMap ? ValueCodex.encode(((EnumMap)((Object)AbstractRequestContext.this.getAutoBeanFactory())).getToken((Enum)obj)) : (ValueCodex.canDecode(obj.getClass()) ? ValueCodex.encode(obj) : AutoBeanCodex.encode(AutoBeanUtils.getAutoBean(obj)));
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    static interface DialectImpl {
        public void addInvocation(AbstractRequest<?> var1);

        public String makePayload();

        public void processPayload(Receiver<Void> var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Dialect {
        STANDARD{

            DialectImpl create(AbstractRequestContext context) {
                return context.new StandardPayloadDialect();
            }
        }
        ,
        JSON_RPC{

            DialectImpl create(AbstractRequestContext context) {
                return context.new JsonRpcPayloadDialect();
            }
        };


        abstract DialectImpl create(AbstractRequestContext var1);
    }
}

