/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasWordWrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBox
extends ButtonBase
implements HasName,
HasValue<Boolean>,
HasWordWrap,
IsEditor<LeafValueEditor<Boolean>> {
    InputElement inputElem;
    LabelElement labelElem;
    private LeafValueEditor<Boolean> editor;
    private boolean valueChangeHandlerInitialized;

    public CheckBox() {
        this(DOM.createInputCheck());
        this.setStyleName("gwt-CheckBox");
    }

    public CheckBox(SafeHtml label) {
        this(label.asString(), true);
    }

    public CheckBox(String label) {
        this();
        this.setText(label);
    }

    public CheckBox(String label, boolean asHTML) {
        this();
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    protected CheckBox(Element elem) {
        super(DOM.createSpan());
        this.inputElem = InputElement.as(elem);
        this.labelElem = Document.get().createLabelElement();
        this.getElement().appendChild(this.inputElem);
        this.getElement().appendChild(this.labelElem);
        String uid = DOM.createUniqueId();
        this.inputElem.setPropertyString("id", uid);
        this.labelElem.setHtmlFor(uid);
        this.setTabIndex(0);
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.ensureDomEventHandlers();
            this.valueChangeHandlerInitialized = true;
        }
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public String getFormValue() {
        return this.inputElem.getValue();
    }

    @Override
    public String getHTML() {
        return this.labelElem.getInnerHTML();
    }

    @Override
    public String getName() {
        return this.inputElem.getName();
    }

    @Override
    public int getTabIndex() {
        return this.inputElem.getTabIndex();
    }

    @Override
    public String getText() {
        return this.labelElem.getInnerText();
    }

    @Override
    public Boolean getValue() {
        if (this.isAttached()) {
            return this.inputElem.isChecked();
        }
        return this.inputElem.isDefaultChecked();
    }

    @Override
    public boolean getWordWrap() {
        return !this.getElement().getStyle().getProperty("whiteSpace").equals("nowrap");
    }

    @Deprecated
    public boolean isChecked() {
        return this.getValue() == true;
    }

    @Override
    public boolean isEnabled() {
        return !this.inputElem.isDisabled();
    }

    @Override
    public void setAccessKey(char key) {
        this.inputElem.setAccessKey("" + key);
    }

    @Deprecated
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.inputElem.setDisabled(!enabled);
        if (enabled) {
            this.removeStyleDependentName("disabled");
        } else {
            this.addStyleDependentName("disabled");
        }
    }

    @Override
    public void setFocus(boolean focused) {
        if (focused) {
            this.inputElem.focus();
        } else {
            this.inputElem.blur();
        }
    }

    public void setFormValue(String value) {
        this.inputElem.setAttribute("value", value);
    }

    @Override
    public void setHTML(String html) {
        this.labelElem.setInnerHTML(html);
    }

    @Override
    public void setName(String name) {
        this.inputElem.setName(name);
    }

    @Override
    public void setTabIndex(int index) {
        if (this.inputElem != null) {
            this.inputElem.setTabIndex(index);
        }
    }

    @Override
    public void setText(String text) {
        this.labelElem.setInnerText(text);
    }

    @Override
    public void setValue(Boolean value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(Boolean value, boolean fireEvents) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        Boolean oldValue = this.getValue();
        this.inputElem.setChecked(value);
        this.inputElem.setDefaultChecked(value);
        if (value.equals(oldValue)) {
            return;
        }
        if (fireEvents) {
            ValueChangeEvent.fire(this, value);
        }
    }

    @Override
    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setProperty("whiteSpace", wrap ? "normal" : "nowrap");
    }

    @Override
    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            Event.sinkEvents(this.inputElem, eventBitsToAdd | Event.getEventsSunk(this.inputElem));
        } else {
            super.sinkEvents(eventBitsToAdd);
        }
    }

    protected void ensureDomEventHandlers() {
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValueChangeEvent.fire(CheckBox.this, CheckBox.this.getValue());
            }
        });
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        CheckBox.ensureDebugId(this.labelElem, baseID, "label");
        CheckBox.ensureDebugId(this.inputElem, baseID, "input");
        this.labelElem.setHtmlFor(this.inputElem.getId());
    }

    @Override
    protected void onLoad() {
        this.setEventListener(this.inputElem, this);
    }

    @Override
    protected void onUnload() {
        this.setEventListener(this.asOld(this.inputElem), null);
        this.setValue(this.getValue());
    }

    protected void replaceInputElement(Element elem) {
        InputElement newInputElem = InputElement.as(elem);
        int tabIndex = this.getTabIndex();
        boolean checked = this.getValue();
        boolean enabled = this.isEnabled();
        String formValue = this.getFormValue();
        String uid = this.inputElem.getId();
        String accessKey = this.inputElem.getAccessKey();
        int sunkEvents = Event.getEventsSunk(this.inputElem);
        this.setEventListener(this.asOld(this.inputElem), null);
        this.getElement().replaceChild(newInputElem, this.inputElem);
        Event.sinkEvents(elem, Event.getEventsSunk(this.inputElem));
        Event.sinkEvents(this.inputElem, 0);
        this.inputElem = newInputElem;
        Event.sinkEvents(this.inputElem, sunkEvents);
        this.inputElem.setId(uid);
        if (!"".equals(accessKey)) {
            this.inputElem.setAccessKey(accessKey);
        }
        this.setTabIndex(tabIndex);
        this.setValue(checked);
        this.setEnabled(enabled);
        this.setFormValue(formValue);
        if (this.isAttached()) {
            this.setEventListener(this.asOld(this.inputElem), this);
        }
    }

    private Element asOld(com.google.gwt.dom.client.Element elem) {
        Element oldSchool = (Element)elem.cast();
        return oldSchool;
    }

    private void setEventListener(com.google.gwt.dom.client.Element e, EventListener listener) {
        DOM.setEventListener(this.asOld(e), listener);
    }
}

