/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
public class SortedMapGenerators {
    @Deprecated
    public SortedMapGenerators() {
    }

    public static class ImmutableSortedMapValueListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)elements[i]);
            }
            return builder.build().values().asList();
        }
    }

    public static class ImmutableSortedMapKeyListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)elements[i], (Object)i);
            }
            return builder.build().keySet().asList();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            return Ordering.natural().sortedCopy(insertionOrder);
        }
    }

    public static class ImmutableSortedMapEntryListGenerator
    implements TestListGenerator<Map.Entry<String, Integer>> {
        @Override
        public SampleElements<Map.Entry<String, Integer>> samples() {
            return new SampleElements<Map.Entry<String, Integer>>(Helpers.mapEntry("foo", 5), Helpers.mapEntry("bar", 3), Helpers.mapEntry("baz", 17), Helpers.mapEntry("quux", 1), Helpers.mapEntry("toaster", -2));
        }

        public Map.Entry<String, Integer>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<String, Integer>> order(List<Map.Entry<String, Integer>> insertionOrder) {
            return new Ordering<Map.Entry<String, Integer>>(){

                public int compare(Map.Entry<String, Integer> left, Map.Entry<String, Integer> right) {
                    return left.getKey().compareTo(right.getKey());
                }
            }.sortedCopy(insertionOrder);
        }

        @Override
        public List<Map.Entry<String, Integer>> create(Object ... elements) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)Preconditions.checkNotNull((Object)o);
                builder.put(entry);
            }
            return builder.build().entrySet().asList();
        }
    }

    public static class ImmutableSortedMapCopyOfEntriesGenerator
    extends TestStringSortedMapGenerator {
        @Override
        public SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
            return ImmutableSortedMap.copyOf(Arrays.asList(entries));
        }
    }

    public static class ImmutableSortedMapGenerator
    extends TestStringSortedMapGenerator {
        @Override
        public SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

