/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.CollectionSerializationEqualTester;
import com.google.common.collect.testing.testers.ListAddAllAtIndexTester;
import com.google.common.collect.testing.testers.ListAddAllTester;
import com.google.common.collect.testing.testers.ListAddAtIndexTester;
import com.google.common.collect.testing.testers.ListAddTester;
import com.google.common.collect.testing.testers.ListCreationTester;
import com.google.common.collect.testing.testers.ListEqualsTester;
import com.google.common.collect.testing.testers.ListGetTester;
import com.google.common.collect.testing.testers.ListHashCodeTester;
import com.google.common.collect.testing.testers.ListIndexOfTester;
import com.google.common.collect.testing.testers.ListLastIndexOfTester;
import com.google.common.collect.testing.testers.ListListIteratorTester;
import com.google.common.collect.testing.testers.ListRemoveAllTester;
import com.google.common.collect.testing.testers.ListRemoveAtIndexTester;
import com.google.common.collect.testing.testers.ListRemoveTester;
import com.google.common.collect.testing.testers.ListRetainAllTester;
import com.google.common.collect.testing.testers.ListSetTester;
import com.google.common.collect.testing.testers.ListSubListTester;
import com.google.common.collect.testing.testers.ListToArrayTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public final class ListTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<ListTestSuiteBuilder<E>, E> {
    public static <E> ListTestSuiteBuilder<E> using(TestListGenerator<E> generator) {
        return (ListTestSuiteBuilder)new ListTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(CollectionSerializationEqualTester.class);
        testers.add(ListAddAllAtIndexTester.class);
        testers.add(ListAddAllTester.class);
        testers.add(ListAddAtIndexTester.class);
        testers.add(ListAddTester.class);
        testers.add(ListCreationTester.class);
        testers.add(ListEqualsTester.class);
        testers.add(ListGetTester.class);
        testers.add(ListHashCodeTester.class);
        testers.add(ListIndexOfTester.class);
        testers.add(ListLastIndexOfTester.class);
        testers.add(ListListIteratorTester.class);
        testers.add(ListRemoveAllTester.class);
        testers.add(ListRemoveAtIndexTester.class);
        testers.add(ListRemoveTester.class);
        testers.add(ListRetainAllTester.class);
        testers.add(ListSetTester.class);
        testers.add(ListSubListTester.class);
        testers.add(ListToArrayTester.class);
        return testers;
    }

    @Override
    public TestSuite createTestSuite() {
        this.withFeatures(CollectionFeature.KNOWN_ORDER);
        return super.createTestSuite();
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new ReserializedListGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(ListTestSuiteBuilder.computeReserializedCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        return derivedSuites;
    }

    private static Set<Feature<?>> computeReserializedCollectionFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    private static final class ReserializedListGenerator<E>
    implements TestListGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedListGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public List<E> create(Object ... elements) {
            return (List)SerializableTester.reserialize((Collection)this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }
}

