/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.Replacement;
import com.google.googlejavaformat.java.SnippetFormatter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GoogleJavaFormatter
extends CodeFormatter {
    private static final int INDENTATION_SIZE = 2;

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        IRegion[] regions = new IRegion[]{new Region(offset, length)};
        return this.formatInternal(kind, source, regions, indentationLevel);
    }

    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        return this.formatInternal(kind, source, regions, indentationLevel);
    }

    public String createIndentationString(int indentationLevel) {
        Preconditions.checkArgument((indentationLevel >= 0 ? 1 : 0) != 0, (String)"Indentation level cannot be less than zero. Given: %s", (Object[])new Object[]{indentationLevel});
        int spaces = indentationLevel * 2;
        StringBuilder buf = new StringBuilder(spaces);
        int i = 0;
        while (i < spaces) {
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private TextEdit formatInternal(int kind, String source, IRegion[] regions, int initialIndent) {
        List replacements;
        block9: {
            SnippetFormatter.SnippetKind snippetKind;
            boolean includeComments = (kind & 0x1000) == 4096;
            switch (kind &= 0xFFFFEFFF) {
                case 1: {
                    snippetKind = SnippetFormatter.SnippetKind.EXPRESSION;
                    break;
                }
                case 2: {
                    snippetKind = SnippetFormatter.SnippetKind.STATEMENTS;
                    break;
                }
                case 4: {
                    snippetKind = SnippetFormatter.SnippetKind.CLASS_BODY_DECLARATIONS;
                    break;
                }
                case 8: {
                    snippetKind = SnippetFormatter.SnippetKind.COMPILATION_UNIT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown snippet kind: %d", kind));
                }
            }
            replacements = new SnippetFormatter().format(snippetKind, source, this.rangesFromRegions(regions), initialIndent, includeComments);
            if (!this.idempotent(source, regions, replacements)) break block9;
            return null;
        }
        try {
            return this.editFromReplacements(replacements);
        }
        catch (FormatterException | IllegalArgumentException throwable) {
            return null;
        }
    }

    private List<Range<Integer>> rangesFromRegions(IRegion[] regions) {
        ArrayList<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
        IRegion[] iRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion region = iRegionArray[n2];
            ranges.add((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(region.getOffset()), (Comparable)Integer.valueOf(region.getOffset() + region.getLength())));
            ++n2;
        }
        return ranges;
    }

    private boolean idempotent(String source, IRegion[] regions, List<Replacement> replacements) {
        if (replacements.size() == 1) {
            Range range;
            String snippet;
            Replacement replacement = replacements.get(0);
            String output = replacement.getReplacementString();
            if (output.equals(source)) {
                return true;
            }
            if (regions.length == 1 && output.equals(snippet = source.substring((Integer)(range = replacement.getReplaceRange()).lowerEndpoint(), (Integer)range.upperEndpoint()))) {
                return true;
            }
        }
        return false;
    }

    private TextEdit editFromReplacements(List<Replacement> replacements) {
        MultiTextEdit edit = new MultiTextEdit();
        for (Replacement replacement : replacements) {
            Range replaceRange = replacement.getReplaceRange();
            edit.addChild((TextEdit)new ReplaceEdit(((Integer)replaceRange.lowerEndpoint()).intValue(), (Integer)replaceRange.upperEndpoint() - (Integer)replaceRange.lowerEndpoint(), replacement.getReplacementString()));
        }
        return edit;
    }
}

