/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.ContinueWithCompletionListener;
import com.google.firebase.tasks.ContinueWithTaskCompletionListener;
import com.google.firebase.tasks.OnCompleteCompletionListener;
import com.google.firebase.tasks.OnCompleteListener;
import com.google.firebase.tasks.OnFailureCompletionListener;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessCompletionListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListenerQueue;
import com.google.firebase.tasks.TaskExecutors;
import java.util.concurrent.Executor;

final class TaskImpl<TResult>
extends Task<TResult> {
    private final Object mLock = new Object();
    private final TaskCompletionListenerQueue<TResult> mListenerQueue = new TaskCompletionListenerQueue();
    @GuardedBy(value="mLock")
    private boolean mComplete;
    @GuardedBy(value="mLock")
    private TResult mResult;
    @GuardedBy(value="mLock")
    private Exception mException;

    TaskImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccessful() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mComplete && this.mException == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult getResult() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkCompleteLocked();
            if (this.mException != null) {
                throw new RuntimeExecutionException(this.mException);
            }
            return this.mResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends Throwable> TResult getResult(@NonNull Class<X> exceptionType) throws X {
        Object object = this.mLock;
        synchronized (object) {
            this.checkCompleteLocked();
            if (exceptionType.isInstance(this.mException)) {
                throw (Throwable)exceptionType.cast(this.mException);
            }
            if (this.mException != null) {
                throw new RuntimeExecutionException(this.mException);
            }
            return this.mResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Exception getException() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mException;
        }
    }

    @Override
    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> listener) {
        return this.addOnSuccessListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> listener) {
        this.mListenerQueue.add(new OnSuccessCompletionListener<TResult>(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull OnFailureListener listener) {
        return this.addOnFailureListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener listener) {
        this.mListenerQueue.add(new OnFailureCompletionListener(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> listener) {
        return this.addOnCompleteListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> listener) {
        this.mListenerQueue.add(new OnCompleteCompletionListener<TResult>(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(TaskExecutors.DEFAULT_THREAD_POOL, continuation);
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskImpl<TResult> continuationTask = new TaskImpl<TResult>();
        this.mListenerQueue.add(new ContinueWithCompletionListener<TResult, TContinuationResult>(executor, continuation, continuationTask));
        this.flushIfComplete();
        return continuationTask;
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(TaskExecutors.DEFAULT_THREAD_POOL, continuation);
    }

    @Override
    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskImpl<TResult> continuationTask = new TaskImpl<TResult>();
        this.mListenerQueue.add(new ContinueWithTaskCompletionListener<TResult, TContinuationResult>(executor, continuation, continuationTask));
        this.flushIfComplete();
        return continuationTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(TResult result) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotCompleteLocked();
            this.mComplete = true;
            this.mResult = result;
        }
        this.mListenerQueue.flush(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(@NonNull Exception e) {
        Preconditions.checkNotNull(e, "Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotCompleteLocked();
            this.mComplete = true;
            this.mException = e;
        }
        this.mListenerQueue.flush(this);
    }

    @GuardedBy(value="mLock")
    private void checkCompleteLocked() {
        Preconditions.checkState(this.mComplete, "Task is not yet complete");
    }

    @GuardedBy(value="mLock")
    private void checkNotCompleteLocked() {
        Preconditions.checkState(!this.mComplete, "Task is already complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIfComplete() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mComplete) {
                return;
            }
        }
        this.mListenerQueue.flush(this);
    }
}

