/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;

class TaskCompletionListenerQueue<TResult> {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private Queue<TaskCompletionListener<TResult>> mQueue;
    @GuardedBy(value="mLock")
    private boolean mFlushing;

    TaskCompletionListenerQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NonNull TaskCompletionListener<TResult> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mQueue == null) {
                this.mQueue = new ArrayDeque<TaskCompletionListener<TResult>>();
            }
            this.mQueue.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(@NonNull Collection<TaskCompletionListener<TResult>> listeners) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mQueue == null || this.mQueue.removeAll(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(@NonNull Task<TResult> task) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mQueue == null || this.mFlushing) {
                return;
            }
            this.mFlushing = true;
        }
        while (true) {
            TaskCompletionListener<TResult> next;
            Object object2 = this.mLock;
            synchronized (object2) {
                next = this.mQueue.poll();
                if (next == null) {
                    this.mFlushing = false;
                    return;
                }
            }
            next.onComplete(task);
        }
    }
}

