/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities;

import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.utilities.Pair;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.Validation;
import com.google.firebase.internal.Base64;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionSource;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;

public class Utilities {
    public static ParsedUrl parseUrl(String url) throws DatabaseException {
        String original = url;
        try {
            int schemeOffset = original.indexOf("//");
            if (schemeOffset == -1) {
                throw new URISyntaxException(original, "Invalid scheme specified");
            }
            int pathOffset = original.substring(schemeOffset + 2).indexOf("/");
            if (pathOffset != -1) {
                String[] pathSegments = original.substring(pathOffset += schemeOffset + 2).split("/");
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < pathSegments.length; ++i) {
                    if (pathSegments[i].equals("")) continue;
                    builder.append("/");
                    builder.append(URLEncoder.encode(pathSegments[i], "UTF-8"));
                }
                String string = String.valueOf(original.substring(0, pathOffset));
                String string2 = String.valueOf(builder.toString());
                original = string2.length() != 0 ? string.concat(string2) : new String(string);
            }
            URI uri = new URI(original);
            String pathString = uri.getPath().replace("+", " ");
            Validation.validateRootPathString(pathString);
            Path path = new Path(pathString);
            String scheme = uri.getScheme();
            RepoInfo repoInfo = new RepoInfo();
            repoInfo.host = uri.getHost().toLowerCase();
            int port = uri.getPort();
            if (port != -1) {
                repoInfo.secure = scheme.equals("https");
                String string = String.valueOf(repoInfo.host);
                repoInfo.host = new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(port).toString();
            } else {
                repoInfo.secure = true;
            }
            String[] parts = repoInfo.host.split("\\.");
            repoInfo.namespace = parts[0].toLowerCase();
            repoInfo.internalHost = repoInfo.host;
            ParsedUrl parsedUrl = new ParsedUrl();
            parsedUrl.path = path;
            parsedUrl.repoInfo = repoInfo;
            return parsedUrl;
        }
        catch (URISyntaxException e) {
            throw new DatabaseException("Invalid Firebase Database url specified", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new DatabaseException("Failed to URLEncode the path", e);
        }
    }

    public static String[] splitIntoFrames(String src, int maxFrameSize) {
        if (src.length() <= maxFrameSize) {
            return new String[]{src};
        }
        ArrayList<String> segs = new ArrayList<String>();
        for (int i = 0; i < src.length(); i += maxFrameSize) {
            int end = Math.min(i + maxFrameSize, src.length());
            String seg = src.substring(i, end);
            segs.add(seg);
        }
        return segs.toArray(new String[segs.size()]);
    }

    public static String sha1HexDigest(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(input.getBytes("UTF-8"));
            byte[] bytes = md.digest();
            return Base64.encodeToString(bytes, 2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing SHA-1 MessageDigest provider.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is required for Firebase Database to run!");
        }
    }

    public static String stringHashV2Representation(String value) {
        String escaped = value;
        if (value.indexOf(92) != -1) {
            escaped = escaped.replace("\\", "\\\\");
        }
        if (value.indexOf(34) != -1) {
            escaped = escaped.replace("\"", "\\\"");
        }
        String string = escaped;
        return new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString();
    }

    public static String doubleToHashString(double value) {
        StringBuilder sb = new StringBuilder(16);
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        for (int i = 0; i < 8; ++i) {
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }

    public static Integer tryParseInt(String num) {
        if (num.length() > 11 || num.length() == 0) {
            return null;
        }
        int i = 0;
        boolean negative = false;
        if (num.charAt(0) == '-') {
            if (num.length() == 1) {
                return null;
            }
            negative = true;
            i = 1;
        }
        long number = 0L;
        while (i < num.length()) {
            char c = num.charAt(i);
            if (c < '0' || c > '9') {
                return null;
            }
            number = number * 10L + (long)(c - 48);
            ++i;
        }
        if (negative) {
            if (-number < Integer.MIN_VALUE) {
                return null;
            }
            return (int)(-number);
        }
        if (number > Integer.MAX_VALUE) {
            return null;
        }
        return (int)number;
    }

    public static int compareInts(int i, int j) {
        if (i < j) {
            return -1;
        }
        if (i == j) {
            return 0;
        }
        return 1;
    }

    public static int compareLongs(long i, long j) {
        if (i < j) {
            return -1;
        }
        if (i == j) {
            return 0;
        }
        return 1;
    }

    public static <C> C castOrNull(Object o, Class<C> clazz) {
        if (clazz.isAssignableFrom(o.getClass())) {
            return (C)o;
        }
        return null;
    }

    public static <C> C getOrNull(Object o, String key, Class<C> clazz) {
        if (o == null) {
            return null;
        }
        Map map = Utilities.castOrNull(o, Map.class);
        Object result = map.get(key);
        if (result != null) {
            return Utilities.castOrNull(result, clazz);
        }
        return null;
    }

    public static void hardAssert(boolean condition) {
        Utilities.hardAssert(condition, "");
    }

    public static void hardAssert(boolean condition, String message) {
        if (!condition) {
            String string = String.valueOf(message);
            throw new AssertionError((Object)(string.length() != 0 ? "hardAssert failed: ".concat(string) : new String("hardAssert failed: ")));
        }
    }

    public static Pair<Task<Void>, DatabaseReference.CompletionListener> wrapOnComplete(DatabaseReference.CompletionListener optListener) {
        if (optListener == null) {
            final TaskCompletionSource source = new TaskCompletionSource();
            DatabaseReference.CompletionListener listener = new DatabaseReference.CompletionListener(){

                @Override
                public void onComplete(DatabaseError error, DatabaseReference ref) {
                    if (error != null) {
                        source.setException(error.toException());
                    } else {
                        source.setResult(null);
                    }
                }
            };
            return new Pair<Task<Void>, DatabaseReference.CompletionListener>(source.getTask(), listener);
        }
        return new Pair<Object, DatabaseReference.CompletionListener>(null, optListener);
    }
}

