/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ParameterValue {
    public static Explicit of(String value) {
        return new Explicit(value);
    }

    public static InAppDefault inAppDefault() {
        return new InAppDefault();
    }

    public static RolloutValue ofRollout(String rolloutId, String value, double percent) {
        return new RolloutValue(rolloutId, value, percent);
    }

    public static PersonalizationValue ofPersonalization(String personalizationId) {
        return new PersonalizationValue(personalizationId);
    }

    public static ExperimentValue ofExperiment(String experimentId, List<ExperimentVariantValue> variantValues) {
        return new ExperimentValue(experimentId, variantValues);
    }

    abstract TemplateResponse.ParameterValueResponse toParameterValueResponse();

    static ParameterValue fromParameterValueResponse(@NonNull TemplateResponse.ParameterValueResponse parameterValueResponse) {
        Preconditions.checkNotNull((Object)parameterValueResponse);
        if (parameterValueResponse.isUseInAppDefault()) {
            return ParameterValue.inAppDefault();
        }
        if (parameterValueResponse.getRolloutValue() != null) {
            TemplateResponse.RolloutValueResponse rv = parameterValueResponse.getRolloutValue();
            double percent = 0.0;
            if (rv.getPercent() != null) {
                percent = rv.getPercent();
            }
            return ParameterValue.ofRollout(rv.getRolloutId(), rv.getValue(), percent);
        }
        if (parameterValueResponse.getPersonalizationValue() != null) {
            TemplateResponse.PersonalizationValueResponse pv = parameterValueResponse.getPersonalizationValue();
            return ParameterValue.ofPersonalization(pv.getPersonalizationId());
        }
        if (parameterValueResponse.getExperimentValue() != null) {
            TemplateResponse.ExperimentValueResponse ev = parameterValueResponse.getExperimentValue();
            List<ExperimentVariantValue> variantValues = ev.getExperimentVariantValues().stream().map(evv -> new ExperimentVariantValue(evv.getVariantId(), evv.getValue(), evv.getNoChange())).collect(Collectors.toList());
            return ParameterValue.ofExperiment(ev.getExperimentId(), variantValues);
        }
        return ParameterValue.of(parameterValueResponse.getValue());
    }

    public static final class ExperimentValue
    extends ParameterValue {
        private final String experimentId;
        private final List<ExperimentVariantValue> variantValues;

        private ExperimentValue(String experimentId, List<ExperimentVariantValue> variantValues) {
            this.experimentId = experimentId;
            this.variantValues = variantValues;
        }

        public String getExperimentId() {
            return this.experimentId;
        }

        public List<ExperimentVariantValue> getExperimentVariantValues() {
            return this.variantValues;
        }

        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            List<TemplateResponse.ExperimentVariantValueResponse> variantValueResponses = this.variantValues.stream().map(variantValue -> new TemplateResponse.ExperimentVariantValueResponse().setVariantId(variantValue.getVariantId()).setValue(variantValue.getValue()).setNoChange(variantValue.getNoChange())).collect(Collectors.toList());
            return new TemplateResponse.ParameterValueResponse().setExperimentValue(new TemplateResponse.ExperimentValueResponse().setExperimentId(this.experimentId).setExperimentVariantValues(variantValueResponses));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExperimentValue that = (ExperimentValue)o;
            return Objects.equals(this.experimentId, that.experimentId) && Objects.equals(this.variantValues, that.variantValues);
        }

        public int hashCode() {
            return Objects.hash(this.experimentId, this.variantValues);
        }
    }

    public static final class ExperimentVariantValue {
        private final String variantId;
        private final String value;
        private final Boolean noChange;

        ExperimentVariantValue(String variantId, String value, Boolean noChange) {
            this.variantId = variantId;
            this.value = value;
            this.noChange = noChange;
        }

        public static ExperimentVariantValue of(String variantId, String value) {
            return new ExperimentVariantValue(variantId, value, null);
        }

        public static ExperimentVariantValue ofNoChange(String variantId) {
            return new ExperimentVariantValue(variantId, null, true);
        }

        public String getVariantId() {
            return this.variantId;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        @Nullable
        Boolean getNoChange() {
            return this.noChange;
        }

        public boolean isNoChange() {
            return Boolean.TRUE.equals(this.noChange);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExperimentVariantValue that = (ExperimentVariantValue)o;
            return this.noChange == that.noChange && Objects.equals(this.variantId, that.variantId) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.variantId, this.value, this.noChange);
        }
    }

    public static final class PersonalizationValue
    extends ParameterValue {
        private final String personalizationId;

        private PersonalizationValue(String personalizationId) {
            this.personalizationId = personalizationId;
        }

        public String getPersonalizationId() {
            return this.personalizationId;
        }

        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setPersonalizationValue(new TemplateResponse.PersonalizationValueResponse().setPersonalizationId(this.personalizationId));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonalizationValue that = (PersonalizationValue)o;
            return Objects.equals(this.personalizationId, that.personalizationId);
        }

        public int hashCode() {
            return Objects.hash(this.personalizationId);
        }
    }

    public static final class RolloutValue
    extends ParameterValue {
        private final String rolloutId;
        private final String value;
        private final double percent;

        private RolloutValue(String rolloutId, String value, double percent) {
            this.rolloutId = rolloutId;
            this.value = value;
            this.percent = percent;
        }

        public String getRolloutId() {
            return this.rolloutId;
        }

        public String getValue() {
            return this.value;
        }

        public double getPercent() {
            return this.percent;
        }

        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setRolloutValue(new TemplateResponse.RolloutValueResponse().setRolloutId(this.rolloutId).setValue(this.value).setPercent(this.percent));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RolloutValue that = (RolloutValue)o;
            return Double.compare(that.percent, this.percent) == 0 && Objects.equals(this.rolloutId, that.rolloutId) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.rolloutId, this.value, this.percent);
        }
    }

    public static final class InAppDefault
    extends ParameterValue {
        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setUseInAppDefault(true);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static final class Explicit
    extends ParameterValue {
        private final String value;

        private Explicit(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setValue(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Explicit explicit = (Explicit)o;
            return Objects.equals(this.value, explicit.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

