/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.LowLevelHttpResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.internal.ApacheHttp2Entity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.message.StatusLine;

public class ApacheHttp2Response
extends LowLevelHttpResponse {
    private final Message<HttpResponse, ApacheHttp2Entity> message;
    private final HttpResponse response;
    private final Header[] allHeaders;
    private final EntityDetails entity;
    private final byte[] content;

    ApacheHttp2Response(Message<HttpResponse, ApacheHttp2Entity> message) {
        this.message = message;
        this.response = (HttpResponse)message.getHead();
        this.allHeaders = this.response.getHeaders();
        ApacheHttp2Entity body = (ApacheHttp2Entity)message.getBody();
        this.entity = body != null ? body.getEntityDetails() : null;
        this.content = body != null ? body.getContent() : null;
    }

    public int getStatusCode() {
        return this.response.getCode();
    }

    public InputStream getContent() throws IOException {
        return this.content == null ? null : new ByteArrayInputStream(this.content);
    }

    public String getContentEncoding() {
        return this.entity == null ? null : this.entity.getContentEncoding();
    }

    public long getContentLength() {
        if (this.content != null) {
            return this.content.length;
        }
        return this.entity == null ? -1L : this.entity.getContentLength();
    }

    public String getContentType() {
        return this.entity == null ? null : this.entity.getContentType();
    }

    public String getReasonPhrase() {
        return this.response.getReasonPhrase();
    }

    public String getStatusLine() {
        return new StatusLine(this.response).toString();
    }

    public String getHeaderValue(String name) {
        Header header = this.response.getLastHeader(name);
        return header == null ? null : header.getValue();
    }

    public String getHeaderValue(int index) {
        return this.allHeaders[index].getValue();
    }

    public int getHeaderCount() {
        return this.allHeaders.length;
    }

    public String getHeaderName(int index) {
        return this.allHeaders[index].getName();
    }

    @VisibleForTesting
    public Message<HttpResponse, ApacheHttp2Entity> getMessage() {
        return this.message;
    }
}

