/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.firebase.internal.ApacheHttp2Entity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;

public class ApacheHttp2AsyncEntityConsumer
implements AsyncEntityConsumer<ApacheHttp2Entity> {
    private EntityDetails entityDetails;
    private FutureCallback<ApacheHttp2Entity> resultCallback;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public void streamStart(EntityDetails entityDetails, FutureCallback<ApacheHttp2Entity> resultCallback) throws HttpException, IOException {
        this.entityDetails = entityDetails;
        this.resultCallback = resultCallback;
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    public void consume(ByteBuffer src) throws IOException {
        if (src.hasArray()) {
            this.buffer.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
            src.position(src.limit());
        } else {
            byte[] bytes = new byte[src.remaining()];
            src.get(bytes);
            this.buffer.write(bytes);
        }
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.resultCallback != null) {
            this.resultCallback.completed((Object)this.getContent());
        }
    }

    public void failed(Exception cause) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(cause);
        }
    }

    public void releaseResources() {
        this.buffer.reset();
    }

    public ApacheHttp2Entity getContent() {
        return new ApacheHttp2Entity(this.buffer.toByteArray(), this.entityDetails);
    }
}

