/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.Condition;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.Parameter;
import com.google.firebase.remoteconfig.ParameterGroup;
import com.google.firebase.remoteconfig.Version;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Template {
    private String etag;
    private Map<String, Parameter> parameters;
    private List<Condition> conditions;
    private Map<String, ParameterGroup> parameterGroups;
    private Version version;

    public Template(String etag) {
        this.parameters = new HashMap<String, Parameter>();
        this.conditions = new ArrayList<Condition>();
        this.parameterGroups = new HashMap<String, ParameterGroup>();
        this.etag = etag;
    }

    Template() {
        this((String)null);
    }

    Template(@NonNull TemplateResponse templateResponse) {
        Preconditions.checkNotNull((Object)templateResponse);
        this.parameters = new HashMap<String, Parameter>();
        this.conditions = new ArrayList<Condition>();
        this.parameterGroups = new HashMap<String, ParameterGroup>();
        if (templateResponse.getParameters() != null) {
            for (Map.Entry entry : templateResponse.getParameters().entrySet()) {
                this.parameters.put((String)entry.getKey(), new Parameter((TemplateResponse.ParameterResponse)entry.getValue()));
            }
        }
        if (templateResponse.getConditions() != null) {
            for (TemplateResponse.ConditionResponse conditionResponse : templateResponse.getConditions()) {
                this.conditions.add(new Condition(conditionResponse));
            }
        }
        if (templateResponse.getParameterGroups() != null) {
            for (Map.Entry entry : templateResponse.getParameterGroups().entrySet()) {
                this.parameterGroups.put((String)entry.getKey(), new ParameterGroup((TemplateResponse.ParameterGroupResponse)entry.getValue()));
            }
        }
        if (templateResponse.getVersion() != null) {
            this.version = new Version(templateResponse.getVersion());
        }
        this.etag = templateResponse.getEtag();
    }

    public static Template fromJSON(@NonNull String json) throws FirebaseRemoteConfigException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)json) ? 1 : 0) != 0, (Object)"JSON String must not be null or empty.");
        JsonFactory jsonFactory = ApiClientUtils.getDefaultJsonFactory();
        try {
            TemplateResponse templateResponse = (TemplateResponse)jsonFactory.createJsonParser(json).parseAndClose(TemplateResponse.class);
            return new Template(templateResponse);
        }
        catch (IOException e) {
            throw new FirebaseRemoteConfigException(ErrorCode.INVALID_ARGUMENT, "Unable to parse JSON string.");
        }
    }

    public String getETag() {
        return this.etag;
    }

    @NonNull
    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    @NonNull
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @NonNull
    public Map<String, ParameterGroup> getParameterGroups() {
        return this.parameterGroups;
    }

    public Version getVersion() {
        return this.version;
    }

    public Template setParameters(@NonNull Map<String, Parameter> parameters) {
        Preconditions.checkNotNull(parameters, (Object)"parameters must not be null.");
        this.parameters = parameters;
        return this;
    }

    public Template setConditions(@NonNull List<Condition> conditions) {
        Preconditions.checkNotNull(conditions, (Object)"conditions must not be null.");
        this.conditions = conditions;
        return this;
    }

    public Template setParameterGroups(@NonNull Map<String, ParameterGroup> parameterGroups) {
        Preconditions.checkNotNull(parameterGroups, (Object)"parameter groups must not be null.");
        this.parameterGroups = parameterGroups;
        return this;
    }

    public Template setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String toJSON() {
        JsonFactory jsonFactory = ApiClientUtils.getDefaultJsonFactory();
        try {
            return jsonFactory.toString((Object)this.toTemplateResponse(true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Template setETag(String etag) {
        this.etag = etag;
        return this;
    }

    TemplateResponse toTemplateResponse(boolean includeAll) {
        HashMap<String, TemplateResponse.ParameterResponse> parameterResponses = new HashMap<String, TemplateResponse.ParameterResponse>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            parameterResponses.put(entry.getKey(), entry.getValue().toParameterResponse());
        }
        ArrayList<TemplateResponse.ConditionResponse> conditionResponses = new ArrayList<TemplateResponse.ConditionResponse>();
        for (Condition condition : this.conditions) {
            conditionResponses.add(condition.toConditionResponse());
        }
        HashMap<String, TemplateResponse.ParameterGroupResponse> parameterGroupResponse = new HashMap<String, TemplateResponse.ParameterGroupResponse>();
        for (Map.Entry<String, ParameterGroup> entry : this.parameterGroups.entrySet()) {
            parameterGroupResponse.put(entry.getKey(), entry.getValue().toParameterGroupResponse());
        }
        TemplateResponse.VersionResponse versionResponse = this.version == null ? null : this.version.toVersionResponse(includeAll);
        TemplateResponse templateResponse = new TemplateResponse().setParameters(parameterResponses).setConditions(conditionResponses).setParameterGroups(parameterGroupResponse).setVersion(versionResponse);
        if (includeAll) {
            return templateResponse.setEtag(this.etag);
        }
        return templateResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        return Objects.equals(this.etag, template.etag) && Objects.equals(this.parameters, template.parameters) && Objects.equals(this.conditions, template.conditions) && Objects.equals(this.parameterGroups, template.parameterGroups) && Objects.equals(this.version, template.version);
    }

    public int hashCode() {
        return Objects.hash(this.etag, this.parameters, this.conditions, this.parameterGroups, this.version);
    }
}

