/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseRequestInitializer;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.TopicManagementResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FirebaseMessaging {
    private static final String FCM_URL = "https://fcm.googleapis.com/v1/projects/%s/messages:send";
    private static final String FCM_ERROR_TYPE = "type.googleapis.com/google.firebase.fcm.v1.FcmError";
    private static final String INTERNAL_ERROR = "internal-error";
    private static final String UNKNOWN_ERROR = "unknown-error";
    private static final Map<String, String> FCM_ERROR_CODES = ImmutableMap.builder().put((Object)"NOT_FOUND", (Object)"registration-token-not-registered").put((Object)"PERMISSION_DENIED", (Object)"mismatched-credential").put((Object)"RESOURCE_EXHAUSTED", (Object)"message-rate-exceeded").put((Object)"UNAUTHENTICATED", (Object)"invalid-apns-credentials").put((Object)"APNS_AUTH_ERROR", (Object)"invalid-apns-credentials").put((Object)"INTERNAL", (Object)"internal-error").put((Object)"INVALID_ARGUMENT", (Object)"invalid-argument").put((Object)"QUOTA_EXCEEDED", (Object)"message-rate-exceeded").put((Object)"SENDER_ID_MISMATCH", (Object)"mismatched-credential").put((Object)"UNAVAILABLE", (Object)"server-unavailable").put((Object)"UNREGISTERED", (Object)"registration-token-not-registered").build();
    static final Map<Integer, String> IID_ERROR_CODES = ImmutableMap.builder().put((Object)400, (Object)"invalid-argument").put((Object)401, (Object)"authentication-error").put((Object)403, (Object)"authentication-error").put((Object)500, (Object)"internal-error").put((Object)503, (Object)"server-unavailable").build();
    private static final String IID_HOST = "https://iid.googleapis.com";
    private static final String IID_SUBSCRIBE_PATH = "iid/v1:batchAdd";
    private static final String IID_UNSUBSCRIBE_PATH = "iid/v1:batchRemove";
    private final FirebaseApp app;
    private final HttpRequestFactory requestFactory;
    private final JsonFactory jsonFactory;
    private final String url;
    private HttpResponseInterceptor interceptor;
    private static final String SERVICE_ID = FirebaseMessaging.class.getName();

    private FirebaseMessaging(FirebaseApp app) {
        HttpTransport httpTransport = app.getOptions().getHttpTransport();
        this.app = app;
        this.requestFactory = httpTransport.createRequestFactory((HttpRequestInitializer)new FirebaseRequestInitializer(app));
        this.jsonFactory = app.getOptions().getJsonFactory();
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access messaging service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.url = String.format(FCM_URL, projectId);
    }

    public static FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseMessaging getInstance(FirebaseApp app) {
        FirebaseMessagingService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseMessagingService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseMessagingService(app));
        }
        return (FirebaseMessaging)service.getInstance();
    }

    public String send(@NonNull Message message) throws FirebaseMessagingException {
        return this.send(message, false);
    }

    public String send(@NonNull Message message, boolean dryRun) throws FirebaseMessagingException {
        return this.sendOp(message, dryRun).call();
    }

    public ApiFuture<String> sendAsync(@NonNull Message message) {
        return this.sendAsync(message, false);
    }

    public ApiFuture<String> sendAsync(@NonNull Message message, boolean dryRun) {
        return this.sendOp(message, dryRun).callAsync(this.app);
    }

    public TopicManagementResponse subscribeToTopic(@NonNull List<String> registrationTokens, @NonNull String topic) throws FirebaseMessagingException {
        return this.manageTopicOp(registrationTokens, topic, IID_SUBSCRIBE_PATH).call();
    }

    public ApiFuture<TopicManagementResponse> subscribeToTopicAsync(@NonNull List<String> registrationTokens, @NonNull String topic) {
        return this.manageTopicOp(registrationTokens, topic, IID_SUBSCRIBE_PATH).callAsync(this.app);
    }

    public TopicManagementResponse unsubscribeFromTopic(@NonNull List<String> registrationTokens, @NonNull String topic) throws FirebaseMessagingException {
        return this.manageTopicOp(registrationTokens, topic, IID_UNSUBSCRIBE_PATH).call();
    }

    public ApiFuture<TopicManagementResponse> unsubscribeFromTopicAsync(@NonNull List<String> registrationTokens, @NonNull String topic) {
        return this.manageTopicOp(registrationTokens, topic, IID_UNSUBSCRIBE_PATH).callAsync(this.app);
    }

    private CallableOperation<String, FirebaseMessagingException> sendOp(final Message message, final boolean dryRun) {
        Preconditions.checkNotNull((Object)message, (Object)"message must not be null");
        return new CallableOperation<String, FirebaseMessagingException>(){

            /*
             * Loose catch block
             */
            @Override
            protected String execute() throws FirebaseMessagingException {
                ImmutableMap.Builder payload = ImmutableMap.builder().put((Object)"message", (Object)message);
                if (dryRun) {
                    payload.put((Object)"validate_only", (Object)true);
                }
                HttpResponse response = null;
                try {
                    HttpRequest request = FirebaseMessaging.this.requestFactory.buildPostRequest(new GenericUrl(FirebaseMessaging.this.url), (HttpContent)new JsonHttpContent(FirebaseMessaging.this.jsonFactory, (Object)payload.build()));
                    request.getHeaders().set("X-GOOG-API-FORMAT-VERSION", (Object)"2");
                    request.setParser((ObjectParser)new JsonObjectParser(FirebaseMessaging.this.jsonFactory));
                    request.setResponseInterceptor(FirebaseMessaging.this.interceptor);
                    response = request.execute();
                    MessagingServiceResponse parsed = new MessagingServiceResponse();
                    FirebaseMessaging.this.jsonFactory.createJsonParser(response.getContent()).parseAndClose((Object)parsed);
                    String string = parsed.name;
                    FirebaseMessaging.disconnectQuietly(response);
                    return string;
                }
                catch (HttpResponseException e) {
                    FirebaseMessaging.this.handleSendHttpError(e);
                    String string = null;
                    return string;
                }
                catch (IOException e2) {
                    throw new FirebaseMessagingException(FirebaseMessaging.INTERNAL_ERROR, "Error while calling FCM backend service", e2);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    FirebaseMessaging.disconnectQuietly(response);
                }
            }
        };
    }

    private void handleSendHttpError(HttpResponseException e) throws FirebaseMessagingException {
        String msg;
        String code;
        MessagingServiceErrorResponse response = new MessagingServiceErrorResponse();
        if (e.getContent() != null) {
            try {
                JsonParser parser = this.jsonFactory.createJsonParser(e.getContent());
                parser.parseAndClose((Object)response);
            }
            catch (IOException parser) {
                // empty catch block
            }
        }
        if ((code = FCM_ERROR_CODES.get(response.getErrorCode())) == null) {
            code = UNKNOWN_ERROR;
        }
        if (Strings.isNullOrEmpty((String)(msg = response.getErrorMessage()))) {
            msg = String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent());
        }
        throw new FirebaseMessagingException(code, msg, e);
    }

    private CallableOperation<TopicManagementResponse, FirebaseMessagingException> manageTopicOp(final List<String> registrationTokens, final String topic, final String path) {
        FirebaseMessaging.checkRegistrationTokens(registrationTokens);
        FirebaseMessaging.checkTopic(topic);
        return new CallableOperation<TopicManagementResponse, FirebaseMessagingException>(){

            /*
             * Loose catch block
             */
            @Override
            protected TopicManagementResponse execute() throws FirebaseMessagingException {
                String prefixedTopic = topic.startsWith("/topics/") ? topic : "/topics/" + topic;
                ImmutableMap payload = ImmutableMap.of((Object)"to", (Object)prefixedTopic, (Object)"registration_tokens", (Object)registrationTokens);
                String url = String.format("%s/%s", FirebaseMessaging.IID_HOST, path);
                HttpResponse response = null;
                try {
                    HttpRequest request = FirebaseMessaging.this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new JsonHttpContent(FirebaseMessaging.this.jsonFactory, (Object)payload));
                    request.getHeaders().set("access_token_auth", (Object)"true");
                    request.setParser((ObjectParser)new JsonObjectParser(FirebaseMessaging.this.jsonFactory));
                    request.setResponseInterceptor(FirebaseMessaging.this.interceptor);
                    response = request.execute();
                    InstanceIdServiceResponse parsed = new InstanceIdServiceResponse();
                    FirebaseMessaging.this.jsonFactory.createJsonParser(response.getContent()).parseAndClose((Object)parsed);
                    Preconditions.checkState((parsed.results != null && !parsed.results.isEmpty() ? 1 : 0) != 0, (Object)"unexpected response from topic management service");
                    TopicManagementResponse topicManagementResponse = new TopicManagementResponse(parsed.results);
                    FirebaseMessaging.disconnectQuietly(response);
                    return topicManagementResponse;
                }
                catch (HttpResponseException e) {
                    FirebaseMessaging.this.handleTopicManagementHttpError(e);
                    TopicManagementResponse topicManagementResponse = null;
                    return topicManagementResponse;
                }
                catch (IOException e2) {
                    throw new FirebaseMessagingException(FirebaseMessaging.INTERNAL_ERROR, "Error while calling IID backend service", e2);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    FirebaseMessaging.disconnectQuietly(response);
                }
            }
        };
    }

    private void handleTopicManagementHttpError(HttpResponseException e) throws FirebaseMessagingException {
        String msg;
        InstanceIdServiceErrorResponse response = new InstanceIdServiceErrorResponse();
        try {
            JsonParser parser = this.jsonFactory.createJsonParser(e.getContent());
            parser.parseAndClose((Object)response);
        }
        catch (IOException parser) {
            // empty catch block
        }
        String code = IID_ERROR_CODES.get(e.getStatusCode());
        if (code == null) {
            code = UNKNOWN_ERROR;
        }
        if (Strings.isNullOrEmpty((String)(msg = response.error))) {
            msg = String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent());
        }
        throw new FirebaseMessagingException(code, msg, e);
    }

    private static void disconnectQuietly(HttpResponse response) {
        if (response != null) {
            try {
                response.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void checkRegistrationTokens(List<String> registrationTokens) {
        Preconditions.checkArgument((registrationTokens != null && !registrationTokens.isEmpty() ? 1 : 0) != 0, (Object)"registrationTokens list must not be null or empty");
        Preconditions.checkArgument((registrationTokens.size() <= 1000 ? 1 : 0) != 0, (Object)"registrationTokens list must not contain more than 1000 elements");
        for (String token : registrationTokens) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"registration tokens list must not contain null or empty strings");
        }
    }

    private static void checkTopic(String topic) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)topic) ? 1 : 0) != 0, (Object)"topic must not be null or empty");
        Preconditions.checkArgument((boolean)topic.matches("^(/topics/)?(private/)?[a-zA-Z0-9-_.~%]+$"), (Object)"invalid topic name");
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    private static class InstanceIdServiceErrorResponse {
        @Key(value="error")
        private String error;

        private InstanceIdServiceErrorResponse() {
        }
    }

    private static class InstanceIdServiceResponse {
        @Key(value="results")
        private List<Map<String, Object>> results;

        private InstanceIdServiceResponse() {
        }
    }

    private static class MessagingServiceErrorResponse {
        @Key(value="error")
        private Map<String, Object> error;

        private MessagingServiceErrorResponse() {
        }

        String getErrorCode() {
            if (this.error == null) {
                return null;
            }
            Object details = this.error.get("details");
            if (details != null && details instanceof List) {
                for (Object detail : (List)details) {
                    Map detailMap;
                    if (!(detail instanceof Map) || !FirebaseMessaging.FCM_ERROR_TYPE.equals((detailMap = (Map)detail).get("@type"))) continue;
                    return (String)detailMap.get("errorCode");
                }
            }
            return (String)this.error.get("status");
        }

        String getErrorMessage() {
            if (this.error != null) {
                return (String)this.error.get("message");
            }
            return null;
        }
    }

    private static class MessagingServiceResponse {
        @Key(value="name")
        private String name;

        private MessagingServiceResponse() {
        }
    }

    private static class FirebaseMessagingService
    extends FirebaseService<FirebaseMessaging> {
        FirebaseMessagingService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseMessaging(app));
        }

        @Override
        public void destroy() {
        }
    }
}

