/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.BatchResponseImpl;
import com.google.firebase.messaging.FirebaseMessagingClient;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.SendResponse;
import com.google.firebase.messaging.internal.MessagingServiceErrorResponse;
import com.google.firebase.messaging.internal.MessagingServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class FirebaseMessagingClientImpl
implements FirebaseMessagingClient {
    private static final String FCM_URL = "https://fcm.googleapis.com/v1/projects/%s/messages:send";
    private static final String FCM_BATCH_URL = "https://fcm.googleapis.com/batch";
    private static final String API_FORMAT_VERSION_HEADER = "X-GOOG-API-FORMAT-VERSION";
    private static final String CLIENT_VERSION_HEADER = "X-Firebase-Client";
    private static final Map<String, String> FCM_ERROR_CODES = ImmutableMap.builder().put((Object)"NOT_FOUND", (Object)"registration-token-not-registered").put((Object)"PERMISSION_DENIED", (Object)"mismatched-credential").put((Object)"RESOURCE_EXHAUSTED", (Object)"message-rate-exceeded").put((Object)"UNAUTHENTICATED", (Object)"third-party-auth-error").put((Object)"APNS_AUTH_ERROR", (Object)"third-party-auth-error").put((Object)"INTERNAL", (Object)"internal-error").put((Object)"INVALID_ARGUMENT", (Object)"invalid-argument").put((Object)"QUOTA_EXCEEDED", (Object)"message-rate-exceeded").put((Object)"SENDER_ID_MISMATCH", (Object)"mismatched-credential").put((Object)"THIRD_PARTY_AUTH_ERROR", (Object)"third-party-auth-error").put((Object)"UNAVAILABLE", (Object)"server-unavailable").put((Object)"UNREGISTERED", (Object)"registration-token-not-registered").build();
    private final String fcmSendUrl;
    private final HttpRequestFactory requestFactory;
    private final HttpRequestFactory childRequestFactory;
    private final JsonFactory jsonFactory;
    private final HttpResponseInterceptor responseInterceptor;
    private final String clientVersion = "fire-admin-java/" + SdkUtils.getVersion();

    private FirebaseMessagingClientImpl(Builder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.projectId) ? 1 : 0) != 0);
        this.fcmSendUrl = String.format(FCM_URL, builder.projectId);
        this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)builder.requestFactory);
        this.childRequestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)builder.childRequestFactory);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)builder.jsonFactory);
        this.responseInterceptor = builder.responseInterceptor;
    }

    @VisibleForTesting
    String getFcmSendUrl() {
        return this.fcmSendUrl;
    }

    @VisibleForTesting
    HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @VisibleForTesting
    HttpRequestFactory getChildRequestFactory() {
        return this.childRequestFactory;
    }

    @VisibleForTesting
    JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @VisibleForTesting
    String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public String send(Message message, boolean dryRun) throws FirebaseMessagingException {
        try {
            return this.sendSingleRequest(message, dryRun);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling FCM backend service", e);
        }
    }

    @Override
    public BatchResponse sendAll(List<Message> messages, boolean dryRun) throws FirebaseMessagingException {
        try {
            return this.sendBatchRequest(messages, dryRun);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling FCM backend service", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendSingleRequest(Message message, boolean dryRun) throws IOException {
        HttpRequest request = this.requestFactory.buildPostRequest(new GenericUrl(this.fcmSendUrl), (HttpContent)new JsonHttpContent(this.jsonFactory, message.wrapForTransport(dryRun)));
        this.setCommonFcmHeaders(request.getHeaders());
        request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
        request.setResponseInterceptor(this.responseInterceptor);
        HttpResponse response = request.execute();
        try {
            MessagingServiceResponse parsed = new MessagingServiceResponse();
            this.jsonFactory.createJsonParser(response.getContent()).parseAndClose((Object)parsed);
            String string = parsed.getMessageId();
            return string;
        }
        finally {
            ApiClientUtils.disconnectQuietly(response);
        }
    }

    private BatchResponse sendBatchRequest(List<Message> messages, boolean dryRun) throws IOException {
        MessagingBatchCallback callback = new MessagingBatchCallback();
        BatchRequest batch = this.newBatchRequest(messages, dryRun, callback);
        batch.execute();
        return new BatchResponseImpl(callback.getResponses());
    }

    private BatchRequest newBatchRequest(List<Message> messages, boolean dryRun, MessagingBatchCallback callback) throws IOException {
        BatchRequest batch = new BatchRequest(this.requestFactory.getTransport(), this.getBatchRequestInitializer());
        batch.setBatchUrl(new GenericUrl(FCM_BATCH_URL));
        JsonObjectParser jsonParser = new JsonObjectParser(this.jsonFactory);
        GenericUrl sendUrl = new GenericUrl(this.fcmSendUrl);
        for (Message message : messages) {
            HttpRequest request = this.childRequestFactory.buildPostRequest(sendUrl, (HttpContent)new JsonHttpContent(this.jsonFactory, message.wrapForTransport(dryRun)));
            request.setParser((ObjectParser)jsonParser);
            this.setCommonFcmHeaders(request.getHeaders());
            batch.queue(request, MessagingServiceResponse.class, MessagingServiceErrorResponse.class, (BatchCallback)callback);
        }
        return batch;
    }

    private void setCommonFcmHeaders(HttpHeaders headers) {
        headers.set(API_FORMAT_VERSION_HEADER, (Object)"2");
        headers.set(CLIENT_VERSION_HEADER, (Object)this.clientVersion);
    }

    private FirebaseMessagingException createExceptionFromResponse(HttpResponseException e) {
        MessagingServiceErrorResponse response = new MessagingServiceErrorResponse();
        if (e.getContent() != null) {
            try {
                JsonParser parser = this.jsonFactory.createJsonParser(e.getContent());
                parser.parseAndClose((Object)response);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FirebaseMessagingClientImpl.newException(response, e);
    }

    private HttpRequestInitializer getBatchRequestInitializer() {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                HttpRequestInitializer initializer = FirebaseMessagingClientImpl.this.requestFactory.getInitializer();
                if (initializer != null) {
                    initializer.initialize(request);
                }
                request.setResponseInterceptor(FirebaseMessagingClientImpl.this.responseInterceptor);
            }
        };
    }

    static FirebaseMessagingClientImpl fromApp(FirebaseApp app) {
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access messaging service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        return FirebaseMessagingClientImpl.builder().setProjectId(projectId).setRequestFactory(ApiClientUtils.newAuthorizedRequestFactory(app)).setChildRequestFactory(ApiClientUtils.newUnauthorizedRequestFactory(app)).setJsonFactory(app.getOptions().getJsonFactory()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    private static FirebaseMessagingException newException(MessagingServiceErrorResponse response) {
        return FirebaseMessagingClientImpl.newException(response, null);
    }

    private static FirebaseMessagingException newException(MessagingServiceErrorResponse response, @Nullable HttpResponseException e) {
        String msg;
        String code = FCM_ERROR_CODES.get(response.getErrorCode());
        if (code == null) {
            code = "unknown-error";
        }
        if (Strings.isNullOrEmpty((String)(msg = response.getErrorMessage()))) {
            msg = e != null ? String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent()) : String.format("Unexpected HTTP response: %s", response.toString());
        }
        return new FirebaseMessagingException(code, msg, e);
    }

    private static class MessagingBatchCallback
    implements BatchCallback<MessagingServiceResponse, MessagingServiceErrorResponse> {
        private final ImmutableList.Builder<SendResponse> responses = ImmutableList.builder();

        private MessagingBatchCallback() {
        }

        public void onSuccess(MessagingServiceResponse response, HttpHeaders responseHeaders) {
            this.responses.add((Object)SendResponse.fromMessageId(response.getMessageId()));
        }

        public void onFailure(MessagingServiceErrorResponse error, HttpHeaders responseHeaders) {
            this.responses.add((Object)SendResponse.fromException(FirebaseMessagingClientImpl.newException(error)));
        }

        List<SendResponse> getResponses() {
            return this.responses.build();
        }
    }

    static final class Builder {
        private String projectId;
        private HttpRequestFactory requestFactory;
        private HttpRequestFactory childRequestFactory;
        private JsonFactory jsonFactory;
        private HttpResponseInterceptor responseInterceptor;

        private Builder() {
        }

        Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        Builder setRequestFactory(HttpRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            return this;
        }

        Builder setChildRequestFactory(HttpRequestFactory childRequestFactory) {
            this.childRequestFactory = childRequestFactory;
            return this;
        }

        Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        Builder setResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
            this.responseInterceptor = responseInterceptor;
            return this;
        }

        FirebaseMessagingClientImpl build() {
            return new FirebaseMessagingClientImpl(this);
        }
    }
}

