/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;
import java.io.IOException;

class HttpHelper {
    @VisibleForTesting
    static final String PATCH_OVERRIDE_KEY = "X-HTTP-Method-Override";
    @VisibleForTesting
    static final String PATCH_OVERRIDE_VALUE = "PATCH";
    private static final ImmutableMap<Integer, String> ERROR_CODES = ImmutableMap.builder().put((Object)401, (Object)"Request not authorized.").put((Object)403, (Object)"Client does not have sufficient privileges.").put((Object)404, (Object)"Failed to find the resource.").put((Object)409, (Object)"The resource already exists.").put((Object)429, (Object)"Request throttled by the backend server.").put((Object)500, (Object)"Internal server error.").put((Object)503, (Object)"Backend servers are over capacity. Try again later.").build();
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private final String clientVersion = "Java/Admin/" + SdkUtils.getVersion();
    private final JsonFactory jsonFactory;
    private final HttpRequestFactory requestFactory;
    private HttpResponseInterceptor interceptor;

    HttpHelper(JsonFactory jsonFactory, HttpRequestFactory requestFactory) {
        this.jsonFactory = jsonFactory;
        this.requestFactory = requestFactory;
    }

    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    <T> void makeGetRequest(String url, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        try {
            this.makeRequest(this.requestFactory.buildGetRequest(new GenericUrl(url)), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
        }
        catch (IOException e) {
            HttpHelper.handleError(requestIdentifier, requestIdentifierDescription, e);
        }
    }

    <T> void makePostRequest(String url, Object payload, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        try {
            this.makeRequest(this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new JsonHttpContent(this.jsonFactory, payload)), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
        }
        catch (IOException e) {
            HttpHelper.handleError(requestIdentifier, requestIdentifierDescription, e);
        }
    }

    <T> void makePatchRequest(String url, Object payload, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        try {
            HttpRequest baseRequest = this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new JsonHttpContent(this.jsonFactory, payload));
            baseRequest.getHeaders().set(PATCH_OVERRIDE_KEY, (Object)PATCH_OVERRIDE_VALUE);
            this.makeRequest(baseRequest, parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
        }
        catch (IOException e) {
            HttpHelper.handleError(requestIdentifier, requestIdentifierDescription, e);
        }
    }

    <T> void makeDeleteRequest(String url, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        try {
            this.makeRequest(this.requestFactory.buildDeleteRequest(new GenericUrl(url)), parsedResponseInstance, requestIdentifier, requestIdentifierDescription);
        }
        catch (IOException e) {
            HttpHelper.handleError(requestIdentifier, requestIdentifierDescription, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void makeRequest(HttpRequest baseRequest, T parsedResponseInstance, String requestIdentifier, String requestIdentifierDescription) throws FirebaseProjectManagementException {
        HttpResponse response = null;
        try {
            baseRequest.getHeaders().set(CLIENT_VERSION_HEADER, (Object)this.clientVersion);
            baseRequest.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
            baseRequest.setResponseInterceptor(this.interceptor);
            response = baseRequest.execute();
            this.jsonFactory.createJsonParser(response.getContent(), Charsets.UTF_8).parseAndClose(parsedResponseInstance);
            HttpHelper.disconnectQuietly(response);
        }
        catch (Exception e) {
            HttpHelper.handleError(requestIdentifier, requestIdentifierDescription, e);
        }
        finally {
            HttpHelper.disconnectQuietly(response);
        }
    }

    private static void disconnectQuietly(HttpResponse response) {
        if (response != null) {
            try {
                response.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void handleError(String requestIdentifier, String requestIdentifierDescription, Exception e) throws FirebaseProjectManagementException {
        int statusCode;
        String messageBody = "Error while invoking Firebase Project Management service.";
        if (e instanceof HttpResponseException && ERROR_CODES.containsKey((Object)(statusCode = ((HttpResponseException)e).getStatusCode()))) {
            messageBody = (String)ERROR_CODES.get((Object)statusCode);
        }
        throw HttpHelper.createFirebaseProjectManagementException(requestIdentifier, requestIdentifierDescription, messageBody, e);
    }

    static FirebaseProjectManagementException createFirebaseProjectManagementException(String requestIdentifier, String requestIdentifierDescription, String messageBody, @Nullable Exception cause) {
        return new FirebaseProjectManagementException(String.format("%s \"%s\": %s", requestIdentifierDescription, requestIdentifier, messageBody), cause);
    }
}

