/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AbstractFirebaseAuth;

public final class TenantAwareFirebaseAuth
extends AbstractFirebaseAuth {
    private final String tenantId;

    TenantAwareFirebaseAuth(FirebaseApp firebaseApp, String tenantId) {
        super(TenantAwareFirebaseAuth.builderFromAppAndTenantId(firebaseApp, tenantId));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0);
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    protected void doDestroy() {
    }
}

