/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.internal.BaseCredential;
import com.google.firebase.internal.NonNull;
import java.io.IOException;
import java.io.InputStream;

public class FirebaseCredentials {
    private FirebaseCredentials() {
    }

    @NonNull
    public static FirebaseCredential applicationDefault() {
        return DefaultCredentialsHolder.INSTANCE;
    }

    @NonNull
    public static FirebaseCredential applicationDefault(HttpTransport transport, JsonFactory jsonFactory) {
        try {
            return new ApplicationDefaultCredential(transport);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static FirebaseCredential fromCertificate(InputStream serviceAccount) throws IOException {
        return FirebaseCredentials.fromCertificate(serviceAccount, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @NonNull
    public static FirebaseCredential fromCertificate(InputStream serviceAccount, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccount, (HttpTransportFactory)FirebaseCredentials.wrap(transport));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentials.getProjectId()) ? 1 : 0) != 0, (Object)"Failed to parse service account: 'project_id' must be set");
        return new CertCredential(credentials);
    }

    @NonNull
    public static FirebaseCredential fromRefreshToken(InputStream refreshToken) throws IOException {
        return FirebaseCredentials.fromRefreshToken(refreshToken, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @NonNull
    public static FirebaseCredential fromRefreshToken(InputStream refreshToken, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        return new RefreshTokenCredential(refreshToken, transport);
    }

    private static HttpTransportFactory wrap(final HttpTransport transport) {
        Preconditions.checkNotNull((Object)transport, (Object)"HttpTransport must not be null");
        return new HttpTransportFactory(){

            public HttpTransport create() {
                return transport;
            }
        };
    }

    private static class DefaultCredentialsHolder {
        static final FirebaseCredential INSTANCE = FirebaseCredentials.applicationDefault(Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());

        private DefaultCredentialsHolder() {
        }
    }

    static class RefreshTokenCredential
    extends BaseCredential {
        RefreshTokenCredential(InputStream inputStream, HttpTransport transport) throws IOException {
            super((GoogleCredentials)UserCredentials.fromStream((InputStream)inputStream, (HttpTransportFactory)FirebaseCredentials.wrap(transport)));
        }
    }

    static class ApplicationDefaultCredential
    extends BaseCredential {
        ApplicationDefaultCredential(HttpTransport transport) throws IOException {
            super(GoogleCredentials.getApplicationDefault((HttpTransportFactory)FirebaseCredentials.wrap(transport)));
        }
    }

    static class CertCredential
    extends BaseCredential {
        CertCredential(ServiceAccountCredentials credentials) throws IOException {
            super((GoogleCredentials)credentials);
        }
    }
}

