/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.PersistentConnectionImpl;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadPoolEventTarget;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.logging.DefaultLogger;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import com.google.firebase.database.tubesock.ThreadInitializer;
import com.google.firebase.database.tubesock.WebSocket;
import com.google.firebase.database.utilities.DefaultRunLoop;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

class GaePlatform
implements Platform {
    private static final String TAG = "GaePlatform";
    private static final String PROCESS_PLATFORM = "AppEngine";
    private final FirebaseApp firebaseApp;
    ThreadFactory threadFactoryInstance;

    public GaePlatform(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    public static boolean isActive() {
        return GaeThreadFactory.isAvailable();
    }

    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    private ThreadFactory getGaeThreadFactory() {
        GaeThreadFactory threadFactory = GaeThreadFactory.getInstance();
        Preconditions.checkState((boolean)threadFactory.isUsingBackgroundThreads(), (Object)"Failed to initialize a GAE background thread factory");
        return threadFactory;
    }

    public void initialize() {
        WebSocket.setThreadFactory(this.getGaeThreadFactory(), new ThreadInitializer(){

            @Override
            public void setName(Thread thread, String s) {
            }
        });
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        RevivingScheduledExecutor eventExecutor = new RevivingScheduledExecutor(this.getGaeThreadFactory(), "FirebaseDatabaseEventTarget", true);
        return new ThreadPoolEventTarget(eventExecutor);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger(RunLoop.class);
        return new DefaultRunLoop(this.getGaeThreadFactory(), true, context){

            @Override
            public void handleException(Throwable e) {
                logger.error(DefaultRunLoop.messageForException(e), e);
            }
        };
    }

    @Override
    public AuthTokenProvider newAuthTokenProvider(ScheduledExecutorService executorService) {
        return new JvmAuthTokenProvider(this.firebaseApp, executorService);
    }

    @Override
    public PersistentConnection newPersistentConnection(Context context, ConnectionContext connectionContext, HostInfo info, PersistentConnection.Delegate delegate) {
        return new PersistentConnectionImpl(context.getConnectionContext(), info, delegate);
    }

    @Override
    public String getUserAgent(Context ctx) {
        return "AppEngine/AdminJava";
    }

    @Override
    public String getPlatformVersion() {
        return "gae-" + FirebaseDatabase.getSdkVersion();
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }
}

