/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.ContinueWithCompletionListener;
import com.google.firebase.tasks.ContinueWithTaskCompletionListener;
import com.google.firebase.tasks.OnCompleteCompletionListener;
import com.google.firebase.tasks.OnCompleteListener;
import com.google.firebase.tasks.OnFailureCompletionListener;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessCompletionListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListenerQueue;
import com.google.firebase.tasks.TaskExecutors;
import java.util.concurrent.Executor;

final class TaskImpl<T>
extends Task<T> {
    private final Object lock = new Object();
    private final TaskCompletionListenerQueue<T> listenerQueue = new TaskCompletionListenerQueue();
    @GuardedBy(value="lock")
    private boolean complete;
    @GuardedBy(value="lock")
    private T result;
    @GuardedBy(value="lock")
    private Exception exception;

    TaskImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.lock;
        synchronized (object) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccessful() {
        Object object = this.lock;
        synchronized (object) {
            return this.complete && this.exception == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getResult() {
        Object object = this.lock;
        synchronized (object) {
            this.checkCompleteLocked();
            if (this.exception != null) {
                throw new RuntimeExecutionException(this.exception);
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends Throwable> T getResult(@NonNull Class<X> exceptionType) throws X {
        Object object = this.lock;
        synchronized (object) {
            this.checkCompleteLocked();
            if (exceptionType.isInstance(this.exception)) {
                throw (Throwable)exceptionType.cast(this.exception);
            }
            if (this.exception != null) {
                throw new RuntimeExecutionException(this.exception);
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotCompleteLocked();
            this.complete = true;
            this.result = result;
        }
        this.listenerQueue.flush(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Exception getException() {
        Object object = this.lock;
        synchronized (object) {
            return this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(@NonNull Exception e) {
        Preconditions.checkNotNull((Object)e, (Object)"Exception must not be null");
        Object object = this.lock;
        synchronized (object) {
            this.checkNotCompleteLocked();
            this.complete = true;
            this.exception = e;
        }
        this.listenerQueue.flush(this);
    }

    @Override
    @NonNull
    public Task<T> addOnSuccessListener(@NonNull OnSuccessListener<? super T> listener) {
        return this.addOnSuccessListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<T> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super T> listener) {
        this.listenerQueue.add(new OnSuccessCompletionListener<T>(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public Task<T> addOnFailureListener(@NonNull OnFailureListener listener) {
        return this.addOnFailureListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<T> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener listener) {
        this.listenerQueue.add(new OnFailureCompletionListener(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public Task<T> addOnCompleteListener(@NonNull OnCompleteListener<T> listener) {
        return this.addOnCompleteListener(TaskExecutors.DEFAULT_THREAD_POOL, listener);
    }

    @Override
    @NonNull
    public Task<T> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<T> listener) {
        this.listenerQueue.add(new OnCompleteCompletionListener<T>(executor, listener));
        this.flushIfComplete();
        return this;
    }

    @Override
    @NonNull
    public <R> Task<R> continueWith(@NonNull Continuation<T, R> continuation) {
        return this.continueWith(TaskExecutors.DEFAULT_THREAD_POOL, continuation);
    }

    @Override
    @NonNull
    public <R> Task<R> continueWith(@NonNull Executor executor, @NonNull Continuation<T, R> continuation) {
        TaskImpl<T> continuationTask = new TaskImpl<T>();
        this.listenerQueue.add(new ContinueWithCompletionListener<T, R>(executor, continuation, continuationTask));
        this.flushIfComplete();
        return continuationTask;
    }

    @Override
    @NonNull
    public <R> Task<R> continueWithTask(@NonNull Continuation<T, Task<R>> continuation) {
        return this.continueWithTask(TaskExecutors.DEFAULT_THREAD_POOL, continuation);
    }

    @Override
    @NonNull
    public <R> Task<R> continueWithTask(@NonNull Executor executor, @NonNull Continuation<T, Task<R>> continuation) {
        TaskImpl<T> continuationTask = new TaskImpl<T>();
        this.listenerQueue.add(new ContinueWithTaskCompletionListener<T, R>(executor, continuation, continuationTask));
        this.flushIfComplete();
        return continuationTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.result = result;
        }
        this.listenerQueue.flush(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trySetException(@NonNull Exception e) {
        Preconditions.checkNotNull((Object)e, (Object)"Exception must not be null");
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.exception = e;
        }
        this.listenerQueue.flush(this);
        return true;
    }

    @GuardedBy(value="lock")
    private void checkCompleteLocked() {
        Preconditions.checkState((boolean)this.complete, (Object)"Task is not yet complete");
    }

    @GuardedBy(value="lock")
    private void checkNotCompleteLocked() {
        Preconditions.checkState((!this.complete ? 1 : 0) != 0, (Object)"Task is already complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIfComplete() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.complete) {
                return;
            }
        }
        this.listenerQueue.flush(this);
    }
}

