/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.cloud;

import com.google.auth.Credentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;

public class FirestoreClient {
    private final Firestore firestore;
    private static final String SERVICE_ID = FirestoreClient.class.getName();

    private FirestoreClient(FirebaseApp app) {
        Preconditions.checkNotNull((Object)app, (Object)"FirebaseApp must not be null");
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required for accessing Firestore. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GCLOUD_PROJECT environment variable.");
        this.firestore = (Firestore)((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setCredentials((Credentials)ImplFirebaseTrampolines.getCredentials(app))).setProjectId(projectId)).build().getService();
    }

    @NonNull
    public static Firestore getFirestore() {
        return FirestoreClient.getFirestore(FirebaseApp.getInstance());
    }

    @NonNull
    public static Firestore getFirestore(FirebaseApp app) {
        return FirestoreClient.getInstance((FirebaseApp)app).firestore;
    }

    private static synchronized FirestoreClient getInstance(FirebaseApp app) {
        FirestoreClientService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirestoreClientService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirestoreClientService(app));
        }
        return (FirestoreClient)service.getInstance();
    }

    private static class FirestoreClientService
    extends FirebaseService<FirestoreClient> {
        FirestoreClientService(FirebaseApp app) {
            super(SERVICE_ID, new FirestoreClient(app));
        }

        @Override
        public void destroy() {
        }
    }
}

