/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskExecutors;
import com.google.firebase.tasks.TaskImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    private Tasks() {
    }

    public static <T> Task<T> forResult(T result) {
        TaskImpl<T> task = new TaskImpl<T>();
        task.setResult(result);
        return task;
    }

    public static <T> Task<T> forException(@NonNull Exception exception) {
        TaskImpl task = new TaskImpl();
        task.setException(exception);
        return task;
    }

    public static <T> Task<T> call(@NonNull Callable<T> callable) {
        return Tasks.call(TaskExecutors.DEFAULT_THREAD_POOL, callable);
    }

    public static <T> Task<T> call(@NonNull Executor executor, final @NonNull Callable<T> callable) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull(callable, (Object)"Callback must not be null");
        final TaskImpl task = new TaskImpl();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.setResult(callable.call());
                }
                catch (Exception e) {
                    task.setException(e);
                }
            }
        });
        return task;
    }

    public static <T> T await(@NonNull Task<T> task) throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.getResultOrThrowExecutionException(task);
        }
        AwaitListener listener = new AwaitListener();
        Tasks.addListener(task, listener);
        listener.await();
        return Tasks.getResultOrThrowExecutionException(task);
    }

    public static <T> T await(@NonNull Task<T> task, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.getResultOrThrowExecutionException(task);
        }
        AwaitListener listener = new AwaitListener();
        Tasks.addListener(task, listener);
        if (!listener.await(timeout, unit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.getResultOrThrowExecutionException(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> tasks) {
        if (tasks.isEmpty()) {
            return Tasks.forResult(null);
        }
        for (Task<?> task : tasks) {
            if (task != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        TaskImpl<Void> whenAllTask = new TaskImpl<Void>();
        WhenAllListener listener = new WhenAllListener(tasks.size(), whenAllTask);
        for (Task<?> task : tasks) {
            Tasks.addListener(task, listener);
        }
        return whenAllTask;
    }

    public static Task<Void> whenAll(Task<?> ... tasks) {
        if (tasks.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(tasks));
    }

    private static <T> T getResultOrThrowExecutionException(Task<T> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void addListener(Task<?> task, CombinedListener listener) {
        task.addOnSuccessListener(TaskExecutors.DIRECT, listener);
        task.addOnFailureListener(TaskExecutors.DIRECT, listener);
    }

    private static final class WhenAllListener
    implements CombinedListener {
        private final Object lock = new Object();
        private final int numTasks;
        private final TaskImpl<Void> task;
        @GuardedBy(value="lock")
        private int successCounter;
        @GuardedBy(value="lock")
        private int failuresCounter;
        @GuardedBy(value="lock")
        private Exception exception;

        public WhenAllListener(int taskCount, TaskImpl<Void> task) {
            this.numTasks = taskCount;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Exception exception) {
            Object object = this.lock;
            synchronized (object) {
                ++this.failuresCounter;
                this.exception = exception;
                this.checkForCompletionLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(Object obj) {
            Object object = this.lock;
            synchronized (object) {
                ++this.successCounter;
                this.checkForCompletionLocked();
            }
        }

        @GuardedBy(value="lock")
        private void checkForCompletionLocked() {
            if (this.successCounter + this.failuresCounter == this.numTasks) {
                if (this.exception == null) {
                    this.task.setResult(null);
                } else {
                    this.task.setException(new ExecutionException(this.failuresCounter + " out of " + this.numTasks + " underlying tasks failed", this.exception));
                }
            }
        }
    }

    private static final class AwaitListener
    implements CombinedListener {
        private final CountDownLatch latch = new CountDownLatch(1);

        private AwaitListener() {
        }

        @Override
        public void onSuccess(Object obj) {
            this.latch.countDown();
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }

    static interface CombinedListener
    extends OnSuccessListener<Object>,
    OnFailureListener {
    }
}

